/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExtraClassDescriptorFlags
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    private int flags;

    public ExtraClassDescriptorFlags(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean hasObjcResilientClassStub() {
        return (this.flags & 1) != 0;
    }

    @Override
    public String getStructureName() {
        return ExtraClassDescriptorFlags.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "extra class descriptor flags";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 4);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(BOOL, 1, "HasObjCResilientClassStub", "Set if the context descriptor includes a pointer to an Objective-C resilient class stub structure. Only meaningful for class descriptors when Objective-C interop is enabled.");
            struct.addBitField(DWORD, 31, "reserved", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

