/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class AssociatedTypeRecord
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 8;
    private String name;
    private String substitutedTypeName;

    public AssociatedTypeRecord(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.name = reader.readNext(SwiftUtils::relativeString);
        this.substitutedTypeName = reader.readNext(SwiftUtils::relativeString);
    }

    public String getName() {
        return this.name;
    }

    public String getSubstitutedTypeName() {
        return this.substitutedTypeName;
    }

    @Override
    public String getStructureName() {
        return AssociatedTypeRecord.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "associated type record";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_STRING, "Name", "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "SubstitutedTypeName", "");
        return struct;
    }
}

