/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2MethodList;
import ghidra.app.util.bin.format.objc.objc2.Objc2PropertyList;
import ghidra.app.util.bin.format.objc.objc2.Objc2ProtocolList;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2Protocol
extends ObjcTypeMetadataStructure {
    public static final String NAME = "protocol_t";
    private long isa;
    private String name;
    private Objc2ProtocolList protocols;
    private Objc2MethodList instanceMethods;
    private Objc2MethodList classMethods;
    private Objc2MethodList optionalInstanceMethods;
    private Objc2MethodList optionalClassMethods;
    private Objc2PropertyList instanceProperties;
    private long unknown0;
    private long unknown1;

    public Objc2Protocol(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.isa = ObjcUtils.readNextIndex(reader, this.is32bit);
        this.readName(reader);
        this.readProtocols(reader);
        this.readInstanceMethods(reader);
        this.readClassMethods(reader);
        this.readOptionalInstanceMethods(reader);
        this.readOptionalClassMethods(reader);
        this.readInstanceProperties(reader);
        if (this.is32bit) {
            this.unknown0 = reader.readNextUnsignedInt();
            this.unknown1 = reader.readNextUnsignedInt();
        } else {
            this.unknown0 = reader.readNextLong();
            this.unknown1 = reader.readNextLong();
        }
    }

    public long getIsa() {
        return this.isa;
    }

    public String getName() {
        return this.name;
    }

    public Objc2ProtocolList getProtocols() {
        return this.protocols;
    }

    public Objc2MethodList getInstanceMethods() {
        return this.instanceMethods;
    }

    public Objc2MethodList getClassMethods() {
        return this.classMethods;
    }

    public Objc2MethodList getOptionalInstanceMethods() {
        return this.optionalInstanceMethods;
    }

    public Objc2MethodList getOptionalClassMethods() {
        return this.optionalClassMethods;
    }

    public Objc2PropertyList getInstanceProperties() {
        return this.instanceProperties;
    }

    public long getUnknown0() {
        return this.unknown0;
    }

    public long getUnknown1() {
        return this.unknown1;
    }

    public long getIndex() {
        return this.base;
    }

    private void readProtocols(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.protocols = new Objc2ProtocolList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readName(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            this.name = reader.readAsciiString(index);
        }
    }

    private void readInstanceMethods(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readClassMethods(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.classMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.CLASS);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readOptionalInstanceMethods(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.optionalInstanceMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readOptionalClassMethods(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.optionalClassMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.CLASS);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceProperties(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceProperties = new Objc2PropertyList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (this.is32bit) {
            struct.add(DWORD, "isa", null);
        } else {
            struct.add(QWORD, "isa", null);
        }
        struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "name", null);
        struct.add((DataType)new PointerDataType(Objc2ProtocolList.toGenericDataType(this.is32bit)), this.pointerSize, "protocols", null);
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "instanceMethods", null);
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "classMethods", null);
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "optionalInstanceMethods", null);
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "optionalClassMethods", null);
        struct.add((DataType)new PointerDataType(Objc2PropertyList.toGenericDataType()), this.pointerSize, "instanceProperties", null);
        if (this.is32bit) {
            struct.add(DWORD, "unknown0", null);
            struct.add(DWORD, "unknown1", null);
        } else {
            struct.add(QWORD, "unknown0", null);
            struct.add(QWORD, "unknown1", null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = ObjcUtils.toAddress(this.program, this.getIndex());
        try {
            ObjcUtils.createData(this.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace protocolNamespace = ObjcUtils.createNamespace(this.program, "objc", NAME);
            ObjcUtils.createSymbol(this.program, protocolNamespace, this.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocols != null) {
            this.protocols.applyTo(namespace, monitor);
        }
        if (this.instanceMethods != null) {
            this.instanceMethods.applyTo(namespace, monitor);
        }
        if (this.classMethods != null) {
            this.classMethods.applyTo(namespace, monitor);
        }
        if (this.optionalInstanceMethods != null) {
            this.optionalInstanceMethods.applyTo(namespace, monitor);
        }
        if (this.optionalClassMethods != null) {
            this.optionalClassMethods.applyTo(namespace, monitor);
        }
        if (this.instanceProperties != null) {
            this.instanceProperties.applyTo(namespace, monitor);
        }
    }
}

