/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class Objc2Constants {
    public static final String OBJC2_PREFIX = "__objc_";
    public static final String OBJC2_CATEGORY_LIST = "__objc_catlist";
    public static final String OBJC2_CLASS_LIST = "__objc_classlist";
    public static final String OBJC2_CLASS_REFS = "__objc_classrefs";
    public static final String OBJC2_CONST = "__objc_const";
    public static final String OBJC2_DATA = "__objc_data";
    public static final String OBJC2_IMAGE_INFO = "__objc_imageinfo";
    public static final String OBJC2_MESSAGE_REFS = "__objc_msgrefs";
    public static final String OBJC2_NON_LAZY_CLASS_LIST = "__objc_nlclslist";
    public static final String OBJC2_PROTOCOL_LIST = "__objc_protolist";
    public static final String OBJC2_PROTOCOL_REFS = "__objc_protorefs";
    public static final String OBJC2_SELECTOR_REFS = "__objc_selrefs";
    public static final String OBJC2_SUPER_REFS = "__objc_superrefs";
    public static final String OBJC2_STUBS = "__objc_stubs";
    public static final String NAMESPACE = "objc2";
    public static final String CATEGORY = "/_objc2_";
    public static final CategoryPath CATEGORY_PATH = new CategoryPath("/_objc2_");

    public static final List<String> getObjectiveC2SectionNames() {
        Field[] declaredFields;
        ArrayList<String> sectionNames = new ArrayList<String>();
        for (Field field : declaredFields = Objc2Constants.class.getDeclaredFields()) {
            try {
                String name;
                Object object = field.get(null);
                if (!(object instanceof String) || (name = (String)object).equals(OBJC2_PREFIX) || !name.startsWith(OBJC2_PREFIX)) continue;
                sectionNames.add(name);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        sectionNames.add("__data");
        return sectionNames;
    }

    public static final boolean isObjectiveC2(Program program) {
        String format = program.getExecutableFormat();
        if ("Mac OS X Mach-O".equals(format) || "DYLD Cache".equals(format) || "Extracted DYLD Component".equals(format)) {
            MemoryBlock[] blocks;
            for (MemoryBlock memoryBlock : blocks = program.getMemory().getBlocks()) {
                if (!memoryBlock.getName().startsWith(OBJC2_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }
}

