/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1SymbolTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc1Module
extends ObjcTypeMetadataStructure {
    private int version;
    private int size;
    private String name;
    private Objc1SymbolTable symbolTable;

    public Objc1Module(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.version = reader.readNextInt();
        this.size = reader.readNextInt();
        this.name = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        int symbolTableIndex = reader.readNextInt();
        if (symbolTableIndex != 0) {
            this.symbolTable = new Objc1SymbolTable(program, state, reader.clone(symbolTableIndex));
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public Objc1SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        try {
            DataUtilities.createData((Program)this.program, (Address)address, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)("Could not create " + dt.getName() + " @" + String.valueOf(address)));
        }
        if (this.symbolTable != null) {
            this.symbolTable.applyTo(namespace, monitor);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_module", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "size", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1SymbolTable.toGenericDataType(), (int)this.pointerSize), "symtab", null);
        return struct;
    }
}

