/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc1InstanceVariable
extends ObjcTypeMetadataStructure {
    private String name;
    private String type;
    private int offset;

    Objc1InstanceVariable(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.name = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.type = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.offset = reader.readNextInt();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_ivar", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "ivar_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "ivar_type", null);
        struct.add(DWORD, "ivar_offset", null);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
    }
}

