/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.LEB128;
import ghidra.program.model.data.UnsignedLeb128DataType;
import ghidra.program.model.listing.CommentType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GoPcValueEvaluator {
    private final int pcquantum;
    private final long funcEntry;
    private final BinaryReader reader;
    private final long startPosition;
    private final long pctabOffset;
    private int value = -1;
    private long pc;

    public GoPcValueEvaluator(GoFuncData func, long offset) throws IOException {
        GoModuledata moduledata = func.getModuledata();
        this.pcquantum = moduledata.getGoBinary().getMinLC();
        this.reader = moduledata.getPcValueTable().getElementReader(1, (int)offset);
        this.startPosition = this.reader.getPointerIndex();
        this.pctabOffset = offset;
        this.pc = this.funcEntry = func.getFuncAddress().getOffset();
    }

    public long getPC() {
        return this.pc;
    }

    public void reset() {
        this.reader.setPointerIndex(this.startPosition);
        this.value = -1;
        this.pc = this.funcEntry;
    }

    public long getMaxPC() throws IOException {
        this.eval(Long.MAX_VALUE);
        return this.pc;
    }

    public int eval(long targetPC) throws IOException {
        while (this.pc <= targetPC) {
            if (this.step()) continue;
            return -1;
        }
        return this.value;
    }

    public int evalNext() throws IOException {
        return this.eval(this.pc);
    }

    public List<Integer> evalAll(long targetPC) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (this.pc <= targetPC) {
            if (!this.step()) {
                return result;
            }
            result.add(this.value);
        }
        return result;
    }

    private boolean step() throws IOException {
        int uvdelta = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (uvdelta == 0 && this.pc != this.funcEntry) {
            return false;
        }
        this.value += -(uvdelta & 1) ^ uvdelta >> 1;
        int pcdelta = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        this.pc += (long)(pcdelta * this.pcquantum);
        return true;
    }

    public void markup(MarkupSession session) throws IOException {
        Address startAddr = session.getMappingContext().getDataAddress(this.startPosition);
        if (session.getMarkedupAddresses().contains(startAddr)) {
            return;
        }
        session.labelAddress(startAddr, "pctab[0x%x]".formatted(this.pctabOffset));
        int count = 0;
        while (this.markupStep(session)) {
            ++count;
        }
        long size = this.reader.getPointerIndex() - this.startPosition;
        String msg = "stepcount=%d,size=%d".formatted(count, size);
        DWARFUtil.appendComment(session.getProgram(), startAddr, CommentType.PRE, "", msg, ",");
    }

    private boolean markupStep(MarkupSession session) throws IOException {
        LEB128Info uvdeltaInfo = this.reader.readNext(LEB128Info::unsigned);
        Address uvdeltaAddr = session.getMappingContext().getDataAddress(uvdeltaInfo.getOffset());
        if (session.getMarkedupAddresses().contains(uvdeltaAddr)) {
            return false;
        }
        session.markupAddress(uvdeltaAddr, (DataType)UnsignedLeb128DataType.dataType, uvdeltaInfo.getLength());
        int uvdelta = uvdeltaInfo.asUInt32();
        if (uvdelta == 0 && this.pc != this.funcEntry) {
            DWARFUtil.appendComment(session.getProgram(), uvdeltaAddr, CommentType.EOL, "", "end", ",");
            return false;
        }
        int vdelta = -(uvdelta & 1) ^ uvdelta >> 1;
        this.value += vdelta;
        String msg = "value+%d=0x%x".formatted(vdelta, this.value);
        DWARFUtil.appendComment(session.getProgram(), uvdeltaAddr, CommentType.EOL, "", msg, ",");
        LEB128Info pcdeltaInfo = this.reader.readNext(LEB128Info::unsigned);
        Address pcdeltaAddr = session.getMappingContext().getDataAddress(pcdeltaInfo.getOffset());
        session.markupAddress(pcdeltaAddr, (DataType)UnsignedLeb128DataType.dataType, pcdeltaInfo.getLength());
        int pcdelta = pcdeltaInfo.asUInt32();
        this.pc += (long)(pcdelta * this.pcquantum);
        msg = "pc+0x%x=+0x%08x".formatted(pcdelta * this.pcquantum, this.pc - this.funcEntry);
        DWARFUtil.appendComment(session.getProgram(), pcdeltaAddr, CommentType.EOL, "", msg, ",");
        return true;
    }
}

