/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.elf.info.StandardElfInfoProducer;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.IOException;

public class GnuDebugAltLink
implements ElfInfoItem {
    public static final String SECTION_NAME = ".gnu_debugaltlink";
    private final int filenameLen;
    private final String filename;
    private final byte[] hashBytes;

    public static GnuDebugAltLink fromProgram(Program program) {
        ElfInfoItem.ItemWithAddress<GnuDebugAltLink> wrappedItem = ElfInfoItem.readItemFromSection(program, SECTION_NAME, GnuDebugAltLink::read);
        return wrappedItem != null ? wrappedItem.item() : null;
    }

    public static GnuDebugAltLink read(BinaryReader br, Program program) {
        try {
            long filenameStart = br.getPointerIndex();
            String filename = br.readNextAsciiString();
            int filenameLen = (int)(br.getPointerIndex() - filenameStart);
            long hashSize = br.length() - br.getPointerIndex();
            if (hashSize > 1024L) {
                throw new IOException();
            }
            byte[] hashBytes = br.readNextByteArray((int)hashSize);
            return new GnuDebugAltLink(filenameLen, filename, hashBytes);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public GnuDebugAltLink(int filenameLen, String filename, byte[] hashBytes) {
        this.filenameLen = filenameLen;
        this.filename = filename;
        this.hashBytes = hashBytes;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getFilenameLen() {
        return this.filenameLen;
    }

    public byte[] getHashBytes() {
        return this.hashBytes;
    }

    public String getHash() {
        return NumericUtilities.convertBytesToString((byte[])this.hashBytes);
    }

    @Override
    public void markupProgram(Program program, Address address) {
        program.getOptions("Program Information").setString("GNU DebugAltLink Filename", this.getFilename());
        program.getOptions("Program Information").setString("GNU DebugAltLink Hash", this.getHash());
        try {
            StructureDataType struct = this.toStructure((DataTypeManager)program.getDataTypeManager());
            if (struct != null) {
                DataUtilities.createData((Program)program, (Address)address, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup GnuDebugAltLink at %s: %s".formatted(address, this));
        }
    }

    private StructureDataType toStructure(DataTypeManager dtm) {
        if (this.filenameLen <= 0) {
            return null;
        }
        StructureDataType result = new StructureDataType(StandardElfInfoProducer.ELF_CATEGORYPATH, "GnuDebugAltLink_%d".formatted(this.filenameLen), 0, dtm);
        result.add((DataType)StringDataType.dataType, this.filenameLen, "filename", null);
        result.add((DataType)new ArrayDataType(StructConverter.BYTE, this.hashBytes.length), "hash", null);
        return result;
    }

    public String toString() {
        return String.format("GnuDebugAltLink [filename=%s, hash=%s]", this.filename, this.getHash());
    }
}

