/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.elf.info.GnuBuildAttribute;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GnuBuildAttributes
implements ElfInfoItem {
    public static final String SECTION_NAME = ".gnu.build.attributes";
    private List<AttributeWithOffset> items;

    public static GnuBuildAttributes read(BinaryReader reader, Program program) {
        ArrayList<AttributeWithOffset> results = new ArrayList<AttributeWithOffset>();
        while (reader.hasNext()) {
            long offset = reader.getPointerIndex();
            try {
                GnuBuildAttribute gba = reader.readNext(GnuBuildAttribute::read);
                results.add(new AttributeWithOffset(offset, gba));
            }
            catch (IOException e) {
                Msg.error(GnuBuildAttribute.class, (Object)"Failed to read GnuBuildAttributes at %d".formatted(offset));
                break;
            }
        }
        return new GnuBuildAttributes(results);
    }

    public GnuBuildAttributes(List<AttributeWithOffset> items) {
        this.items = items;
    }

    @Override
    public void markupProgram(Program program, Address address) {
        ArrayList<GnuBuildAttribute> subList = new ArrayList<GnuBuildAttribute>();
        GnuBuildAttribute.AttributeType prevAttrType = null;
        GnuBuildAttribute.AddressPair prevAddrs = null;
        for (AttributeWithOffset item : this.items) {
            GnuBuildAttribute attr = item.attr;
            attr.markupProgram(program, address.add(item.offset));
            GnuBuildAttribute.AddressPair addresses = attr.getRange(program);
            if (addresses != null && prevAddrs != null && !prevAddrs.equals(addresses) || attr.getAttributeType() != prevAttrType) {
                this.markupRange(subList, program);
                subList.clear();
                prevAddrs = addresses;
            }
            prevAttrType = attr.getAttributeType();
            subList.add(attr);
        }
        this.markupRange(subList, program);
    }

    private void markupRange(List<GnuBuildAttribute> attrs, Program program) {
        if (attrs.isEmpty()) {
            return;
        }
        GnuBuildAttribute first = attrs.getFirst();
        GnuBuildAttribute.AddressPair range = first.getRange(program);
        if (range == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (GnuBuildAttribute attr : attrs) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(attr.getDescription(program));
        }
        GnuBuildAttribute.appendComment(program, range.first(), CommentType.EOL, "", "start gnu build attribs(%s) %s\n%s".formatted(first.getAttributeType().getDescription(), range, sb), "\n");
        GnuBuildAttribute.appendComment(program, range.second(), CommentType.EOL, "", "end gnu build attribs(%s) %s\n%s".formatted(first.getAttributeType().getDescription(), range, sb), "\n");
    }

    public record AttributeWithOffset(long offset, GnuBuildAttribute attr) {
    }
}

