/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugFileProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class BuildIdDebugFileProvider
implements DebugFileProvider {
    private static final String BUILDID_NAME_PREFIX = "build-id://";
    private final File rootDir;

    public static boolean matches(String name) {
        return name.startsWith(BUILDID_NAME_PREFIX);
    }

    public static BuildIdDebugFileProvider create(String name, DebugInfoProviderCreatorContext context) {
        name = name.substring(BUILDID_NAME_PREFIX.length());
        return new BuildIdDebugFileProvider(new File(name));
    }

    public BuildIdDebugFileProvider(File rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getName() {
        return BUILDID_NAME_PREFIX + this.rootDir.getPath();
    }

    @Override
    public String getDescriptiveName() {
        return this.rootDir.getPath() + " (.build-id dir)";
    }

    @Override
    public DebugInfoProviderStatus getStatus(TaskMonitor monitor) {
        return this.rootDir.isDirectory() ? DebugInfoProviderStatus.VALID : DebugInfoProviderStatus.INVALID;
    }

    @Override
    public File getFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        String buildId = debugInfo.getBuildId();
        if (buildId == null || buildId.length() < 4) {
            return null;
        }
        File bucketDir = new File(this.rootDir, buildId.substring(0, 2));
        File file = new File(bucketDir, buildId.substring(2) + ".debug");
        return file.isFile() ? file : null;
    }
}

