/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.dnd.GenericDataFlavor;
import docking.dnd.StringTransferable;
import docking.widgets.OptionDialog;
import docking.widgets.OptionDialogBuilder;
import ghidra.app.util.ClipboardType;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.MemoryByteIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ByteCopier {
    private static final long LARGE_SELECTION_COUNT = 1000000L;
    public static DataFlavor BYTE_STRING_FLAVOR = ByteCopier.createByteStringLocalDataTypeFlavor();
    public static DataFlavor BYTE_STRING_NO_SPACES_FLAVOR = ByteCopier.createByteStringNoSpacesLocalDataTypeFlavor();
    public static DataFlavor PYTHON_BYTE_STRING_FLAVOR = ByteCopier.createPythonByteStringLocalDataTypeFlavor();
    public static DataFlavor PYTHON_LIST_FLAVOR = ByteCopier.createPythonListLocalDataTypeFlavor();
    public static DataFlavor CPP_BYTE_ARRAY_FLAVOR = ByteCopier.createCppByteArrayLocalDataTypeFlavor();
    protected static final List<ClipboardType> EMPTY_LIST = Collections.emptyList();
    public static final ClipboardType BYTE_STRING_TYPE = new ClipboardType(BYTE_STRING_FLAVOR, "Byte String");
    public static final ClipboardType BYTE_STRING_NO_SPACE_TYPE = new ClipboardType(BYTE_STRING_NO_SPACES_FLAVOR, "Byte String (No Spaces)");
    public static final ClipboardType PYTHON_BYTE_STRING_TYPE = new ClipboardType(PYTHON_BYTE_STRING_FLAVOR, "Python Byte String");
    public static final ClipboardType PYTHON_LIST_TYPE = new ClipboardType(PYTHON_LIST_FLAVOR, "Python List");
    public static final ClipboardType CPP_BYTE_ARRAY_TYPE = new ClipboardType(CPP_BYTE_ARRAY_FLAVOR, "C Array");
    private static final Map<DataFlavor, Pattern> PROGRAMMING_PATTERNS_BY_FLAVOR = Map.of(PYTHON_BYTE_STRING_FLAVOR, Pattern.compile("b'(.*)'"), PYTHON_LIST_FLAVOR, Pattern.compile("\\[(.*)\\]"), CPP_BYTE_ARRAY_FLAVOR, Pattern.compile("\\{(.*)\\}"));
    private static final Pattern PROGRAMMING_BYTES_PATTERN = Pattern.compile("(?:\\\\x|0x)([a-fA-F0-9]{2})");
    protected PluginTool tool;
    protected Program currentProgram;
    protected ProgramSelection currentSelection;
    protected ProgramLocation currentLocation;
    private OptionDialog confirmLargeSelectionDialog;

    private static DataFlavor createByteStringLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--byte string with spaces");
        }
        catch (Exception e) {
            Msg.error(ByteCopier.class, (Object)"Unexpected exception creating data flavor for byte string", (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createByteStringNoSpacesLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--byte string with NO spaces");
        }
        catch (Exception e) {
            Msg.error(ByteCopier.class, (Object)"Unexpected exception creating data flavor for byte string with no spaces", (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createPythonByteStringLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--Python byte string");
        }
        catch (Exception e) {
            Msg.error(ByteCopier.class, (Object)"Unexpected exception creating data flavor for Python byte string", (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createPythonListLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--Python list");
        }
        catch (Exception e) {
            Msg.error(ByteCopier.class, (Object)"Unexpected exception creating data flavor for Python list", (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createCppByteArrayLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--C++ array");
        }
        catch (Exception e) {
            Msg.error(ByteCopier.class, (Object)"Unexpected exception creating data flavor for C array", (Throwable)e);
            return null;
        }
    }

    protected ByteCopier() {
    }

    protected AddressSetView getSelectedAddresses() {
        ProgramSelection addressSet = this.currentSelection;
        if (addressSet == null || addressSet.isEmpty()) {
            return new AddressSet(this.currentLocation.getAddress());
        }
        long size = addressSet.getNumAddresses();
        if (this.skipLargeSelection(size)) {
            return new AddressSet();
        }
        return this.currentSelection;
    }

    private boolean skipLargeSelection(long size) {
        int choice;
        if (size < 1000000L) {
            return false;
        }
        if (this.confirmLargeSelectionDialog == null) {
            String message = "You have copied %,d bytes.\nAre you sure you wish to copy this many bytes?\n".formatted(size);
            this.confirmLargeSelectionDialog = new OptionDialogBuilder("Copy Large Selection?", message).addOption("Continue").addCancel().addDontShowAgainOption().build();
        }
        return (choice = this.confirmLargeSelectionDialog.show()) == 0;
    }

    protected Transferable copyBytes(AddressSetView addresses, boolean includeSpaces, TaskMonitor monitor) {
        return ByteCopier.createStringTransferable(this.copyBytesAsString(addresses, includeSpaces, monitor));
    }

    protected String copyBytesAsString(AddressSetView addresses, boolean includeSpaces, TaskMonitor monitor) {
        String delimiter = includeSpaces ? " " : "";
        return this.copyBytesAsString(addresses, delimiter, monitor);
    }

    protected String copyBytesAsString(AddressSetView addresses, String delimiter, TaskMonitor monitor) {
        Memory memory = this.currentProgram.getMemory();
        ByteIterator bytes = new ByteIterator(addresses, memory);
        return NumericUtilities.convertBytesToString((Iterator)bytes, (String)delimiter);
    }

    private byte[] getBytes(String transferString) {
        byte[] bytes = this.getHexBytes(transferString);
        if (bytes != null) {
            return bytes;
        }
        return this.getAsciiBytes(transferString);
    }

    private byte[] getAsciiBytes(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!StringUtilities.isAsciiChar((char)c)) {
                return null;
            }
            bytes[i] = (byte)c;
        }
        return bytes;
    }

    private String keepOnlyAsciiBytes(String s) {
        byte[] bytes = new byte[s.length()];
        int byteIndex = 0;
        for (int stringIndex = 0; stringIndex < s.length(); ++stringIndex) {
            char c = s.charAt(stringIndex);
            if (!StringUtilities.isAsciiChar((char)c)) continue;
            bytes[byteIndex++] = (byte)c;
        }
        return new String(bytes, 0, byteIndex);
    }

    private boolean isOnlyAsciiBytes(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (StringUtilities.isAsciiChar((char)c)) continue;
            return false;
        }
        return true;
    }

    private byte[] getHexBytes(String s) {
        int length = (s = s.trim().replaceAll("\\s", "")).length();
        if (length % 2 != 0) {
            return null;
        }
        try {
            byte[] data = new byte[length / 2];
            int cindex = 0;
            for (int i = 0; i < data.length; ++i) {
                String byteStr = s.substring(cindex, cindex + 2);
                data[i] = (byte)Integer.parseInt(byteStr, 16);
                cindex += 2;
            }
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Transferable copyBytes(ClipboardType copyType, TaskMonitor monitor) {
        if (copyType == BYTE_STRING_TYPE) {
            String byteString = this.copyBytesAsString(this.getSelectedAddresses(), true, monitor);
            return new ByteStringTransferable(byteString);
        }
        if (copyType == BYTE_STRING_NO_SPACE_TYPE) {
            String byteString = this.copyBytesAsString(this.getSelectedAddresses(), false, monitor);
            return new ByteStringTransferable(byteString);
        }
        if (copyType == PYTHON_BYTE_STRING_TYPE) {
            String prefix = "\\x";
            String bs = this.copyBytesAsString(this.getSelectedAddresses(), prefix, monitor);
            String fixed = "b'" + prefix + bs + "'";
            return new ProgrammingByteStringTransferable(fixed, copyType.getFlavor());
        }
        if (copyType == PYTHON_LIST_TYPE) {
            String prefix = "0x";
            String bs = this.copyBytesAsString(this.getSelectedAddresses(), ", " + prefix, monitor);
            String fixed = "[ " + prefix + bs + " ]";
            return new ProgrammingByteStringTransferable(fixed, copyType.getFlavor());
        }
        if (copyType == CPP_BYTE_ARRAY_TYPE) {
            String prefix = "0x";
            String bs = this.copyBytesAsString(this.getSelectedAddresses(), ", " + prefix, monitor);
            String byteString = "{ " + prefix + bs + " }";
            return new ProgrammingByteStringTransferable(byteString, copyType.getFlavor());
        }
        return null;
    }

    protected boolean pasteBytes(Transferable pasteData) throws UnsupportedFlavorException, IOException {
        String data;
        String byteString;
        DataFlavor[] flavors = pasteData.getTransferDataFlavors();
        DataFlavor byteStringFlavor = this.getByteStringFlavor(flavors);
        if (byteStringFlavor != null) {
            String data2 = (String)pasteData.getTransferData(byteStringFlavor);
            return this.pasteByteString(data2);
        }
        DataFlavor programmingFlavor = this.getProgrammingFlavor(flavors);
        if (programmingFlavor != null && (byteString = this.extractProgrammingBytes(programmingFlavor, data = (String)pasteData.getTransferData(programmingFlavor))) != null) {
            return this.pasteByteString(byteString);
        }
        if (!pasteData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.tool.setStatusInfo("Paste failed: unsupported data type", true);
            return false;
        }
        String string = (String)pasteData.getTransferData(DataFlavor.stringFlavor);
        if (string == null) {
            this.tool.setStatusInfo("Paste failed: no string data", true);
            return false;
        }
        return this.pasteByteString(string);
    }

    private DataFlavor getProgrammingFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!flavor.equals(PYTHON_BYTE_STRING_FLAVOR) && !flavor.equals(PYTHON_LIST_FLAVOR) && !flavor.equals(CPP_BYTE_ARRAY_FLAVOR)) continue;
            return flavor;
        }
        return null;
    }

    private DataFlavor getByteStringFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!flavor.equals(BYTE_STRING_FLAVOR) && !flavor.equals(BYTE_STRING_NO_SPACES_FLAVOR)) continue;
            return flavor;
        }
        return null;
    }

    private String extractProgrammingBytes(DataFlavor flavor, String data) {
        Pattern pattern = PROGRAMMING_PATTERNS_BY_FLAVOR.get(flavor);
        Matcher matcher = pattern.matcher(data);
        if (!matcher.matches()) {
            return null;
        }
        String bytes = matcher.group(1);
        if (bytes == null) {
            return null;
        }
        Matcher bytesMatcher = PROGRAMMING_BYTES_PATTERN.matcher(bytes);
        if (!bytesMatcher.find()) {
            return null;
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append(bytesMatcher.group(1));
        while (bytesMatcher.find()) {
            buffy.append(bytesMatcher.group(1));
        }
        return buffy.toString();
    }

    protected boolean pasteByteString(String string) {
        return this.tool.execute((Command)new PasteByteStringCommand(string), (DomainObject)this.currentProgram);
    }

    public static Transferable createStringTransferable(String text) {
        return new StringTransferable(text);
    }

    private static class ByteIterator
    implements Iterator<Byte> {
        private MemoryByteIterator byteIterator;
        private Byte next;

        ByteIterator(AddressSetView addresses, Memory memory) {
            this.byteIterator = new MemoryByteIterator(memory, addresses);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.byteIterator.hasNext()) {
                return false;
            }
            try {
                this.next = this.byteIterator.next();
            }
            catch (MemoryAccessException e) {
                Msg.error((Object)this, (Object)"Unable to read next byte", (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public Byte next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Byte result = this.next;
            this.next = null;
            return result;
        }
    }

    public static class ByteStringTransferable
    implements Transferable {
        private final DataFlavor[] flavors = new DataFlavor[]{BYTE_STRING_NO_SPACE_TYPE.getFlavor(), BYTE_STRING_TYPE.getFlavor(), DataFlavor.stringFlavor};
        private final List<DataFlavor> flavorList = Arrays.asList(this.flavors);
        private final String byteString;
        private final String stringRepresentation;

        public ByteStringTransferable(String byteString) {
            this(byteString, null);
        }

        public ByteStringTransferable(String byteString, String stringRepresentation) {
            this.byteString = byteString;
            this.stringRepresentation = stringRepresentation;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                if (this.stringRepresentation != null) {
                    return this.stringRepresentation;
                }
                return this.byteString;
            }
            if (flavor.equals(BYTE_STRING_TYPE.getFlavor())) {
                return this.byteString;
            }
            if (flavor.equals(BYTE_STRING_NO_SPACE_TYPE.getFlavor())) {
                return this.byteString;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }

    public static class ProgrammingByteStringTransferable
    implements Transferable {
        private List<DataFlavor> flavorList;
        private DataFlavor[] flavors;
        private DataFlavor programmingFlavor;
        private String byteString;

        public ProgrammingByteStringTransferable(String byteString, DataFlavor flavor) {
            this.byteString = byteString;
            this.programmingFlavor = flavor;
            this.flavors = new DataFlavor[]{flavor, DataFlavor.stringFlavor};
            this.flavorList = Arrays.asList(this.flavors);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.byteString;
            }
            if (flavor.equals(this.programmingFlavor)) {
                return this.byteString;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }

    protected class PasteByteStringCommand
    implements Command<Program> {
        protected final String string;
        private String status = "Pasting";

        protected PasteByteStringCommand(String string) {
            this.string = string;
        }

        public boolean applyTo(Program program) {
            byte[] bytes;
            String validString = this.string;
            if (!ByteCopier.this.isOnlyAsciiBytes(this.string)) {
                ByteCopier.this.tool.setStatusInfo("Pasted string contained non-text ascii bytes. Only the ascii will be used.", true);
                validString = ByteCopier.this.keepOnlyAsciiBytes(this.string);
            }
            if ((bytes = ByteCopier.this.getBytes(validString)) == null) {
                this.status = "Improper data format. Expected sequence of hex bytes";
                ByteCopier.this.tool.beep();
                return false;
            }
            Address address = ByteCopier.this.currentLocation.getAddress();
            if (!this.hasEnoughSpace(program, address, bytes.length)) {
                this.status = "Not enough space to paste all bytes.  Encountered data or instructions.";
                ByteCopier.this.tool.beep();
                return false;
            }
            if (!this.confirmPaste(validString)) {
                return true;
            }
            boolean pastedAllBytes = this.pasteBytes(program, bytes);
            if (!pastedAllBytes) {
                ByteCopier.this.tool.setStatusInfo("Not all bytes were pasted due to memory access issues", true);
            }
            return true;
        }

        protected boolean pasteBytes(Program program, byte[] bytes) {
            boolean foundError = false;
            Address address = ByteCopier.this.currentLocation.getAddress();
            Memory memory = program.getMemory();
            for (byte element : bytes) {
                try {
                    memory.setByte(address, element);
                }
                catch (MemoryAccessException e) {
                    foundError = true;
                }
                address = address.next();
            }
            return !foundError;
        }

        protected boolean confirmPaste(String validString) {
            String partialText = validString.length() < 40 ? validString : validString.substring(0, 40) + " ...";
            int result = OptionDialog.showYesNoDialog(null, (String)"Paste String Into Program?", (String)("Are you sure you want to paste the string \"" + partialText + "\"\n into the program's memory?"));
            return result != 2;
        }

        protected boolean hasEnoughSpace(Program program, Address address, int byteCount) {
            int length;
            Listing listing = program.getListing();
            for (int i = 0; i < byteCount; i += length) {
                Data data;
                if (address == null) {
                    this.status = "Not enough addresses to paste bytes";
                    ByteCopier.this.tool.beep();
                    return false;
                }
                CodeUnit codeUnit = listing.getCodeUnitContaining(address);
                if (!(codeUnit instanceof Data) || (data = (Data)codeUnit).isDefined()) {
                    this.status = "Cannot paste on top of defined instructions/data";
                    ByteCopier.this.tool.beep();
                    return false;
                }
                length = codeUnit.getLength();
                address = codeUnit.getMaxAddress().next();
            }
            return true;
        }

        public String getStatusMsg() {
            return this.status;
        }

        public String getName() {
            return "Paste";
        }
    }
}

