/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDataDecodeFormat;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisUtils;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.DwarfEncodingModeDataType;
import ghidra.app.util.bin.LEB128Info;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.UnsignedLeb128DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.task.TaskMonitor;

public class LSDAHeader
extends GccAnalysisClass {
    static final int OMITTED_ENCODING_TYPE = 255;
    private RegionDescriptor region;
    private static final int BYTE_LEN = new ByteDataType().getLength();
    private int lpStartEncoding = 255;
    private Address lpStartAddr;
    private boolean hasTypeTable = false;
    private int ttypeEncoding = 255;
    private long ttypeOffset;
    private Address ttypeAddr = Address.NO_ADDRESS;
    private byte callSiteTableEncoding = (byte)-1;
    private int callSiteTableLength = 0;
    private long headerSize = 0L;
    private AddressRange tableBounds = null;
    private Address nextAddress;
    private static final int LPSTART_PTR_TYPETABLE_FLAG = 1;
    private int curSize = 0;
    private long callSiteTableHeaderSize;

    public LSDAHeader(TaskMonitor monitor, Program program, RegionDescriptor region) {
        super(monitor, program);
        this.region = region;
    }

    private Address createLPStartEncoding(Address addr) throws MemoryAccessException {
        String comment = "(LSDA) LPStart Encoding";
        LSDAHeader.createAndCommentData(this.program, addr, (DataType)new DwarfEncodingModeDataType(), comment, CommentType.EOL);
        this.lpStartEncoding = GccAnalysisUtils.readByte(this.program, addr);
        this.curSize += BYTE_LEN;
        return addr.add((long)BYTE_LEN);
    }

    private static Address makeAddress(Program program, long offset) {
        AddressFactory addrFactory = program.getAddressFactory();
        AddressSpace ram = addrFactory.getDefaultAddressSpace();
        return addrFactory.getAddress(ram.getSpaceID(), offset);
    }

    private Address createLPStartPointer(Address addr) throws MemoryAccessException {
        String comment = "(LSDA) LPStart Offset";
        DwarfEHDecoder decoder = DwarfDecoderFactory.getDecoder(this.lpStartEncoding);
        if (decoder.getDataFormat() == DwarfEHDataDecodeFormat.DW_EH_PE_omit) {
            this.lpStartAddr = this.region.getRangeStart();
            return addr;
        }
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, addr, this.region.getRangeStart());
        long raw = decoder.decode(ctx);
        long controls = raw & 0xFL;
        this.lpStartAddr = LSDAHeader.makeAddress(this.program, raw |= 0xFL);
        this.hasTypeTable = (controls & 1L) == 1L;
        int encodedLen = ctx.getEncodedLength();
        DataType encodedDt = decoder.getDataType(this.program);
        LSDAHeader.createAndCommentData(this.program, addr, encodedDt, comment, CommentType.EOL);
        this.curSize += encodedLen;
        return addr.add((long)encodedLen);
    }

    private Address createTTypeEncoding(Address addr) throws MemoryAccessException {
        String comment = "(LSDA) TType Encoding";
        this.ttypeEncoding = GccAnalysisUtils.readByte(this.program, addr);
        LSDAHeader.createAndCommentData(this.program, addr, (DataType)new DwarfEncodingModeDataType(), comment, CommentType.EOL);
        this.curSize += BYTE_LEN;
        return addr.add((long)BYTE_LEN);
    }

    private Address createTTypeOffset(Address addr) throws MemoryAccessException {
        String comment = "(LSDA) TType Offset";
        DwarfEHDecoder decoder = DwarfDecoderFactory.getDecoder(this.ttypeEncoding);
        if (decoder.getDataFormat() == DwarfEHDataDecodeFormat.DW_EH_PE_omit) {
            this.ttypeOffset = 0L;
            return addr;
        }
        LEB128Info uleb128 = GccAnalysisUtils.readULEB128Info(this.program, addr);
        this.ttypeOffset = uleb128.asLong() + (long)this.curSize;
        LSDAHeader.createAndCommentData(this.program, addr, (DataType)UnsignedLeb128DataType.dataType, comment, CommentType.EOL);
        return addr.add((long)uleb128.getLength());
    }

    private Address createCallSiteTableEncoding(Address addr) throws MemoryAccessException {
        String comment = "(LSDA) Call Site Table Encoding";
        this.callSiteTableEncoding = GccAnalysisUtils.readByte(this.program, addr);
        LSDAHeader.createAndCommentData(this.program, addr, (DataType)new DwarfEncodingModeDataType(), comment, CommentType.EOL);
        this.curSize += BYTE_LEN;
        return addr.add((long)BYTE_LEN);
    }

    private Address createCallSiteTableLength(Address addr) throws MemoryAccessException {
        String comment = "(LSDA) Call Site Table Length";
        LEB128Info uleb128 = GccAnalysisUtils.readULEB128Info(this.program, addr);
        this.callSiteTableLength = (int)uleb128.asLong();
        LSDAHeader.createAndCommentData(this.program, addr, (DataType)UnsignedLeb128DataType.dataType, comment, CommentType.EOL);
        this.curSize += uleb128.getLength();
        return addr.add((long)uleb128.getLength());
    }

    public void create(Address addr) throws MemoryAccessException {
        if (addr == null || this.monitor.isCancelled()) {
            return;
        }
        this.monitor.setMessage("Creating GCC Exception Table Header");
        Address baseAddr = addr;
        addr = this.createLPStartEncoding(addr);
        addr = this.createLPStartPointer(addr);
        addr = this.createTTypeEncoding(addr);
        Address callSiteTableStart = addr = this.createTTypeOffset(addr);
        addr = this.createCallSiteTableEncoding(addr);
        addr = this.createCallSiteTableLength(addr);
        this.headerSize = addr.subtract(baseAddr);
        this.callSiteTableHeaderSize = addr.subtract(callSiteTableStart);
        Address extent = addr.add((long)(this.getCallSiteTableLength() - 1));
        if (this.ttypeEncoding != 255) {
            extent = this.ttypeAddr = baseAddr.add(this.ttypeOffset);
        }
        this.tableBounds = new AddressRangeImpl(baseAddr, extent);
        String tableLabel = "lsda_exception_table_" + String.valueOf(baseAddr);
        try {
            Symbol sym = this.program.getSymbolTable().getPrimarySymbol(baseAddr);
            if (sym == null) {
                sym = this.program.getSymbolTable().createLabel(baseAddr, tableLabel, SourceType.ANALYSIS);
            } else {
                sym.setName(tableLabel, SourceType.ANALYSIS);
            }
        }
        catch (Exception sym) {
            // empty catch block
        }
        SetCommentCmd commentCmd = new SetCommentCmd(baseAddr, CommentType.PLATE, "(LSDA) Exception Table");
        commentCmd.applyTo(this.program);
        this.nextAddress = addr;
    }

    public Address getNextAddress() {
        return this.nextAddress;
    }

    public AddressRange getBody() {
        return this.tableBounds;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public int getLPStartEncoding() {
        return this.lpStartEncoding;
    }

    public Address getLPStartAddress() {
        return this.lpStartAddr;
    }

    public boolean hasTypeTable() {
        return this.hasTypeTable && this.ttypeAddr != Address.NO_ADDRESS;
    }

    public int getTTypeEncoding() {
        return this.ttypeEncoding;
    }

    public int getTTypeOffset() {
        return (int)this.ttypeOffset;
    }

    public Address getTTypeBaseAddress() {
        return this.ttypeAddr;
    }

    public int getCallSiteTableEncoding() {
        return this.callSiteTableEncoding;
    }

    public int getCallSiteTableLength() {
        return this.callSiteTableLength;
    }

    public int getCallSiteTableHeaderSize() {
        return (int)this.callSiteTableHeaderSize;
    }
}

