/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.vscode;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.options.OptionsService;
import docking.widgets.OptionDialog;
import docking.widgets.values.GValuesMap;
import docking.widgets.values.ValuesMapDialog;
import generic.theme.GIcon;
import ghidra.Ghidra;
import ghidra.GhidraClassLoader;
import ghidra.GhidraRun;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.vscode.VSCodeLauncherTask;
import ghidra.app.services.VSCodeIntegrationService;
import ghidra.features.base.values.GhidraValuesMap;
import ghidra.framework.Application;
import ghidra.framework.main.AppInfo;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Visual Studio Code Integration", description="Allows Ghidra to integrate with Visual Studio Code.", servicesRequired={OptionsService.class}, servicesProvided={VSCodeIntegrationService.class})
public class VSCodeIntegrationPlugin
extends ProgramPlugin
implements VSCodeIntegrationService {
    private ToolOptions options;
    private Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public VSCodeIntegrationPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        super.init();
        this.options = AppInfo.getFrontEndTool().getOptions("Visual Studio Code Integration");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("CreateVSCodeModuleProject", this.name).menuPath(new String[]{"&\u5de5\u5177", "Create VSCode Module Project..."})).menuIcon((Icon)new GIcon("icon.plugin.scriptmanager.edit.vscode"))).description("Creates a new Visual Studio Code module project.")).helpLocation(new HelpLocation("VSCodeIntegration", "VSCodeModuleProject"))).onAction(context -> this.showNewProjectDialog())).buildAndInstall((Tool)this.tool);
    }

    private void showNewProjectDialog() {
        if (!SystemUtilities.isInReleaseMode()) {
            Msg.showInfo((Object)this, (Component)this.tool.getToolFrame(), (String)this.name, (Object)"This action may only run from a built Ghidra release.");
            return;
        }
        String PROJECT_NAME_PROMPT = "Project name";
        String PROJECT_ROOT_PROMPT = "Project root directory";
        GhidraValuesMap values = new GhidraValuesMap();
        values.defineString("Project name");
        values.defineDirectory("Project root directory", new File(System.getProperty("user.home")));
        ValuesMapDialog dialog = new ValuesMapDialog("Create New Visual Studio Code Module Project", null, (GValuesMap)values);
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
        if (dialog.isCancelled()) {
            return;
        }
        values = (GhidraValuesMap)dialog.getValues();
        String projectName = values.getString("Project name");
        File projectRootDir = values.getFile("Project root directory");
        File projectDir = new File(projectRootDir, projectName);
        if (projectDir.exists()) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)this.name, (Object)"Directory '%s' already exists...exiting".formatted(projectDir));
            return;
        }
        try {
            this.createVSCodeModuleProject(projectDir);
            Msg.showInfo((Object)this, (Component)this.tool.getToolFrame(), (String)this.name, (Object)("Successfully created Visual Studio Code module project directory at: " + String.valueOf(projectDir)));
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)this.name, (Object)("Failed to create Visual Studio Code module project directory at: " + String.valueOf(projectDir)), (Throwable)e);
        }
    }

    @Override
    public ToolOptions getVSCodeIntegrationOptions() {
        return this.options;
    }

    @Override
    public File getVSCodeExecutableFile() throws FileNotFoundException {
        File vscodeExecutableFile = this.options.getFile("Visual Studio Code Executable Path", null);
        if (vscodeExecutableFile == null || !vscodeExecutableFile.isFile()) {
            throw new FileNotFoundException("Visual Studio Code installation executable file does not exist.");
        }
        return vscodeExecutableFile;
    }

    @Override
    public void launchVSCode(File file) {
        TaskLauncher.launch((Task)new VSCodeLauncherTask(this, file));
    }

    @Override
    public void handleVSCodeError(String error, boolean askAboutOptions, Throwable t) {
        if (askAboutOptions && !SystemUtilities.isInHeadlessMode()) {
            SystemUtilities.runSwingNow(() -> {
                int choice = OptionDialog.showYesNoDialog(null, (String)"Failed to launch Visual Studio Code", (String)(error + "\nWould you like to verify your \"Visual Studio Code Integration\" options now?"));
                if (choice == 1) {
                    ((OptionsService)AppInfo.getFrontEndTool().getService(OptionsService.class)).showOptionsDialog("Visual Studio Code Integration", null);
                }
            });
        } else {
            Msg.showError(VSCodeIntegrationPlugin.class, null, (String)"Failed to launch Visual Studio Code", (Object)error, (Throwable)t);
        }
    }

    @Override
    public void createVSCodeModuleProject(File projectDir) throws IOException {
        File installDir = Application.getInstallationDirectory().getFile(false);
        Map<String, String> classpathSourceMap = this.getClasspathSourceMap();
        JsonObject settings = this.createSettings(installDir, projectDir, classpathSourceMap, List.of("src/main/java", "ghidra_scripts"), "bin/main");
        JsonObject launch = this.createLaunch(installDir, projectDir, classpathSourceMap, "${workspaceFolder}");
        File vscodeDir = new File(projectDir, ".vscode");
        if (!FileUtilities.mkdirs((File)vscodeDir)) {
            throw new IOException("Failed to create: " + String.valueOf(vscodeDir));
        }
        File settingsFile = new File(vscodeDir, "settings.json");
        File launchFile = new File(vscodeDir, "launch.json");
        FileUtils.writeStringToFile((File)settingsFile, (String)this.gson.toJson((JsonElement)settings), (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)launchFile, (String)this.gson.toJson((JsonElement)launch), (Charset)StandardCharsets.UTF_8);
        this.writeSampleScriptJava(projectDir);
        this.writeSampleScriptPyGhidra(projectDir);
        this.writeSampleModule(installDir, projectDir);
    }

    @Override
    public void addToVSCodeWorkspace(File workspaceFile, File projectDir) throws IOException {
        JsonObject workspace;
        File installDir = Application.getInstallationDirectory().getFile(false);
        Map<String, String> classpathSourceMap = this.getClasspathSourceMap();
        JsonObject settings = this.createSettings(installDir, projectDir, classpathSourceMap, List.of("."), null);
        JsonObject launch = this.createLaunch(installDir, projectDir, classpathSourceMap, null);
        if (workspaceFile.isFile()) {
            String str = FileUtils.readFileToString((File)workspaceFile, (Charset)StandardCharsets.UTF_8);
            JsonElement element = JsonParser.parseString((String)str);
            if (!(element instanceof JsonObject)) {
                throw new IOException("'%s' was not a JsonObject".formatted(workspaceFile));
            }
            JsonObject json = (JsonObject)element;
            workspace = this.addToExistingWorkspace(projectDir, json, settings, launch);
        } else {
            workspace = this.addToExistingWorkspace(projectDir, this.createNewWorkspace(settings, launch), settings, launch);
        }
        if (!FileUtilities.mkdirs((File)workspaceFile.getParentFile())) {
            throw new IOException("Failed to create: " + String.valueOf(workspaceFile.getParentFile()));
        }
        FileUtils.writeStringToFile((File)workspaceFile, (String)this.gson.toJson((JsonElement)workspace), (Charset)StandardCharsets.UTF_8);
    }

    private Map<String, String> getClasspathSourceMap() throws IOException {
        LinkedHashMap<String, String> classpathSourceMap = new LinkedHashMap<String, String>();
        for (String entry : GhidraClassLoader.getClasspath((String)"java.class.path")) {
            entry = new File(entry).getCanonicalPath();
            String sourcePath = entry.substring(0, entry.length() - 4) + "-src.zip";
            if (!entry.endsWith(".jar") || !new File(sourcePath).exists()) {
                sourcePath = null;
            }
            classpathSourceMap.put(entry, sourcePath);
        }
        return classpathSourceMap;
    }

    private JsonObject createSettings(File installDir, File projectDir, Map<String, String> classpathSourceMap, List<String> sourcePaths, String outputPath) throws IOException {
        String gradleVersion = Application.getApplicationProperty((String)"application.gradle.min");
        JsonObject json = new JsonObject();
        json.addProperty("java.import.gradle.enabled", Boolean.valueOf(true));
        json.addProperty("java.import.gradle.wrapper.enabled", Boolean.valueOf(true));
        json.addProperty("java.import.gradle.version", gradleVersion);
        json.addProperty("java.format.settings.url", new File(installDir, "support/eclipse/GhidraEclipseFormatter.xml").getAbsolutePath());
        JsonArray sourcePathArray = new JsonArray();
        json.add("java.project.sourcePaths", (JsonElement)sourcePathArray);
        sourcePaths.forEach(arg_0 -> ((JsonArray)sourcePathArray).add(arg_0));
        if (outputPath != null) {
            json.addProperty("java.project.outputPath", outputPath);
        }
        JsonObject referencedLibrariesObject = new JsonObject();
        json.add("java.project.referencedLibraries", (JsonElement)referencedLibrariesObject);
        JsonArray includeArray = new JsonArray();
        referencedLibrariesObject.add("include", (JsonElement)includeArray);
        classpathSourceMap.keySet().forEach(arg_0 -> ((JsonArray)includeArray).add(arg_0));
        JsonObject sourcesObject = new JsonObject();
        referencedLibrariesObject.add("sources", (JsonElement)sourcesObject);
        classpathSourceMap.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> sourcesObject.addProperty((String)e.getKey(), (String)e.getValue()));
        json.addProperty("python.analysis.stubPath", new File(installDir, "docs/ghidra_stubs/typestubs").getAbsolutePath());
        return json;
    }

    private JsonObject createLaunch(File installDir, File projectDir, Map<String, String> classpathSourceMap, String externalModules) throws IOException {
        String utilityJarPath = classpathSourceMap.keySet().stream().filter(e -> e.endsWith("Utility.jar")).findFirst().orElseThrow();
        ArrayList<String> args = new ArrayList<String>();
        args.add(System.getProperty("java.home") + "/bin/java");
        args.add("-cp");
        args.add(new File(installDir, "support/LaunchSupport.jar").getPath());
        args.add("LaunchSupport");
        args.add(installDir.getPath());
        args.add("-vmArgs");
        ProcessBuilder pb = new ProcessBuilder(args);
        Process p = pb.start();
        List vmArgs = IOUtils.readLines((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
        JsonObject json = new JsonObject();
        json.addProperty("version", "0.2.0");
        JsonArray configurationsArray = new JsonArray();
        json.add("configurations", (JsonElement)configurationsArray);
        JsonObject ghidraConfigObject = new JsonObject();
        configurationsArray.add((JsonElement)ghidraConfigObject);
        ghidraConfigObject.addProperty("type", "java");
        ghidraConfigObject.addProperty("name", "Ghidra");
        ghidraConfigObject.addProperty("request", "launch");
        ghidraConfigObject.addProperty("mainClass", Ghidra.class.getName());
        ghidraConfigObject.addProperty("args", GhidraRun.class.getName());
        JsonArray classPathsArray = new JsonArray();
        ghidraConfigObject.add("classPaths", (JsonElement)classPathsArray);
        classPathsArray.add(utilityJarPath);
        JsonArray vmArgsArray = new JsonArray();
        ghidraConfigObject.add("vmArgs", (JsonElement)vmArgsArray);
        if (externalModules != null) {
            vmArgsArray.add("-Dghidra.external.modules=" + externalModules);
        }
        vmArgs.forEach(arg_0 -> ((JsonArray)vmArgsArray).add(arg_0));
        JsonObject pyghidraConfigObject = new JsonObject();
        configurationsArray.add((JsonElement)pyghidraConfigObject);
        pyghidraConfigObject.addProperty("type", "debugpy");
        pyghidraConfigObject.addProperty("name", "PyGhidra");
        pyghidraConfigObject.addProperty("request", "launch");
        pyghidraConfigObject.addProperty("module", "pyghidra.ghidra_launch");
        pyghidraConfigObject.addProperty("args", GhidraRun.class.getName());
        JsonArray argsArray = new JsonArray();
        pyghidraConfigObject.add("args", (JsonElement)argsArray);
        argsArray.add("--install-dir");
        argsArray.add(installDir.getAbsolutePath());
        argsArray.add("-g");
        argsArray.add(GhidraRun.class.getName());
        JsonObject envObject = new JsonObject();
        pyghidraConfigObject.add("env", (JsonElement)envObject);
        envObject.addProperty("PYGHIDRA_DEBUG", "1");
        JsonObject ghidraAttachObject = new JsonObject();
        configurationsArray.add((JsonElement)ghidraAttachObject);
        ghidraAttachObject.addProperty("type", "java");
        ghidraAttachObject.addProperty("name", "Ghidra Attach");
        ghidraAttachObject.addProperty("request", "attach");
        ghidraAttachObject.addProperty("hostName", "localhost");
        ghidraAttachObject.addProperty("port", (Number)18001);
        return json;
    }

    private JsonObject createNewWorkspace(JsonObject settings, JsonObject launch) {
        JsonObject json = new JsonObject();
        JsonArray foldersArray = new JsonArray();
        json.add("folders", (JsonElement)foldersArray);
        JsonObject folderObject = new JsonObject();
        foldersArray.add((JsonElement)folderObject);
        json.add("settings", (JsonElement)settings);
        json.add("launch", (JsonElement)launch);
        return json;
    }

    private JsonObject addToExistingWorkspace(File projectDir, JsonObject workspace, JsonObject settings, JsonObject launch) {
        File projectParentDir = projectDir.getParentFile();
        Object folderName = projectDir.getName();
        if (projectParentDir != null) {
            folderName = projectParentDir.getName() + "/" + (String)folderName;
        }
        JsonArray foldersArray = workspace.getAsJsonArray("folders");
        JsonObject folderObject = new JsonObject();
        folderObject.addProperty("name", projectDir.getParentFile().getName() + "/" + projectDir.getName());
        folderObject.addProperty("path", projectDir.getAbsolutePath());
        if (!foldersArray.contains((JsonElement)folderObject)) {
            foldersArray.add((JsonElement)folderObject);
        }
        return workspace;
    }

    private void writeSampleScriptJava(File projectDir) throws IOException {
        File scriptsDir = new File(projectDir, "ghidra_scripts");
        File scriptFile = new File(scriptsDir, "SampleScript.java");
        String sampleScript = "// Sample Java GhidraScript\n// @category Examples\nimport ghidra.app.script.GhidraScript;\n\npublic class SampleScript extends GhidraScript {\n\n\t@Override\n\tprotected void run() throws Exception {\n    \tprintln(\"Sample script!\");\n\t}\n}\n";
        if (!FileUtilities.mkdirs((File)scriptFile.getParentFile())) {
            throw new IOException("Failed to create: " + String.valueOf(scriptFile.getParentFile()));
        }
        FileUtils.writeStringToFile((File)scriptFile, (String)sampleScript, (Charset)StandardCharsets.UTF_8);
    }

    private void writeSampleScriptPyGhidra(File projectDir) throws IOException {
        File scriptsDir = new File(projectDir, "ghidra_scripts");
        File scriptFile = new File(scriptsDir, "sample_script.py");
        String sampleScript = "# Sample PyGhidra GhidraScript\n# @category Examples\n# @runtime PyGhidra\n\nfrom java.util import LinkedList\njava_list = LinkedList([1,2,3])\n\nblock = currentProgram.memory.getBlock('.text')\n";
        if (!FileUtilities.mkdirs((File)scriptFile.getParentFile())) {
            throw new IOException("Failed to create: " + String.valueOf(scriptFile.getParentFile()));
        }
        FileUtils.writeStringToFile((File)scriptFile, (String)sampleScript, (Charset)StandardCharsets.UTF_8);
    }

    private void writeSampleModule(File installDir, File projectDir) throws IOException {
        String skeleton = "Skeleton";
        File skeletonDir = new File(installDir, "Extensions/Ghidra/Skeleton");
        FileUtils.copyDirectory((File)skeletonDir, (File)projectDir);
        String projectName = projectDir.getName();
        File srcDir = new File(projectDir, "src/main/java");
        File oldPackageDir = new File(srcDir, skeleton.toLowerCase());
        File newPackageDir = new File(srcDir, projectName.toLowerCase());
        if (!oldPackageDir.renameTo(newPackageDir)) {
            throw new IOException("Failed to rename: " + String.valueOf(oldPackageDir));
        }
        for (File f : newPackageDir.listFiles()) {
            String oldName = f.getName();
            if (!oldName.startsWith(skeleton)) continue;
            String newName = projectName + oldName.substring(skeleton.length(), oldName.length());
            File newFile = new File(f.getParentFile(), newName);
            if (!f.renameTo(newFile)) {
                throw new IOException("Failed to rename: " + String.valueOf(f));
            }
            String fileData = FileUtils.readFileToString((File)newFile, (Charset)StandardCharsets.UTF_8);
            fileData = fileData.replaceAll(skeleton, projectName);
            fileData = fileData.replaceAll(skeleton.toLowerCase(), projectName.toLowerCase());
            fileData = fileData.replaceAll(skeleton.toUpperCase(), projectName.toUpperCase());
            FileUtils.writeStringToFile((File)newFile, (String)fileData, (Charset)StandardCharsets.UTF_8);
        }
        File buildTemplateGradleFile = new File(projectDir, "buildTemplate.gradle");
        File buildGradleFile = new File(projectDir, "build.gradle");
        if (!buildTemplateGradleFile.renameTo(buildGradleFile)) {
            throw new IOException("Failed to rename: " + String.valueOf(buildTemplateGradleFile));
        }
        String fileData = FileUtils.readFileToString((File)buildGradleFile, (Charset)StandardCharsets.UTF_8);
        fileData = fileData.replaceAll("<REPLACE>", FilenameUtils.separatorsToUnix((String)installDir.getPath()));
        FileUtils.writeStringToFile((File)buildGradleFile, (String)fileData, (Charset)StandardCharsets.UTF_8);
    }
}

