/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.strings.EncodedStringsDialog;
import ghidra.app.services.GoToService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Search For Encoded Strings", description="Searches for strings using a specific character set and allows filtering results using the Unicode scripts (alphabets) used and other criteria.  This feature is being evaluated for it's effectiveness.", servicesRequired={GoToService.class})
public class EncodedStringsPlugin
extends ProgramPlugin {
    private static final String ACTIONNAME = "Search For Encoded Strings";
    static final String STRINGS_OPTION_NAME = "Strings";
    static final String CHARSET_OPTIONNAME = "Default Charset";
    static final String CHARSET_DEFAULT_VALUE = "US-ASCII";
    static final String TRANSLATE_SERVICE_OPTIONNAME = "Default Translation Service Name";
    static final String STRINGMODEL_FILENAME_OPTIONNAME = "Default String Model Filename";
    static final String STRINGMODEL_FILENAME_DEFAULT = "stringngrams/StringModel.sng";
    static final HelpLocation HELP_LOCATION = new HelpLocation("Search", "Encoded_Strings_Dialog");
    private WeakSet<EncodedStringsDialog> openDialogs = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private DockingAction searchForEncodedStringsAction;

    public EncodedStringsPlugin(PluginTool tool) {
        super(tool);
    }

    public DockingAction getSearchForEncodedStringsAction() {
        return this.searchForEncodedStringsAction;
    }

    protected void init() {
        super.init();
        this.registerOptions();
        this.createActions();
    }

    private void registerOptions() {
        ToolOptions options = this.tool.getOptions(STRINGS_OPTION_NAME);
        options.registerOption(CHARSET_OPTIONNAME, (Object)CHARSET_DEFAULT_VALUE, HELP_LOCATION, "Name of default charset.");
        options.registerOption(STRINGMODEL_FILENAME_OPTIONNAME, (Object)STRINGMODEL_FILENAME_DEFAULT, HELP_LOCATION, "Name of default string model file.");
        options.registerOption(TRANSLATE_SERVICE_OPTIONNAME, (Object)"", HELP_LOCATION, "Name of default translation service.");
    }

    @Override
    protected void programClosed(Program program) {
        for (EncodedStringsDialog openDialog : this.openDialogs) {
            openDialog.programClosed(program);
        }
    }

    void dialogClosed(EncodedStringsDialog dialog) {
        this.openDialogs.remove((Object)dialog);
    }

    private void createActions() {
        this.searchForEncodedStringsAction = (DockingAction)new ActionBuilder(ACTIONNAME, this.getName()).withContext(NavigatableActionContext.class, true).onAction(this::showSearchForEncodedStrings).enabledWhen(ac -> ac.getLocation() != null).menuPath(new String[]{"&\u641c\u7d22", "For Encoded Strings..."}).menuGroup("search for", "Strings2").helpLocation(HELP_LOCATION).buildAndInstall((Tool)this.tool);
    }

    private void showSearchForEncodedStrings(NavigatableActionContext lac) {
        AddressSetView addrs = lac.hasSelection() && !lac.getSelection().isEmpty() ? lac.getSelection() : lac.getProgram().getMemory().getAllInitializedAddressSet();
        EncodedStringsDialog dlg = new EncodedStringsDialog(this, lac.getProgram(), addrs);
        this.openDialogs.add((Object)dlg);
        DockingWindowManager.showDialog((DialogComponentProvider)dlg);
    }
}

