/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.flow;

import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.select.flow.SelectByFlowPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.util.HelpLocation;

class SelectByFlowAction
extends ListingContextAction {
    static final String GROUP = "FlowSelection";
    SelectByFlowPlugin selectByFlowPlugin;
    private int selectionType;

    SelectByFlowAction(String name, SelectByFlowPlugin plugin, int selectionType) {
        super(name, plugin.getName());
        this.selectByFlowPlugin = plugin;
        this.selectionType = selectionType;
        this.setContextClass(ListingActionContext.class, true);
        String[] menuPath = null;
        if (selectionType == SelectByFlowPlugin.SELECT_FUNCTIONS) {
            menuPath = new String[]{"&\u9009\u62e9", "Function"};
        } else if (selectionType == SelectByFlowPlugin.SELECT_SUBROUTINES) {
            menuPath = new String[]{"&\u9009\u62e9", "Subroutine"};
        } else if (selectionType == SelectByFlowPlugin.SELECT_DEAD_SUBROUTINES) {
            menuPath = new String[]{"&\u9009\u62e9", "Dead Subroutines"};
        } else if (selectionType == SelectByFlowPlugin.SELECT_LIMITED_FLOWS_FROM) {
            menuPath = new String[]{"&\u9009\u62e9", "Limited Flows From"};
        } else if (selectionType == SelectByFlowPlugin.SELECT_ALL_FLOWS_FROM) {
            menuPath = new String[]{"&\u9009\u62e9", "All Flows From"};
        } else if (selectionType == SelectByFlowPlugin.SELECT_LIMITED_FLOWS_TO) {
            menuPath = new String[]{"&\u9009\u62e9", "Limited Flows To"};
        } else if (selectionType == SelectByFlowPlugin.SELECT_ALL_FLOWS_TO) {
            menuPath = new String[]{"&\u9009\u62e9", "All Flows To"};
        }
        this.setMenuBarData(new MenuData(menuPath, null, GROUP));
        this.setHelpLocation(new HelpLocation("Selection", this.getName()));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.selectByFlowPlugin.select(context, this.selectionType);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection()) {
            return true;
        }
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        CodeUnit cu = context.getCodeUnit();
        return cu != null;
    }
}

