/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.select.SelectBlockDialog;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Select Bytes", description="Allows the user to select different size lengths of bytes from the Byte Viewer generally starting from the cursor position or entire file")
public class SelectBlockPlugin
extends Plugin {
    private DockingAction toolBarAction;
    private SelectBlockDialog dialog;

    public SelectBlockPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    protected void dispose() {
        super.dispose();
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void createActions() {
        this.toolBarAction = new NavigatableContextAction("SelectBlock", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                SelectBlockPlugin.this.showDialog(context.getComponentProvider(), context.getNavigatable());
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                SelectBlockPlugin.this.updateNavigatable(context);
                return super.isEnabledForContext(context);
            }
        };
        MenuData menuData = new MenuData(new String[]{"&\u9009\u62e9", "Bytes..."}, null, "Select Group 2");
        menuData.setMenuSubGroup("1");
        this.toolBarAction.setMenuBarData(menuData);
        this.toolBarAction.addToWindowWhen(NavigatableActionContext.class);
        this.toolBarAction.setEnabled(false);
        this.toolBarAction.setDescription("Allows user to select blocks of data.");
        this.toolBarAction.setHelpLocation(new HelpLocation("SelectBlockPlugin", "Select_Block_Help"));
        this.tool.addAction((DockingActionIf)this.toolBarAction);
    }

    protected void updateNavigatable(ActionContext context) {
        if (this.dialog == null) {
            return;
        }
        if (context instanceof NavigatableActionContext) {
            this.dialog.setNavigatable(((NavigatableActionContext)context).getNavigatable());
        } else {
            this.dialog.setNavigatable(null);
        }
    }

    private void showDialog(ComponentProvider provider, Navigatable navigatable) {
        if (this.dialog != null) {
            this.dialog.close();
        }
        this.dialog = new SelectBlockDialog(this.tool, navigatable);
        this.dialog.show(provider);
    }
}

