/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.util.HashMap;
import java.util.Map;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Selection", shortDescription="Restore Selection", description="This plugin provides the ability to restore the previous selection. This is useful if you accidently lose you selection; for example, by clicking in  the CodeBrowser.  Clicking thusly will clear any selection, which can be restored by performing the Restore Selection action.")
public class RestoreSelectionPlugin
extends ProgramPlugin {
    static final String RESTORE_SELECTION_ACTION_NAME = "Restore Selection";
    private DockingAction restoreSelectionAction;
    private Map<Program, SelectionState> programToSelectionMap = new HashMap<Program, SelectionState>();

    public RestoreSelectionPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    private void createActions() {
        DockingAction action = new DockingAction(RESTORE_SELECTION_ACTION_NAME, this.getName()){

            public void actionPerformed(ActionContext context) {
                SelectionState programSelectionState = RestoreSelectionPlugin.this.programToSelectionMap.get(RestoreSelectionPlugin.this.currentProgram);
                RestoreSelectionPlugin.this.firePluginEvent(new ProgramSelectionPluginEvent(RestoreSelectionPlugin.this.getName(), programSelectionState.getSelectionToRestore(), RestoreSelectionPlugin.this.currentProgram));
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&\u9009\u62e9", RESTORE_SELECTION_ACTION_NAME}, null, "SelectUtils"));
        action.setHelpLocation(new HelpLocation("Selection", RESTORE_SELECTION_ACTION_NAME));
        action.setEnabled(false);
        this.tool.addAction((DockingActionIf)action);
        this.restoreSelectionAction = action;
    }

    protected void dispose() {
        this.programToSelectionMap.clear();
        super.dispose();
    }

    @Override
    protected void programActivated(Program program) {
        SelectionState programSelectionState = this.programToSelectionMap.get(program);
        if (programSelectionState == null) {
            programSelectionState = new SelectionState(this);
            this.programToSelectionMap.put(program, programSelectionState);
        }
        this.restoreSelectionAction.setEnabled(programSelectionState.canRestoreSelection());
    }

    @Override
    protected void programClosed(Program program) {
        this.programToSelectionMap.remove(program);
    }

    @Override
    protected void selectionChanged(ProgramSelection selection) {
        SelectionState selectionState = this.programToSelectionMap.get(this.currentProgram);
        if (selectionState == null) {
            return;
        }
        selectionState.pushSelection(selection);
        if (selectionState.canRestoreSelection()) {
            this.restoreSelectionAction.setEnabled(true);
        }
    }

    private class SelectionState {
        private final ProgramSelection NUMPTY_SELECTION;
        private ProgramSelection activeSelection;
        private ProgramSelection previousRestoreSelection;

        private SelectionState(RestoreSelectionPlugin restoreSelectionPlugin) {
            this.activeSelection = this.NUMPTY_SELECTION = new ProgramSelection();
            this.previousRestoreSelection = this.NUMPTY_SELECTION;
        }

        ProgramSelection getSelectionToRestore() {
            if (this.previousRestoreSelection == null || this.previousRestoreSelection.isEmpty()) {
                throw new AssertException("Tried to restore a selection with no previous selection saved");
            }
            return this.previousRestoreSelection;
        }

        void pushSelection(ProgramSelection newSelection) {
            if (newSelection == null) {
                newSelection = this.NUMPTY_SELECTION;
            }
            if (this.activeSelection.equals(newSelection)) {
                return;
            }
            if (!this.NUMPTY_SELECTION.equals(this.activeSelection)) {
                this.previousRestoreSelection = this.activeSelection;
            }
            this.activeSelection = newSelection;
        }

        boolean canRestoreSelection() {
            if (this.previousRestoreSelection == null || this.previousRestoreSelection.isEmpty()) {
                return false;
            }
            return !this.previousRestoreSelection.equals(this.activeSelection);
        }
    }
}

