/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.progmgr.AbstractProgramNameSwitchingAction;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;

public class CloseProgramAction
extends AbstractProgramNameSwitchingAction {
    public CloseProgramAction(ProgramManagerPlugin plugin, String group, int subGroup) {
        super(plugin, "Close File");
        MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", "&Close"});
        menuData.setMenuGroup(group);
        menuData.setMenuSubGroup(Integer.toString(subGroup));
        this.setMenuBarData(menuData);
        this.setKeyBindingData(new KeyBindingData("ctrl w"));
    }

    @Override
    protected void programChanged(Program program) {
        if (program == null) {
            this.getMenuBarData().setMenuItemName("&Close");
            this.setDescription("Close Program");
        } else {
            String progName = program.getDomainFile().getName();
            this.getMenuBarData().setMenuItemNamePlain("Close '%s'".formatted(progName));
            this.getMenuBarData().setMnemonic(Character.valueOf('C'));
            this.setDescription("<html>Close '%s'".formatted(HTMLUtilities.escapeHTML((String)progName)));
        }
    }

    @Override
    public void actionPerformed(Program program) {
        this.plugin.closeProgram(program, false);
    }
}

