/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.printing;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.LayoutModelIterator;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.printing.CodeUnitPrintable;
import ghidra.app.plugin.core.printing.PrintOptionsDialog;
import ghidra.app.services.CodeViewerService;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Print Selections of code", description="Allows user to select areas of code in the listing window andsend that to a printer in a similar format as the screen is showing.", servicesRequired={CodeViewerService.class})
public class PrintingPlugin
extends ProgramPlugin {
    private static final String NAME = "PrintingPlugin";
    private DockingAction printAction;
    private DockingAction pageSetupAction;
    private CodeViewerService cvService;
    PrintOptionsDialog pod;
    private PageFormat format;

    public PrintingPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    public void init() {
        super.init();
        this.cvService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
    }

    protected void dispose() {
        super.dispose();
        if (this.pod != null) {
            this.pod.dispose();
        }
    }

    @Override
    protected void programActivated(Program program) {
        this.printAction.setEnabled(true);
        this.pageSetupAction.setEnabled(true);
    }

    @Override
    protected void programDeactivated(Program program) {
        this.printAction.setEnabled(false);
        this.pageSetupAction.setEnabled(false);
    }

    private void setupActions() {
        this.printAction = new PrintAction();
        this.tool.addAction((DockingActionIf)this.printAction);
        this.pageSetupAction = new PageSetupAction();
        this.tool.addAction((DockingActionIf)this.pageSetupAction);
    }

    private void showPrinterDialogOnSwingThread(final PrinterJob job) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception e) {
                            Msg.showError((Object)this, null, (String)"Print Failed", (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Msg.showError(null, null, (String)"Printing Error", (Object)"Printing task interrupted");
        }
        catch (InvocationTargetException e) {
            Msg.showError(null, null, (String)"Printing Error", (Object)"Unexpected error printing: ", (Throwable)e);
        }
    }

    public static String getDescriptiveName() {
        return "Print CodeBrowser Text";
    }

    public static String getDescription() {
        return "Prints text from the CodeBrowser to a printer.";
    }

    public static String getCategory() {
        return "Printing";
    }

    class PrintAction
    extends DockingAction {
        public PrintAction() {
            super("Print", PrintingPlugin.NAME);
            MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", "&Print..."}, null, "Print");
            menuData.setMenuSubGroup("a");
            this.setMenuBarData(menuData);
            this.setKeyBindingData(new KeyBindingData(80, 128));
            this.setEnabled(false);
            this.setHelpLocation(new HelpLocation(PrintingPlugin.NAME, "Print"));
        }

        public void actionPerformed(ActionContext context) {
            if (PrintingPlugin.this.pod == null) {
                PrintingPlugin.this.pod = new PrintOptionsDialog(PrintingPlugin.this.currentSelection != null);
            } else {
                PrintingPlugin.this.pod.setSelectionEnabled(PrintingPlugin.this.currentSelection != null);
            }
            PrintingPlugin.this.tool.showDialog((DialogComponentProvider)PrintingPlugin.this.pod);
            if (PrintingPlugin.this.pod.isCancelled()) {
                return;
            }
            Task printTask = new Task("Printing", true, true, true){

                public void run(TaskMonitor monitor) {
                    monitor.setMessage("Constructing Print Job");
                    Date startDate = new Date();
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setJobName("Ghidra - " + PrintingPlugin.this.currentProgram.getName());
                    Book book = new Book();
                    if (PrintingPlugin.this.format == null) {
                        PrintingPlugin.this.format = job.defaultPage();
                    }
                    ListingPanel listingPanel = PrintingPlugin.this.cvService.getListingPanel();
                    FieldPanel fp = listingPanel.getFieldPanel();
                    LayoutModel lm = fp.getLayoutModel();
                    double scaleAmount = PrintingPlugin.this.format.getImageableWidth() / (double)lm.getPreferredViewSize().width;
                    int scaledHeight = (int)PrintingPlugin.this.format.getImageableHeight();
                    int headerHeight = (PrintingPlugin.this.pod.showHeader() ? PrintingPlugin.this.pod.getHeaderHeight() : 0) + (PrintingPlugin.this.pod.showFooter() ? PrintingPlugin.this.pod.getHeaderHeight() : 0);
                    scaledHeight -= headerHeight;
                    if (scaleAmount < 1.0) {
                        scaledHeight = (int)((double)scaledHeight / scaleAmount);
                    }
                    if (PrintingPlugin.this.pod.getSelection()) {
                        this.printSelection(monitor, startDate, job, book, lm, scaleAmount, scaledHeight);
                        if (monitor.isCancelled()) {
                            return;
                        }
                    } else if (PrintingPlugin.this.pod.getVisible()) {
                        this.printVisibleContent(monitor, startDate, job, book, lm, scaleAmount, scaledHeight);
                        if (monitor.isCancelled()) {
                            return;
                        }
                    } else {
                        int pageCount = this.getPrintablePageCount(monitor, lm, scaledHeight, BigInteger.ZERO, null);
                        this.printView(monitor, startDate, job, book, lm, scaleAmount, scaledHeight, pageCount, BigInteger.ZERO, null);
                        if (monitor.isCancelled()) {
                            return;
                        }
                    }
                    job.setPageable(book);
                    monitor.setMessage("Displaying Print Dialog");
                    PrintingPlugin.this.showPrinterDialogOnSwingThread(job);
                }

                private int getPrintablePageCount(TaskMonitor monitor, LayoutModel lm, int pageHeight, BigInteger startIndex, BigInteger termIndex) {
                    int currentPageHt = 0;
                    int pageCount = 0;
                    monitor.initialize(lm.getNumIndexes().longValue());
                    LayoutModelIterator it = lm.iterator(startIndex);
                    while (it.hasNext() && !monitor.isCancelled()) {
                        Layout layout = it.next();
                        if (termIndex != null && termIndex.compareTo(it.getIndex()) < 0) break;
                        if (layout == null) continue;
                        int layoutHt = layout.getHeight();
                        if (currentPageHt + layoutHt > pageHeight) {
                            currentPageHt = currentPageHt == 0 ? 0 : layoutHt;
                            monitor.setMessage("Counting pages: " + ++pageCount);
                        } else {
                            currentPageHt += layoutHt;
                        }
                        monitor.incrementProgress(1L);
                    }
                    return pageCount + (currentPageHt > 0 ? 1 : 0);
                }

                private void printView(TaskMonitor monitor, Date startDate, PrinterJob job, Book book, LayoutModel lm, double scaleAmount, int maxPageHeight, int pageCount, BigInteger startIndex, BigInteger termIndex) {
                    int pageNum = 0;
                    BigInteger pageStartIndex = null;
                    BigInteger lastIndex = null;
                    int currentPageHt = 0;
                    long indexCount = termIndex == null ? lm.getNumIndexes().longValue() : termIndex.subtract(startIndex).longValue();
                    monitor.initialize(indexCount);
                    monitor.setMessage("Printing...");
                    LayoutModelIterator it = lm.iterator(startIndex);
                    while (it.hasNext() && !monitor.isCancelled()) {
                        Layout layout = it.next();
                        if (termIndex != null && termIndex.compareTo(it.getIndex()) < 0) break;
                        lastIndex = it.getIndex();
                        if (pageStartIndex == null) {
                            pageStartIndex = it.getIndex();
                        }
                        if (layout == null) continue;
                        int layoutHt = layout.getHeight();
                        if (currentPageHt + layoutHt > maxPageHeight) {
                            boolean atBeginningOfNewPageAndElementIsBiggerThanEntirePage;
                            int psi = pageStartIndex.intValue();
                            boolean bl = atBeginningOfNewPageAndElementIsBiggerThanEntirePage = psi == it.getIndex().intValue();
                            if (atBeginningOfNewPageAndElementIsBiggerThanEntirePage) {
                                book.append(new CodeUnitPrintable(lm, psi, psi, scaleAmount, monitor, PrintingPlugin.this.pod, book, job, startDate), PrintingPlugin.this.format);
                                currentPageHt = 0;
                                pageStartIndex = null;
                            } else {
                                book.append(new CodeUnitPrintable(lm, psi, it.getPreviousIndex().intValue(), scaleAmount, monitor, PrintingPlugin.this.pod, book, job, startDate), PrintingPlugin.this.format);
                                currentPageHt = layoutHt;
                                pageStartIndex = it.getIndex();
                            }
                            monitor.setMessage("Constructing Print Job, page " + ++pageNum + " of " + pageCount);
                        } else {
                            currentPageHt += layoutHt;
                        }
                        monitor.incrementProgress(1L);
                    }
                    if (!monitor.isCancelled() && lastIndex != null && pageStartIndex != null && lastIndex.compareTo(pageStartIndex) >= 0) {
                        monitor.setProgress(indexCount);
                        book.append(new CodeUnitPrintable(lm, pageStartIndex.intValue(), lastIndex.intValue(), scaleAmount, monitor, PrintingPlugin.this.pod, book, job, startDate), PrintingPlugin.this.format);
                    }
                }

                private void printVisibleContent(TaskMonitor monitor, Date startDate, PrinterJob job, Book book, LayoutModel lm, double scaleAmount, int maxPageHeight) {
                    ListingPanel listingPanel = PrintingPlugin.this.cvService.getListingPanel();
                    FieldPanel fp = listingPanel.getFieldPanel();
                    List visibleLayouts = fp.getVisibleLayouts();
                    BigInteger startIndex = ((AnchoredLayout)visibleLayouts.get(0)).getIndex();
                    BigInteger endIndex = ((AnchoredLayout)visibleLayouts.get(visibleLayouts.size() - 1)).getIndex();
                    int pageCount = this.getPrintablePageCount(monitor, lm, maxPageHeight, startIndex, endIndex);
                    this.printView(monitor, startDate, job, book, lm, scaleAmount, maxPageHeight, pageCount, startIndex, endIndex);
                }

                private void printSelection(TaskMonitor monitor, Date startDate, PrinterJob job, Book book, LayoutModel lm, double scaleAmount, int scaledHeight) {
                    ArrayList<Object> layouts = new ArrayList<Layout>();
                    BigInteger lastIndex = null;
                    int pageHeight = 0;
                    AddressIndexMap indexMap = PrintingPlugin.this.cvService.getAddressIndexMap();
                    AddressRangeIterator rangeItr = PrintingPlugin.this.currentSelection.getAddressRanges();
                    monitor.initialize(PrintingPlugin.this.currentSelection.getNumAddresses());
                    int rangeProgress = 0;
                    while (rangeItr.hasNext()) {
                        AddressRange curRange = (AddressRange)rangeItr.next();
                        Address curAddress = curRange.getMinAddress();
                        while (curAddress.compareTo((Object)curRange.getMaxAddress()) <= 0) {
                            BigInteger curIndex = indexMap.getIndex(curAddress);
                            if (curIndex == null) {
                                if ((curAddress = curAddress.next()) != null) continue;
                                break;
                            }
                            if (curIndex.equals(lastIndex)) continue;
                            Layout layout = lm.getLayout(curIndex);
                            if (layout != null) {
                                if ((pageHeight += layout.getHeight()) > scaledHeight) {
                                    book.append(new CodeUnitPrintable(lm, layouts, scaleAmount, monitor, PrintingPlugin.this.pod, book, job, startDate), PrintingPlugin.this.format);
                                    pageHeight = layout.getHeight();
                                    layouts = new ArrayList();
                                }
                                layouts.add(layout);
                            }
                            curAddress = curAddress.next();
                            monitor.incrementProgress(1L);
                            if (curAddress == null) break;
                            lastIndex = curIndex;
                        }
                        if (monitor.isCancelled()) {
                            return;
                        }
                        rangeProgress = (int)((long)rangeProgress + curRange.getLength());
                        monitor.setProgress((long)rangeProgress);
                    }
                    monitor.setProgress(PrintingPlugin.this.currentSelection.getNumAddresses());
                    book.append(new CodeUnitPrintable(lm, layouts, scaleAmount, monitor, PrintingPlugin.this.pod, book, job, startDate), PrintingPlugin.this.format);
                }
            };
            TaskLauncher.launch((Task)printTask);
        }
    }

    class PageSetupAction
    extends DockingAction {
        public PageSetupAction() {
            super("Page Setup", PrintingPlugin.NAME);
            MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", "Page Setup..."}, null, "Print");
            menuData.setMenuSubGroup("b");
            this.setMenuBarData(menuData);
            this.setEnabled(false);
            this.setHelpLocation(new HelpLocation(PrintingPlugin.NAME, "Page_Setup"));
        }

        public void actionPerformed(ActionContext context) {
            new Thread(){

                @Override
                public void run() {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    if (PrintingPlugin.this.format == null) {
                        PrintingPlugin.this.format = job.defaultPage();
                    }
                    PrintingPlugin.this.format = job.pageDialog(PrintingPlugin.this.format);
                }
            }.start();
        }
    }
}

