/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.services.GoToService;
import ghidra.app.util.navigation.GoToAddressLabelDialog;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Navigation", shortDescription="Go To Address of Label", description="This plugin provides the \"go to\" action and dialog.  When the action is invoked, a dialog is presented allowing the user to type in a label, address or \"wildcard\" string.  If multiple matches are found, a dialog is displayed showing all results", servicesRequired={GoToService.class})
public class GoToAddressLabelPlugin
extends Plugin
implements OptionsChangeListener {
    private static final int DEFAULT_MAX_GOTO_ENTRIES = 10;
    private static final boolean DEFAULT_C_STYLE = false;
    private static final String GO_TO_MEMORY = "Goto Dialog Memory";
    private static final boolean DEFAULT_MEMORY = true;
    private GoToAddressLabelDialog goToDialog;
    private DockingAction action = new NavigatableContextAction("Go To Address/Label", this.getName()){

        @Override
        public void actionPerformed(NavigatableActionContext context) {
            GoToAddressLabelPlugin.this.goToDialog.show(context.getNavigatable(), context.getAddress(), GoToAddressLabelPlugin.this.tool);
        }

        @Override
        protected boolean isEnabledForContext(NavigatableActionContext context) {
            return context.getProgram() != null;
        }

        @Override
        public boolean isAddToPopup(ActionContext context) {
            return true;
        }
    };
    private int maximumGotoEntries;
    private boolean cStyleInput;
    private boolean goToMemory;

    public GoToAddressLabelPlugin(PluginTool pluginTool) {
        super(pluginTool);
        this.action.addToWindowWhen(NavigatableActionContext.class);
        this.action.setHelpLocation(new HelpLocation("Navigation", this.action.getName()));
        this.action.setMenuBarData(new MenuData(new String[]{"&\u5bfc\u822a", "Go To..."}, null, "GoTo", -1, "2"));
        this.action.setKeyBindingData(new KeyBindingData(71, 0));
        this.action.setEnabled(false);
    }

    public void init() {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        this.goToDialog = new GoToAddressLabelDialog(gotoService, this);
        this.maximumGotoEntries = 10;
        this.initOptions();
        this.tool.addAction((DockingActionIf)this.action);
    }

    public final int getMaximumGotoEntries() {
        return this.maximumGotoEntries;
    }

    public void readConfigState(SaveState saveState) {
        this.goToDialog.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.goToDialog.writeConfigState(saveState);
    }

    public void optionsChanged(ToolOptions options, String opName, Object oldValue, Object newValue) {
        if (opName.equals("Max Goto Entries")) {
            this.maximumGotoEntries = options.getInt("Max Goto Entries", 10);
            if (this.maximumGotoEntries <= 0) {
                throw new OptionsVetoException("Search limit must be greater than 0");
            }
            this.goToDialog.maxEntrysChanged();
        } else if (opName.equals("Use C-like Numeric Formatting for Addresses")) {
            this.cStyleInput = options.getBoolean("Use C-like Numeric Formatting for Addresses", false);
            this.goToDialog.setCStyleInput(this.cStyleInput);
        } else if (opName.equals(GO_TO_MEMORY)) {
            this.goToMemory = options.getBoolean(GO_TO_MEMORY, true);
            this.goToDialog.setMemory(this.goToMemory);
        }
    }

    public void dispose() {
        ToolOptions options = this.tool.getOptions("Tool");
        options.removeOptionsChangeListener((OptionsChangeListener)this);
        super.dispose();
    }

    private void initOptions() {
        ToolOptions opt = this.tool.getOptions("Tool");
        opt.registerOption("Use C-like Numeric Formatting for Addresses", (Object)false, null, "Interpret value entered in the Go To dialog as either hex, octal, or binary number.");
        opt.registerOption("Max Goto Entries", (Object)10, null, "Max number of entries remembered in the go to list.");
        opt.registerOption(GO_TO_MEMORY, (Object)true, null, "Remember the last successful go to input in the Go To dialog.  If this option is enabled, then the Go To dialog will leave the last successful go to input in the combo box of the Go To dialog and will select the value for easy paste replacement.");
        this.maximumGotoEntries = opt.getInt("Max Goto Entries", 10);
        this.cStyleInput = opt.getBoolean("Use C-like Numeric Formatting for Addresses", false);
        this.goToDialog.setCStyleInput(this.cStyleInput);
        this.goToMemory = opt.getBoolean(GO_TO_MEMORY, true);
        this.goToDialog.setMemory(this.goToMemory);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    GoToAddressLabelDialog getDialog() {
        return this.goToDialog;
    }
}

