/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.MarkerPanel;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.util.viewer.listingpanel.ListingMarginProvider;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarkerClickedListener;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UniversalID;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class MarkerMarginProvider
implements ListingMarginProvider {
    private final MarkerManager markerManager;
    private final MarkerPanel markerPanel;
    private Program program;
    private VerticalPixelAddressMap pixmap;

    MarkerMarginProvider(final MarkerManager markerManager) {
        this.markerManager = markerManager;
        this.markerPanel = new MarkerPanel(markerManager);
        this.markerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MarkerClickedListener markerClickedListener = markerManager.getMarkerClickedListener();
                if (e.getClickCount() != 2 || markerClickedListener == null) {
                    return;
                }
                MarkerLocation location = MarkerMarginProvider.this.getMarkerLocation(e.getX(), e.getY());
                markerClickedListener.markerDoubleClicked(location);
            }
        });
    }

    @Override
    public void setOwnerId(UniversalID ownerId) {
        this.markerPanel.setOwnerId(ownerId);
    }

    @Override
    public void setLocation(ProgramLocation location) {
    }

    @Override
    public void dispose() {
        this.markerManager.removeProvider(this);
        this.markerPanel.dispose();
    }

    void repaintPanel() {
        this.markerPanel.repaint();
    }

    @Override
    public JComponent getComponent() {
        return this.markerPanel;
    }

    private Address getAddress(int y) {
        if (this.pixmap == null) {
            return null;
        }
        int i = this.pixmap.findLayoutAt(y);
        return this.pixmap.getLayoutAddress(i);
    }

    @Override
    public MarkerLocation getMarkerLocation(int x, int y) {
        Address addr = this.getAddress(y);
        if (addr == null) {
            return null;
        }
        MarkerSetImpl marker = this.markerManager.getMarkerSet(this.program, addr);
        return new MarkerLocation(marker, this.program, addr, x, y);
    }

    @Override
    public boolean isResizeable() {
        return false;
    }

    @Override
    public void screenDataChanged(ListingPanel listing, AddressIndexMap addrMap, VerticalPixelAddressMap pixMap) {
        this.program = listing.getProgram();
        this.pixmap = pixMap;
        this.markerPanel.listingUpdated(listing, addrMap, pixMap);
        this.markerManager.updateMarkerSets(this.program, true, false, true);
    }

    String generateToolTip(MouseEvent event) {
        return this.markerPanel.generateToolTip(event);
    }
}

