/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.cmd.refs.AssociateSymbolCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.label.LabelMgrPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OperandLabelDialog
extends DialogComponentProvider {
    private JLabel label;
    private GhidraComboBox<String> myChoice;
    private LabelMgrPlugin plugin;
    private ListingActionContext programActionContext;

    public OperandLabelDialog(LabelMgrPlugin plugin) {
        super("");
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "OperandLabelDialog"));
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    protected JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.label = new GDLabel("Label: ");
        this.myChoice = new GhidraComboBox();
        this.myChoice.setName("MYCHOICE");
        this.myChoice.setEditable(true);
        this.myChoice.getAccessibleContext().setAccessibleName("My Choice");
        mainPanel.add(this.label);
        mainPanel.add((Component)this.myChoice);
        mainPanel.getAccessibleContext().setAccessibleName("Operand Label");
        return mainPanel;
    }

    protected void okCallback() {
        Program program = this.programActionContext.getProgram();
        ProgramLocation loc = this.programActionContext.getLocation();
        OperandFieldLocation location = (OperandFieldLocation)loc;
        Symbol sym = this.getSymbol(this.programActionContext);
        String currentLabel = this.myChoice.getText();
        if (currentLabel.equals(sym.getName(true))) {
            this.close();
            return;
        }
        ReferenceManager refMgr = program.getReferenceManager();
        SymbolTable symTable = program.getSymbolTable();
        int opIndex = location.getOperandIndex();
        Address addr = location.getAddress();
        Address symAddr = sym.getAddress();
        Reference ref = refMgr.getReference(addr, symAddr, opIndex);
        CompoundCmd cmd = new CompoundCmd("Set Label");
        Namespace scope = null;
        Symbol newSym = this.findSymbol(symTable, currentLabel, symAddr);
        if (newSym == null) {
            cmd.add((Command)new AddLabelCmd(symAddr, currentLabel, SourceType.USER_DEFINED));
        } else {
            scope = newSym.getParentNamespace();
            currentLabel = newSym.getName();
        }
        cmd.add((Command)new AssociateSymbolCmd(ref, currentLabel, scope));
        if (!this.plugin.getTool().execute((Command)cmd, (DomainObject)program)) {
            this.setStatusText(cmd.getStatusMsg());
            return;
        }
        this.close();
    }

    private Symbol findSymbol(SymbolTable symTable, String currentLabel, Address symAddr) {
        SymbolIterator symbols = symTable.getSymbolsAsIterator(symAddr);
        for (Symbol symbol : symbols) {
            if (!symbol.getName(true).equals(currentLabel)) continue;
            return symbol;
        }
        return null;
    }

    protected void cancelCallback() {
        this.close();
    }

    public void close() {
        this.programActionContext = null;
        super.close();
    }

    public void setOperandLabel(ListingActionContext context) {
        Symbol[] symbols;
        this.programActionContext = context;
        this.setStatusText("");
        this.myChoice.clearModel();
        Symbol s = this.getSymbol(context);
        for (Symbol symbol : symbols = context.getProgram().getSymbolTable().getSymbols(s.getAddress())) {
            this.myChoice.addToModel((Object)symbol.getName(true));
        }
        this.setTitle("Set Label at " + String.valueOf(s.getAddress()));
        this.myChoice.setSelectedItem((Object)s.getName(true));
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)this);
    }

    private Symbol getSymbol(ListingActionContext context) {
        Program program = context.getProgram();
        OperandFieldLocation location = (OperandFieldLocation)context.getLocation();
        Address address = location.getAddress();
        int opIndex = location.getOperandIndex();
        ReferenceManager refMgr = program.getReferenceManager();
        Reference ref = refMgr.getPrimaryReferenceFrom(address, opIndex);
        if (ref != null) {
            SymbolTable st = program.getSymbolTable();
            return st.getSymbol(ref);
        }
        return null;
    }
}

