/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.highlight;

import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramSelection;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Set Highlight From Selection", description="Provides actions for setting a highlight from a selection or setting a selection from a hightlight", eventsConsumed={ProgramHighlightPluginEvent.class})
public class SetHighlightPlugin
extends Plugin {
    private static final String HIGHLIGHT_GROUP = "Highlight";
    private static final String MENU_HIGHLIGHT = "Program Highlight";
    private static final String MENU_SELECTION = "Program Selection";
    private static final String[] SET_HIGHLIGHT_POPUPPATH = new String[]{"Program Highlight", "Entire Selection"};
    private static final String[] CLEAR_HIGHLIGHT_POPUPPATH = new String[]{"Program Highlight", "Clear"};
    private static final String[] ADD_SELECTION_POPUPPATH = new String[]{"Program Highlight", "Add Selection"};
    private static final String[] SUBTRACT_SELECTION_POPUPPATH = new String[]{"Program Highlight", "Subtract Selection"};
    private static final String[] SET_SELECTION_POPUPPATH = new String[]{"Program Selection", "Entire Highlight"};
    private DockingAction setHighlightFromSelectionAction;
    private DockingAction clearHighlightAction;
    private DockingAction addSelectionAction;
    private DockingAction subtractSelectionAction;
    private DockingAction setSelectionFromHighlightAction;

    public SetHighlightPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        int programHighlightSubMenuPosition = 1;
        this.setHighlightFromSelectionAction = new NavigatableContextAction("Set Highlight From Selection", this.getName()){

            @Override
            protected void actionPerformed(NavigatableActionContext context) {
                SetHighlightPlugin.this.setHighlight(context.getNavigatable(), SetHighlightPlugin.this.copySelection(context.getSelection()));
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection() && context.getNavigatable().supportsHighlight();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&\u9009\u62e9", MENU_HIGHLIGHT, "Entire Selection"}, HIGHLIGHT_GROUP);
        menuData.setMenuSubGroup(Integer.toString(programHighlightSubMenuPosition++));
        this.setHighlightFromSelectionAction.setMenuBarData(menuData);
        this.setHighlightFromSelectionAction.setPopupMenuData(new MenuData(SET_HIGHLIGHT_POPUPPATH, HIGHLIGHT_GROUP));
        this.setHighlightFromSelectionAction.setKeyBindingData(new KeyBindingData(72, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setHighlightFromSelectionAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.setHighlightFromSelectionAction);
        this.clearHighlightAction = new NavigatableContextAction("Remove Highlight", this.getName()){

            @Override
            protected void actionPerformed(NavigatableActionContext context) {
                SetHighlightPlugin.this.setHighlight(context.getNavigatable(), new ProgramSelection());
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasHighlight();
            }
        };
        menuData = new MenuData(new String[]{"&\u9009\u62e9", MENU_HIGHLIGHT, "Clear"}, HIGHLIGHT_GROUP);
        menuData.setMenuSubGroup(Integer.toString(programHighlightSubMenuPosition++));
        this.clearHighlightAction.setMenuBarData(menuData);
        this.clearHighlightAction.setPopupMenuData(new MenuData(CLEAR_HIGHLIGHT_POPUPPATH, HIGHLIGHT_GROUP));
        this.clearHighlightAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.clearHighlightAction);
        this.addSelectionAction = new NavigatableContextAction("Add Selection To Highlight", this.getName()){

            @Override
            protected void actionPerformed(NavigatableActionContext context) {
                ProgramSelection highlight = context.getHighlight();
                highlight = new ProgramSelection((AddressSetView)highlight.union(context.getSelection()));
                SetHighlightPlugin.this.setHighlight(context.getNavigatable(), highlight);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection() && context.hasHighlight();
            }
        };
        menuData = new MenuData(new String[]{"&\u9009\u62e9", MENU_HIGHLIGHT, "Add Selection"}, HIGHLIGHT_GROUP);
        menuData.setMenuSubGroup(Integer.toString(programHighlightSubMenuPosition++));
        this.addSelectionAction.setMenuBarData(menuData);
        this.addSelectionAction.setPopupMenuData(new MenuData(ADD_SELECTION_POPUPPATH, HIGHLIGHT_GROUP));
        this.addSelectionAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.addSelectionAction);
        this.subtractSelectionAction = new NavigatableContextAction("Subtract Selection From Highlight", this.getName()){

            @Override
            protected void actionPerformed(NavigatableActionContext context) {
                ProgramSelection highlight = context.getHighlight();
                highlight = new ProgramSelection((AddressSetView)highlight.subtract(context.getSelection()));
                SetHighlightPlugin.this.setHighlight(context.getNavigatable(), highlight);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection() && context.hasHighlight();
            }
        };
        menuData = new MenuData(new String[]{"&\u9009\u62e9", MENU_HIGHLIGHT, "Subtract Selection"}, HIGHLIGHT_GROUP);
        menuData.setMenuSubGroup(Integer.toString(programHighlightSubMenuPosition++));
        this.subtractSelectionAction.addToWindowWhen(NavigatableActionContext.class);
        this.subtractSelectionAction.setMenuBarData(menuData);
        this.subtractSelectionAction.setPopupMenuData(new MenuData(SUBTRACT_SELECTION_POPUPPATH, HIGHLIGHT_GROUP));
        this.tool.addAction((DockingActionIf)this.subtractSelectionAction);
        this.setSelectionFromHighlightAction = new NavigatableContextAction("Set Selection From Highlight", this.getName()){

            @Override
            protected void actionPerformed(NavigatableActionContext context) {
                SetHighlightPlugin.this.setSelection(context.getNavigatable(), SetHighlightPlugin.this.copySelection(context.getHighlight()));
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasHighlight();
            }
        };
        this.setSelectionFromHighlightAction.setMenuBarData(new MenuData(new String[]{"&\u9009\u62e9", "From Highlight"}, HIGHLIGHT_GROUP));
        this.setSelectionFromHighlightAction.setPopupMenuData(new MenuData(SET_SELECTION_POPUPPATH, HIGHLIGHT_GROUP));
        this.setSelectionFromHighlightAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.setSelectionFromHighlightAction);
        this.tool.setMenuGroup(new String[]{MENU_SELECTION, MENU_HIGHLIGHT}, HIGHLIGHT_GROUP);
    }

    protected void setHighlight(Navigatable navigatable, ProgramSelection highlight) {
        if (navigatable == null) {
            GoToService service = (GoToService)this.tool.getService(GoToService.class);
            if (service == null) {
                return;
            }
            navigatable = service.getDefaultNavigatable();
        }
        navigatable.setHighlight(highlight);
    }

    protected void setSelection(Navigatable navigatable, ProgramSelection selection) {
        if (navigatable == null) {
            GoToService service = (GoToService)this.tool.getService(GoToService.class);
            if (service == null) {
                return;
            }
            navigatable = service.getDefaultNavigatable();
        }
        navigatable.setSelection(selection);
    }

    private ProgramSelection copySelection(ProgramSelection selection) {
        InteriorSelection is;
        if (selection != null && (is = selection.getInteriorSelection()) != null) {
            InteriorSelection ih = new InteriorSelection(is.getFrom(), is.getTo(), is.getStartAddress(), is.getEndAddress());
            return new ProgramSelection(ih);
        }
        return new ProgramSelection(selection);
    }
}

