/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.flowarrow;

import ghidra.app.plugin.core.flowarrow.FlowArrow;
import ghidra.app.plugin.core.flowarrow.FlowArrowMarginProvider;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

class FlowArrowShapeFactory {
    private static final int TRIANGLE_HEIGHT = 9;
    private static final int TRIANGLE_WIDTH = 7;

    private FlowArrowShapeFactory() {
    }

    static Shape createArrowBody(FlowArrowMarginProvider provider, FlowArrow arrow, int width, int height, int lineSpacing) {
        GeneralPath linePath = new GeneralPath();
        Integer startTop = provider.getStartPos(arrow.start);
        Integer startBottom = provider.getEndPos(arrow.start);
        int startY = 0;
        if (startTop != null && startBottom != null) {
            int start = startTop;
            int end = startBottom;
            startY = (start + end) / 2;
        } else if (provider.isBelowScreen(arrow.start)) {
            startY = height;
        }
        Integer endTop = provider.getStartPos(arrow.end);
        Integer endBottom = provider.getEndPos(arrow.end);
        int endY = 0;
        if (endTop != null && endBottom != null) {
            int start = endTop;
            int end = endBottom;
            endY = (start + end) / 2;
            endY = Math.min(endY, height);
        } else if (provider.isBelowScreen(arrow.end)) {
            endY = height;
        }
        int x = width - (arrow.column + 1) * lineSpacing;
        if (x < 3) {
            x = 3;
        }
        if (startY != 0 && startY != height) {
            linePath.moveTo(width, startY);
            linePath.lineTo(x, startY);
        }
        boolean offScreen = endY == 0 || endY == height;
        int arrowHeight = offScreen ? 8 : 0;
        arrowHeight = arrow.isUp() ? -arrowHeight : arrowHeight;
        linePath.moveTo(x, startY);
        linePath.lineTo(x, endY - arrowHeight);
        if (endY != 0 && endY != height) {
            linePath.moveTo(x, endY);
            linePath.lineTo(width - 7, endY);
        }
        return linePath;
    }

    static Shape createArrowHead(FlowArrowMarginProvider provider, FlowArrow arrow, int width, int height, int lineSpacing) {
        Integer addrStartInt = provider.getStartPos(arrow.end);
        Integer addrEndInt = provider.getEndPos(arrow.end);
        int endY = 0;
        if (addrStartInt != null && addrEndInt != null) {
            int start = addrStartInt;
            int end = addrEndInt;
            endY = (start + end) / 2;
            endY = Math.min(endY, height);
        } else if (provider.isBelowScreen(arrow.end)) {
            endY = height;
        }
        int x = width - (arrow.column + 1) * lineSpacing;
        if (x < 0) {
            x = 3;
        }
        double halfHeight = 4.0;
        GeneralPath arrowPath = new GeneralPath();
        if (endY != 0 && endY != height) {
            int arrowY = endY;
            arrowPath.moveTo(width, arrowY);
            arrowPath.lineTo((double)(width - 7), (double)arrowY - halfHeight);
            arrowPath.lineTo((double)(width - 7), (double)arrowY + halfHeight);
            arrowPath.closePath();
        } else if (endY == 0) {
            int offset = 0;
            arrowPath.moveTo(x, offset);
            arrowPath.lineTo((double)x - halfHeight, (double)(offset + 7));
            arrowPath.lineTo((double)x + halfHeight, (double)(offset + 7));
            arrowPath.closePath();
        } else if (endY == height) {
            arrowPath.moveTo(x, height);
            arrowPath.lineTo((double)x - halfHeight, (double)(height - 7));
            arrowPath.lineTo((double)x + halfHeight, (double)(height - 7));
            arrowPath.closePath();
        }
        return arrowPath;
    }
}

