/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import generic.theme.GIcon;
import ghidra.app.plugin.core.datamgr.archive.DomainFileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DtBackgroundIcon;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public abstract class DomainFileArchiveNode
extends ArchiveNode {
    private static Icon CHECKED_OUT_ICON = new GIcon("icon.plugin.datatypes.tree.node.archive.file.checked.out");
    private static Icon CHECKED_OUT_EXCLUSIVE_ICON = new GIcon("icon.plugin.datatypes.tree.node.archive.file.checked.out.exclusive");
    private static Icon HIJACKED_ICON = new GIcon("icon.plugin.datatypes.tree.node.archive.file.hijacked");
    private static Icon READ_ONLY_ICON = new GIcon("icon.plugin.datatypes.tree.node.archive.file.read.only");
    private static Icon NOT_LATEST_CHECKED_OUT_ICON = new GIcon("icon.plugin.datatypes.tree.node.archive.file.checked.out.not.latest");
    private boolean isChanged;
    private boolean isReadOnly;
    private boolean isHijacked;
    private boolean isCheckedOut;
    private boolean isCheckedOutExclusive;
    private boolean isVersioned;
    private int version;
    private int latestVersion;
    private String domainFileInfoString;

    public DomainFileArchiveNode(DomainFileArchive archive, DtFilterState filterState) {
        super(archive, filterState);
        this.updateDomainFileInfo();
    }

    private void updateDomainFileInfo() {
        DomainObject domainObject = ((DomainFileArchive)this.archive).getDomainObject();
        DomainFile domainFile = ((DomainFileArchive)this.archive).getDomainFile();
        this.isChanged = domainObject.isChanged();
        this.isReadOnly = domainFile.isReadOnly() || !domainFile.isInWritableProject();
        this.isHijacked = domainFile.isHijacked();
        this.isVersioned = domainFile.isVersioned();
        this.version = this.isVersioned || !domainFile.canSave() ? domainFile.getVersion() : -1;
        this.isCheckedOutExclusive = !this.isVersioned && domainObject.hasExclusiveAccess() && !this.isReadOnly || this.isVersioned && domainFile.isCheckedOutExclusive();
        this.isCheckedOut = this.isCheckedOutExclusive || domainFile.isCheckedOut();
        this.latestVersion = domainFile.getLatestVersion();
        this.domainFileInfoString = this.createDomainFileInfoString();
    }

    private String createDomainFileInfoString() {
        DomainObject domainObject = ((DomainFileArchive)this.archive).getDomainObject();
        Object name = "";
        if (this.isHijacked) {
            name = (String)name + " (hijacked)";
        } else if (this.isVersioned) {
            name = this.version == this.latestVersion && !this.isCheckedOut ? (String)name + " (" + this.version + ")" : (String)name + " (" + this.version + " of " + this.latestVersion + ")";
        } else if (this.version != -1) {
            name = (String)name + " @ " + this.version;
        }
        if (!(domainObject instanceof Program) && this.isChanged) {
            name = (String)name + " *";
        }
        return name;
    }

    @Override
    public abstract String getToolTip();

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        Icon baseIcon = this.archive.getIcon(expanded);
        DtBackgroundIcon bgIcon = new DtBackgroundIcon(this.isVersioned);
        MultiIcon multiIcon = new MultiIcon((Icon)bgIcon);
        multiIcon.addIcon(baseIcon);
        if (this.isReadOnly) {
            multiIcon.addIcon((Icon)new TranslateIcon(READ_ONLY_ICON, 14, 3));
        } else if (this.isHijacked) {
            multiIcon.addIcon((Icon)new TranslateIcon(HIJACKED_ICON, 8, -4));
        } else if (this.isCheckedOut) {
            if (this.isCheckedOutExclusive) {
                multiIcon.addIcon((Icon)new TranslateIcon(CHECKED_OUT_EXCLUSIVE_ICON, 8, -4));
            } else if (this.version < this.latestVersion) {
                multiIcon.addIcon((Icon)new TranslateIcon(NOT_LATEST_CHECKED_OUT_ICON, 8, -4));
            } else {
                multiIcon.addIcon((Icon)new TranslateIcon(CHECKED_OUT_ICON, 8, -4));
            }
        }
        return multiIcon;
    }

    protected String getDomainObjectInfo() {
        return this.domainFileInfoString;
    }

    public DomainFile getDomainFile() {
        return ((DomainFileArchive)this.archive).getDomainFile();
    }

    @Override
    public void nodeChanged() {
        super.nodeChanged();
        this.updateDomainFileInfo();
    }
}

