/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.DockingUtils;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

public class GotoPreviousFunctionAction
extends NavigatableContextAction {
    private PluginTool tool;

    public GotoPreviousFunctionAction(PluginTool tool, String owner) {
        super("Go To Previous Function", owner);
        this.tool = tool;
        MenuData menuData = new MenuData(new String[]{"&\u5bfc\u822a", "Go To Previous Function"}, null, "GoTo");
        menuData.setMenuSubGroup("zb");
        this.setMenuBarData(menuData);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
        this.setKeyBindingData(new KeyBindingData(keyStroke));
        this.setHelpLocation(new HelpLocation("Navigation", "Next_Previous_Function"));
        this.addToWindowWhen(NavigatableActionContext.class);
    }

    private Function getPreviousFunction(Program program, Address address) {
        FunctionIterator functionIterator = program.getListing().getFunctions(address, false);
        if (!functionIterator.hasNext()) {
            return null;
        }
        Function nextFunction = (Function)functionIterator.next();
        if (!nextFunction.getEntryPoint().equals((Object)address)) {
            return nextFunction;
        }
        if (!functionIterator.hasNext()) {
            return null;
        }
        return (Function)functionIterator.next();
    }

    @Override
    protected void actionPerformed(NavigatableActionContext context) {
        Address address = context.getAddress();
        Program program = context.getProgram();
        Function function = this.getPreviousFunction(program, address);
        if (function == null) {
            return;
        }
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(program, function.getEntryPoint(), null, 0, function.getPrototypeString(false, false));
            Navigatable navigatable = context.getNavigatable();
            service.goTo(navigatable, (ProgramLocation)location, navigatable.getProgram());
        } else {
            this.tool.setStatusInfo("Can't find Go To Service!");
        }
    }
}

