/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileBytesProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.FunctionStartsCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.framework.options.Options;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MachoFunctionStartsAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Mach-O Function Starts";
    private static final String DESCRIPTION = "An analyzer for discovering functions via the Mach-O LC_FUNCTION_STARTS load command";
    private static String OPTION_NAME_BOOKMARKS_NEW = "Bookmark new functions";
    private static String OPTION_DESC_BOOKMARKS_NEW = "Create a bookmark for each function sucessfully created by this analyzer";
    private static boolean OPTION_DEFAULT_BOOKMARKS_NEW = false;
    private static String OPTION_NAME_BOOKMARKS_FAILED = "Bookmark failed functions";
    private static String OPTION_DESC_BOOKMARKS_FAILED = "Create a bookmark for each function that this analyzer failed to create";
    private static boolean OPTION_DEFAULT_BOOKMARKS_FAILED = false;
    private static String OPTION_NAME_BOOKMARKS_SKIPPED = "Bookmark skipped functions";
    private static String OPTION_DESC_BOOKMARKS_SKIPPED = "Create a bookmark for each function that this analyzer skipped";
    private static boolean OPTION_DEFAULT_BOOKMARKS_SKIPPED = false;
    private static String OPTION_NAME_USE_PSEUDO = "Use PseudoDisassembler";
    private static String OPTION_DESC_USE_PSEUDO = "Use the PseudoDisassembler to evaluate function start addresses (disable to troubleshoot)";
    private static boolean OPTION_DEFAULT_USE_PSEUDO = true;
    private boolean isDyld;
    private boolean createBookmarksNew = OPTION_DEFAULT_BOOKMARKS_NEW;
    private boolean createBookmarksFailed = OPTION_DEFAULT_BOOKMARKS_FAILED;
    private boolean createBookmarksSkipped = OPTION_DEFAULT_BOOKMARKS_SKIPPED;
    private boolean usePseudoDisassembler = OPTION_DEFAULT_USE_PSEUDO;

    public MachoFunctionStartsAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FUNCTION_ID_ANALYSIS.after());
    }

    @Override
    public boolean canAnalyze(Program program) {
        String format = program.getExecutableFormat();
        this.isDyld = "DYLD Cache".equals(format);
        return this.isDyld || "Mac OS X Mach-O".equals(format);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_BOOKMARKS_NEW, (Object)OPTION_DEFAULT_BOOKMARKS_NEW, null, OPTION_DESC_BOOKMARKS_NEW);
        options.registerOption(OPTION_NAME_BOOKMARKS_FAILED, (Object)OPTION_DEFAULT_BOOKMARKS_FAILED, null, OPTION_DESC_BOOKMARKS_FAILED);
        options.registerOption(OPTION_NAME_BOOKMARKS_SKIPPED, (Object)OPTION_DEFAULT_BOOKMARKS_SKIPPED, null, OPTION_DESC_BOOKMARKS_SKIPPED);
        options.registerOption(OPTION_NAME_USE_PSEUDO, (Object)OPTION_DEFAULT_USE_PSEUDO, null, OPTION_DESC_USE_PSEUDO);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createBookmarksNew = options.getBoolean(OPTION_NAME_BOOKMARKS_NEW, OPTION_DEFAULT_BOOKMARKS_NEW);
        this.createBookmarksFailed = options.getBoolean(OPTION_NAME_BOOKMARKS_FAILED, OPTION_DEFAULT_BOOKMARKS_FAILED);
        this.createBookmarksSkipped = options.getBoolean(OPTION_NAME_BOOKMARKS_SKIPPED, OPTION_DEFAULT_BOOKMARKS_SKIPPED);
        this.usePseudoDisassembler = options.getBoolean(OPTION_NAME_USE_PSEUDO, OPTION_DEFAULT_USE_PSEUDO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        ArrayList<ByteProvider> providers = new ArrayList<ByteProvider>();
        for (FileBytes fileBytes : program.getMemory().getAllFileBytes()) {
            providers.add(new FileBytesProvider(fileBytes));
        }
        try {
            if (this.isDyld) {
                this.analyzeDyldCacheFunctionStarts(program, providers, set, monitor, log);
            } else {
                this.analyzeMachoFunctionStarts(program, (ByteProvider)providers.get(0), set, monitor, log);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            for (ByteProvider provider : providers) {
                try {
                    provider.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private void analyzeMachoFunctionStarts(Program program, ByteProvider provider, AddressSetView set, TaskMonitor monitor, MessageLog log) throws MachException, IOException, CancelledException {
        MachHeader header = new MachHeader(provider);
        header.parse();
        monitor.setIndeterminate(true);
        monitor.setMessage("Analyzing function starts...");
        this.analyzeFunctionStarts(program, header, set, monitor);
    }

    private void analyzeDyldCacheFunctionStarts(Program program, List<ByteProvider> providers, AddressSetView set, TaskMonitor monitor, MessageLog log) throws MachException, IOException, CancelledException {
        ArrayList<DyldCacheHeader> headers = new ArrayList<DyldCacheHeader>();
        ArrayList<String> names = new ArrayList<String>();
        for (ByteProvider provider : providers) {
            DyldCacheHeader header = new DyldCacheHeader(new BinaryReader(provider, true));
            header.parseFromFile(false, log, monitor);
            headers.add(header);
            names.add(provider.getName());
        }
        try (DyldCacheUtils.SplitDyldCache splitDyldCache = new DyldCacheUtils.SplitDyldCache(providers, headers, names, log, monitor);){
            List<DyldCacheUtils.DyldCacheImageRecord> imageRecords = DyldCacheUtils.getImageRecords(headers);
            monitor.initialize((long)imageRecords.size());
            block6: for (DyldCacheUtils.DyldCacheImageRecord imageRecord : imageRecords) {
                String name = new File(imageRecord.image().getPath()).getName();
                monitor.checkCancelled();
                monitor.setMessage("Analyzing function starts for " + name + "...");
                monitor.incrementProgress(1L);
                MachHeader machoHeader = splitDyldCache.getMacho(imageRecord);
                machoHeader.parse(splitDyldCache);
                SegmentCommand linkEdit = machoHeader.getSegment("__LINKEDIT");
                if (linkEdit != null) {
                    boolean foundLinkEdit = false;
                    for (DyldCacheHeader h : headers) {
                        for (DyldCacheMappingInfo mappingInfo : h.getMappingInfos()) {
                            if (!mappingInfo.contains(linkEdit.getVMaddress(), true)) continue;
                            this.analyzeFunctionStarts(program, machoHeader, set, monitor);
                            foundLinkEdit = true;
                            break;
                        }
                        if (!foundLinkEdit) continue;
                        continue block6;
                    }
                    continue;
                }
                log.appendMsg("Failed to find __LINKEDIT segment for " + name);
            }
        }
    }

    private void analyzeFunctionStarts(Program program, MachHeader header, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        FunctionManager functionMgr = program.getFunctionManager();
        Listing listing = program.getListing();
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        Disassembler dis = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
        SegmentCommand textSegment = header.getSegment("__TEXT");
        if (textSegment == null) {
            return;
        }
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Address textSegmentAddr = space.getAddress(textSegment.getVMaddress());
        List<FunctionStartsCommand> commands = header.getLoadCommands(FunctionStartsCommand.class);
        for (FunctionStartsCommand cmd : commands) {
            for (Address addr : cmd.findFunctionStartAddrs(textSegmentAddr)) {
                monitor.checkCancelled();
                if (!set.contains(textSegmentAddr)) continue;
                String skipMessage = null;
                if (listing.getDataAt(addr) != null && !listing.isUndefined(addr, addr)) {
                    skipMessage = "Skipped Existing Data";
                } else if (functionMgr.getFunctionAt(addr) != null) {
                    skipMessage = "Skipped Existing Function";
                } else if (this.usePseudoDisassembler) {
                    try {
                        String UDF = "UDF";
                        PseudoInstruction instr = pdis.disassemble(addr);
                        if (instr != null && instr.getMnemonicString().equalsIgnoreCase("UDF")) {
                            skipMessage = "Skipped \"UDF\" Instruction";
                        } else if (!pdis.isValidSubroutine(addr, true, false)) {
                            skipMessage = "Skipped Invalid Subroutine";
                        }
                    }
                    catch (Exception e) {
                        skipMessage = e.getMessage();
                    }
                }
                if (skipMessage != null) {
                    if (!this.createBookmarksSkipped) continue;
                    this.setBookmark(program, addr, skipMessage);
                    continue;
                }
                AddressSet disassembledSet = dis.disassemble((AddressSetView)new AddressSet(addr), null, true);
                analysisMgr.codeDefined((AddressSetView)disassembledSet);
                CreateFunctionCmd fCommand = new CreateFunctionCmd(addr);
                if (fCommand.applyTo(program, monitor)) {
                    if (!this.createBookmarksNew) continue;
                    this.setBookmark(program, addr, "New Function");
                    continue;
                }
                if (!this.createBookmarksFailed) continue;
                this.setBookmark(program, addr, "Failed Function");
            }
        }
    }

    private void setBookmark(Program program, Address addr, String message) {
        BookmarkManager bookmarkMgr = program.getBookmarkManager();
        bookmarkMgr.setBookmark(addr, "Analysis", message, "LC_FUNCTION_STARTS");
    }
}

