/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.analysis.AnalysisPanel;
import ghidra.framework.options.EditorStateFactory;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class AnalysisOptionsDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private boolean doAnalysis;
    private AnalysisPanel panel;
    private EditorStateFactory editorStateFactory = new EditorStateFactory();
    private boolean hasChanges;

    AnalysisOptionsDialog(Program program) {
        this(List.of(program));
    }

    AnalysisOptionsDialog(List<Program> programs) {
        super("\u5206\u6790\u9009\u9879");
        this.setHelpLocation(new HelpLocation("AutoAnalysisPlugin", "AnalysisOptions"));
        this.panel = new AnalysisPanel(programs, this.editorStateFactory, (PropertyChangeListener)this);
        this.panel.setToLastUsedAnalysisOptionsIfProgramNotAnalyzed();
        this.panel.getAccessibleContext().setAccessibleName("\u5206\u6790\u9009\u9879");
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
        this.addApplyButton();
        this.setOkButtonText("\u5206\u6790");
        this.setFocusComponent(this.okButton);
        this.okButton.setMnemonic('A');
        this.setOkEnabled(true);
        this.setPreferredSize(1000, 600);
        this.setRememberSize(true);
        this.setHasChanges(this.panel.hasChangedValues());
    }

    public void okCallback() {
        try {
            this.panel.applyChanges();
            this.doAnalysis = true;
            this.close();
        }
        catch (Exception e) {
            Msg.showError((Object)this, (Component)this.panel, (String)"\u8bbe\u7f6e\u5206\u6790\u9009\u9879\u65f6\u51fa\u9519", (Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void cancelCallback() {
        if (this.hasChanges) {
            int result = OptionDialog.showYesNoCancelDialog((Component)this.panel, (String)"\u4fdd\u5b58\u66f4\u6539?", (String)"\u8fd9\u4e9b\u9009\u9879\u4e0e\u7a0b\u5e8f\u4e2d\u7684\u5185\u5bb9\u4e0d\u540c\u3002\n\u60a8\u60f3\u5c06\u5b83\u4eec\u4fdd\u5b58\u5230\u7a0b\u5e8f\u4e2d\u5417?");
            if (result == 0) {
                return;
            }
            if (result == 1) {
                this.panel.applyChanges();
            }
        }
        this.close();
    }

    protected void applyCallback() {
        this.panel.applyChanges();
        this.setHasChanges(false);
    }

    boolean wasAnalyzeButtonSelected() {
        return this.doAnalysis;
    }

    private void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
        this.setApplyEnabled(hasChanges);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("apply.enabled")) {
            this.setHasChanges((Boolean)evt.getNewValue());
        }
    }
}

