/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import javax.swing.Icon;

public class UndoAction
extends DockingAction {
    private final VTController controller;

    public UndoAction(VTController controller) {
        super("Undo", VTPlugin.OWNER);
        this.controller = controller;
        this.setHelpLocation(new HelpLocation("Tool", "Undo"));
        String[] menuPath = new String[]{"&\u7f16\u8f91", "&Undo"};
        String group = "ZZUndo";
        GIcon icon = new GIcon("icon.undo");
        MenuData menuData = new MenuData(menuPath, (Icon)icon, group);
        menuData.setMenuSubGroup("1Undo");
        this.setMenuBarData(menuData);
        this.setToolBarData(new ToolBarData((Icon)icon, group));
        this.setDescription("Undo");
        this.setKeyBindingData(new KeyBindingData('Z', 2));
    }

    public void actionPerformed(ActionContext programContext) {
        VTSessionDB session = (VTSessionDB)this.controller.getSession();
        if (session == null) {
            return;
        }
        try {
            session.undo();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        VTSessionDB session = (VTSessionDB)this.controller.getSession();
        if (session != null && session.canUndo()) {
            String name = session.getName();
            this.getMenuBarData().setMenuItemName("Undo " + name);
            String tip = HTMLUtilities.toWrappedHTML((String)("Undo " + session.getUndoName()));
            this.setDescription(tip);
            return true;
        }
        this.setDescription("Undo");
        this.getMenuBarData().setMenuItemName("Undo");
        return false;
    }
}

