/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import db.Transaction;
import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerEmulationIntegration;
import ghidra.app.plugin.core.debug.service.emulation.DefaultEmulatorFactory;
import ghidra.app.plugin.core.debug.service.emulation.ProgramEmulationUtils;
import ghidra.app.plugin.core.debug.service.emulation.data.DefaultPcodeDebuggerAccess;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncLazyMap;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.emulation.EmulatorFactory;
import ghidra.debug.api.emulation.PcodeDebuggerAccess;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.exec.InjectionErrorPcodeExecutionException;
import ghidra.pcode.exec.trace.TraceEmulationIntegration;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.Scheduler;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.exception.ExceptionUtils;

@PluginInfo(shortDescription="Debugger Emulation Service Plugin", description="Manages and cache trace emulation states", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceClosedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerStaticMappingService.class}, servicesProvided={DebuggerEmulationService.class})
public class DebuggerEmulationServicePlugin
extends Plugin
implements DebuggerEmulationService {
    protected static final int MAX_CACHE_SIZE = 5;
    private static final AutoConfigState.ClassHandler<DebuggerEmulationServicePlugin> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerEmulationServicePlugin.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @AutoConfigStateField
    private String defaultEmulator = "Default Concrete P-code Emulator";
    protected EmulatorFactory emulatorFactory = new DefaultEmulatorFactory();
    protected final Set<CacheKey> eldest = new LinkedHashSet<CacheKey>();
    protected final NavigableMap<CacheKey, DebuggerEmulationService.CachedEmulator> cache = new TreeMap<CacheKey, DebuggerEmulationService.CachedEmulator>();
    protected final AsyncLazyMap<CacheKey, Long> requests = new AsyncLazyMap(new HashMap(), this::doBackgroundEmulate).forgetErrors((key, t) -> true).forgetValues((key, l) -> true);
    protected final Map<DebuggerEmulationService.CachedEmulator, Integer> busy = new LinkedHashMap<DebuggerEmulationService.CachedEmulator, Integer>();
    protected final ListenerSet<DebuggerEmulationService.EmulatorStateListener> stateListeners = new ListenerSet(DebuggerEmulationService.EmulatorStateListener.class, true);
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerTargetService targetService;
    @AutoServiceConsumed
    private DebuggerPlatformService platformService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappings;
    @AutoServiceConsumed
    private DebuggerControlService controlService;
    private AutoService.Wiring autoServiceWiring;
    DockingAction actionEmulateProgram;
    DockingAction actionEmulateAddThread;
    DockingAction actionInvalidateCache;
    Map<Class<? extends EmulatorFactory>, ToggleDockingAction> actionsChooseEmulatorFactory = new HashMap<Class<? extends EmulatorFactory>, ToggleDockingAction>();
    final ChangeListener classChangeListener = this::classesChanged;

    public DebuggerEmulationServicePlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void createActions() {
        this.actionEmulateProgram = (DockingAction)EmulateProgramAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::emulateProgramEnabled).popupWhen(this::emulateProgramEnabled).onAction(this::emulateProgramActivated).buildAndInstall((Tool)this.tool);
        this.actionEmulateAddThread = (DockingAction)EmulateAddThreadAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::emulateAddThreadEnabled).popupWhen(this::emulateAddThreadEnabled).onAction(this::emulateAddThreadActivated).buildAndInstall((Tool)this.tool);
        this.actionInvalidateCache = (DockingAction)((ActionBuilder)((ActionBuilder)InvalidateEmulatorCacheAction.builder(this).enabledWhen(this::invalidateCacheEnabled)).onAction(this::invalidateCacheActivated)).buildAndInstall((Tool)this.tool);
        ClassSearcher.addChangeListener((ChangeListener)this.classChangeListener);
        this.updateConfigureEmulatorStates();
    }

    private void classesChanged(ChangeEvent e) {
        this.updateConfigureEmulatorStates();
    }

    private ToggleDockingAction createActionChooseEmulator(EmulatorFactory factory) {
        ToggleDockingAction action = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)ConfigureEmulatorAction.builder(this).menuPath(new String[]{"Debugger", "Configure Emulator", factory.getTitle()})).onAction(ctx -> this.configureEmulatorActivated(factory))).buildAndInstall((Tool)this.tool);
        String[] path = action.getMenuBarData().getMenuPath();
        this.tool.setMenuGroup(Arrays.copyOf(path, path.length - 1), "zz");
        return action;
    }

    private void updateConfigureEmulatorStates() {
        Map<Class, EmulatorFactory> byClass = this.getEmulatorFactories().stream().collect(Collectors.toMap(EmulatorFactory::getClass, Objects::requireNonNull));
        for (Map.Entry<Class<? extends EmulatorFactory>, ToggleDockingAction> ent : this.actionsChooseEmulatorFactory.entrySet()) {
            if (byClass.keySet().contains(ent.getKey())) continue;
            this.tool.removeAction((DockingActionIf)ent.getValue());
        }
        for (Map.Entry<Class, EmulatorFactory> ent : byClass.entrySet()) {
            if (this.actionsChooseEmulatorFactory.containsKey(ent.getKey())) continue;
            ToggleDockingAction action = this.createActionChooseEmulator(ent.getValue());
            action.setSelected(ent.getKey() == this.emulatorFactory.getClass());
            this.actionsChooseEmulatorFactory.put(ent.getKey(), action);
        }
    }

    private boolean emulateProgramEnabled(ProgramLocationActionContext ctx) {
        Program program = ctx.getProgram();
        return program != null && !(program instanceof TraceProgramView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emulateProgramActivated(ProgramLocationActionContext ctx) {
        Program program = ctx.getProgram();
        if (program == null) {
            return;
        }
        Trace trace = null;
        try {
            trace = ProgramEmulationUtils.launchEmulationTrace(program, ctx.getAddress(), (Object)this);
            this.traceManager.openTrace(trace);
            this.traceManager.activateTrace(trace);
            if (this.controlService != null) {
                this.controlService.setCurrentMode(trace, ControlMode.RW_EMULATOR);
            }
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)this.actionEmulateProgram.getDescription(), (Object)"Could not create trace for emulation", (Throwable)e);
        }
        finally {
            if (trace != null) {
                trace.release((Object)this);
            }
        }
    }

    private boolean emulateAddThreadEnabled(ProgramLocationActionContext ctx) {
        Program programOrView = ctx.getProgram();
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            return ProgramEmulationUtils.isEmulatedProgram(view.getTrace());
        }
        DebuggerCoordinates current = this.traceManager.getCurrent();
        if (current.getTrace() == null || !ProgramEmulationUtils.isEmulatedProgram(current.getTrace())) {
            return false;
        }
        TraceLocation traceLoc = this.staticMappings.getOpenMappedLocation(current.getTrace(), ctx.getLocation(), current.getSnap());
        return traceLoc != null;
    }

    private void emulateAddThreadActivated(ProgramLocationActionContext ctx) {
        Program programOrView = ctx.getProgram();
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            Trace trace = view.getTrace();
            Address tracePc = ctx.getAddress();
            long snap = view.getViewport().getOrderedSnaps().stream().filter(s -> s >= 0L).findFirst().get();
            ProgramLocation progLoc = this.staticMappings.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(trace, null, Lifespan.at((long)snap), tracePc));
            Program program = progLoc == null ? null : progLoc.getProgram();
            Address programPc = progLoc == null ? null : progLoc.getAddress();
            TraceThread thread = ProgramEmulationUtils.launchEmulationThread(trace, snap, program, tracePc, programPc);
            this.traceManager.activateThread(thread);
        } else {
            Program program = programOrView;
            Address programPc = ctx.getAddress();
            DebuggerCoordinates current = this.traceManager.getCurrent();
            long snap = current.getSnap();
            Trace trace = current.getTrace();
            TraceLocation traceLoc = this.staticMappings.getOpenMappedLocation(trace, ctx.getLocation(), snap);
            if (traceLoc == null) {
                return;
            }
            Address tracePc = traceLoc.getAddress();
            TraceThread thread = ProgramEmulationUtils.launchEmulationThread(trace, snap, program, tracePc, programPc);
            this.traceManager.activateThread(thread);
        }
    }

    private boolean invalidateCacheEnabled(ActionContext ignored) {
        return this.traceManager.getCurrentTrace() != null;
    }

    private void invalidateCacheActivated(ActionContext ignored) {
        this.invalidateCache();
    }

    private void configureEmulatorActivated(EmulatorFactory factory) {
        this.setEmulatorFactory(factory);
    }

    public void invalidateCache() {
        DebuggerCoordinates current = this.traceManager.getCurrent();
        Trace trace = current.getTrace();
        long version = trace.getEmulatorCacheVersion();
        try (Transaction tx = trace.openTransaction("Invalidate Emulator Cache");){
            trace.setEmulatorCacheVersion(version + 1L);
        }
        this.traceManager.materialize(current);
    }

    public Collection<EmulatorFactory> getEmulatorFactories() {
        return ClassSearcher.getInstances(EmulatorFactory.class);
    }

    public synchronized void setEmulatorFactory(EmulatorFactory factory) {
        this.emulatorFactory = Objects.requireNonNull(factory);
        this.defaultEmulator = this.emulatorFactory.getTitle();
        for (ToggleDockingAction toggle : this.actionsChooseEmulatorFactory.values()) {
            toggle.setSelected(false);
        }
        ToggleDockingAction chosen = this.actionsChooseEmulatorFactory.get(factory.getClass());
        if (chosen == null) {
            Msg.warn((Object)((Object)this), (Object)("An undiscovered emulator factory was set via the API: " + String.valueOf(factory)));
            return;
        }
        chosen.setSelected(true);
    }

    public synchronized EmulatorFactory getEmulatorFactory() {
        return this.emulatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<CacheKey, DebuggerEmulationService.CachedEmulator> findNearestPrefix(CacheKey key) {
        NavigableMap<CacheKey, DebuggerEmulationService.CachedEmulator> navigableMap = this.cache;
        synchronized (navigableMap) {
            Map.Entry<CacheKey, DebuggerEmulationService.CachedEmulator> candidate = this.cache.floorEntry(key);
            if (candidate == null || !candidate.getValue().isValid()) {
                return null;
            }
            if (!candidate.getKey().compareKey((CacheKey)key).related) {
                return null;
            }
            return candidate;
        }
    }

    protected CompletableFuture<Long> doBackgroundEmulate(CacheKey key) {
        EmulateTask task = new EmulateTask(key);
        this.tool.execute((Task)task, 500);
        return task.future;
    }

    public CompletableFuture<Long> backgroundEmulate(TracePlatform platform, TraceSchedule time) {
        this.requireOpen(platform.getTrace());
        if (time.isSnapOnly()) {
            return CompletableFuture.completedFuture(time.getSnap());
        }
        return this.requests.get((Object)new CacheKey(platform, time));
    }

    public CompletableFuture<DebuggerEmulationService.EmulationResult> backgroundRun(TracePlatform platform, TraceSchedule from, Scheduler scheduler) {
        this.requireOpen(platform.getTrace());
        CacheKey key = new CacheKey(platform, from);
        RunEmulatorTask task = new RunEmulatorTask(key, scheduler);
        this.tool.execute((Task)task, 500);
        return task.future;
    }

    protected void installBreakpoints(Trace trace, long snap, PcodeMachine<?> emu) {
        Lifespan span = Lifespan.at((long)snap);
        TraceBreakpointManager bm = trace.getBreakpointManager();
        for (AddressSpace as : trace.getBaseAddressFactory().getAddressSpaces()) {
            for (TraceBreakpointLocation bpt : bm.getBreakpointsIntersecting(span, (AddressRange)new AddressRangeImpl(as.getMinAddress(), as.getMaxAddress()))) {
                if (!bpt.isEmuEnabled(snap)) continue;
                Set kinds = bpt.getKinds(snap);
                boolean isExecute = kinds.contains(TraceBreakpointKind.HW_EXECUTE) || kinds.contains(TraceBreakpointKind.SW_EXECUTE);
                boolean isRead = kinds.contains(TraceBreakpointKind.READ);
                boolean isWrite = kinds.contains(TraceBreakpointKind.WRITE);
                if (isExecute) {
                    Address minAddress = bpt.getMinAddress(snap);
                    try {
                        emu.inject(minAddress, bpt.getEmuSleigh(snap));
                    }
                    catch (Exception e) {
                        Msg.error((Object)((Object)this), (Object)("Error compiling breakpoint Sleigh at " + String.valueOf(minAddress)), (Throwable)e);
                        emu.inject(minAddress, "emu_injection_err();");
                    }
                }
                if (isRead && isWrite) {
                    emu.addAccessBreakpoint(bpt.getRange(snap), PcodeMachine.AccessKind.RW);
                    continue;
                }
                if (isRead) {
                    emu.addAccessBreakpoint(bpt.getRange(snap), PcodeMachine.AccessKind.R);
                    continue;
                }
                if (!isWrite) continue;
                emu.addAccessBreakpoint(bpt.getRange(snap), PcodeMachine.AccessKind.W);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BusyEmu doEmulateFromCached(CacheKey key, TaskMonitor monitor) throws CancelledException {
        Map.Entry<CacheKey, DebuggerEmulationService.CachedEmulator> cachePrefix;
        Trace trace = key.trace;
        TracePlatform platform = key.platform;
        TraceSchedule time = key.time;
        TraceSnapshot tracePrefix = trace.getTimeManager().findSnapshotWithNearestPrefix(time);
        if (tracePrefix != null && tracePrefix.isSnapOnly(true)) {
            tracePrefix = null;
        }
        if ((cachePrefix = this.findNearestPrefix(key)) != null && (tracePrefix == null || cachePrefix.getKey().time.compareTo(tracePrefix.getSchedule()) >= 0)) {
            CacheKey prevKey = cachePrefix.getKey();
            Msg.debug((Object)((Object)this), (Object)"Using cached emulator at %s".formatted(prevKey.time));
            NavigableMap<CacheKey, DebuggerEmulationService.CachedEmulator> navigableMap = this.cache;
            synchronized (navigableMap) {
                this.cache.remove(prevKey);
                this.eldest.remove(prevKey);
            }
            try (BusyEmu be = new BusyEmu(cachePrefix.getValue());){
                PcodeMachine emu = be.ce.emulator();
                emu.clearAllInjects();
                emu.clearAccessBreakpoints();
                emu.setSuspended(false);
                this.installBreakpoints(key.trace, key.time.getSnap(), be.ce.emulator());
                monitor.initialize(time.totalTickCount() - prevKey.time.totalTickCount());
                this.createRegisterSpaces(trace, time, monitor);
                monitor.setMessage("Emulating");
                time.finish(trace, prevKey.time, emu, monitor);
                BusyEmu busyEmu = be.dup();
                return busyEmu;
            }
        }
        Target target = this.targetService == null ? null : this.targetService.getTarget(trace);
        DefaultPcodeDebuggerAccess from = new DefaultPcodeDebuggerAccess((ServiceProvider)this.tool, target, platform, tracePrefix != null ? tracePrefix.getKey() : time.getSnap(), time.getSnap());
        TraceEmulationIntegration.Writer writer = DebuggerEmulationIntegration.bytesDelayedWriteTrace(from);
        PcodeMachine emu = this.emulatorFactory.create((PcodeDebuggerAccess)from, writer);
        try (BusyEmu be = new BusyEmu(new DebuggerEmulationService.CachedEmulator(key.trace, emu, writer));){
            this.installBreakpoints(key.trace, key.time.getSnap(), be.ce.emulator());
            monitor.initialize(time.totalTickCount() - (tracePrefix != null ? tracePrefix.getSchedule().totalTickCount() : 0L));
            this.createRegisterSpaces(trace, time, monitor);
            monitor.setMessage("Emulating");
            if (tracePrefix != null) {
                Msg.debug((Object)((Object)this), (Object)"Using new emulator from scratch snapshot %s".formatted(tracePrefix.getScheduleString()));
                time.finish(trace, tracePrefix.getSchedule(), emu, monitor);
            } else {
                Msg.debug((Object)((Object)this), (Object)"Using new emulator from snap %d".formatted(time.getSnap()));
                time.execute(trace, emu, monitor);
            }
            BusyEmu busyEmu = be.dup();
            return busyEmu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheEmulator(CacheKey key, DebuggerEmulationService.CachedEmulator ce) {
        NavigableMap<CacheKey, DebuggerEmulationService.CachedEmulator> navigableMap = this.cache;
        synchronized (navigableMap) {
            this.cache.put(key, ce);
            this.eldest.add(key);
            assert (this.cache.size() == this.eldest.size());
            while (this.cache.size() > 5) {
                CacheKey expired = this.eldest.iterator().next();
                this.eldest.remove(expired);
                this.cache.remove(expired);
            }
        }
    }

    protected TraceSnapshot writeToScratch(CacheKey key, DebuggerEmulationService.CachedEmulator ce) {
        TraceSnapshot destSnap;
        try (Transaction tx = key.trace.openTransaction("Emulate");){
            destSnap = key.trace.getTimeManager().findScratchSnapshot(key.time);
            destSnap.setDescription("Emulated");
            try {
                DefaultPcodeTraceAccess into = new DefaultPcodeTraceAccess(key.platform, destSnap.getKey(), key.time.getSnap());
                ce.writer().writeDown((PcodeTraceAccess)into);
                TraceThread lastThread = key.time.getLastThread(key.trace);
                destSnap.setEventThread(lastThread);
                destSnap.setVersion(key.trace.getEmulatorCacheVersion());
            }
            catch (Throwable e) {
                Msg.showError((Object)((Object)this), null, (String)"Emulate", (Object)"There was an issue writing the emulation result to the trace. The displayed state may be inaccurate and/or incomplete.", (Throwable)e);
            }
        }
        key.trace.clearUndo();
        return destSnap;
    }

    protected long doEmulate(CacheKey key, TaskMonitor monitor) throws CancelledException {
        try (BusyEmu be = this.doEmulateFromCached(key, monitor);){
            TraceSnapshot destSnap = this.writeToScratch(key, be.ce);
            this.cacheEmulator(key, be.ce);
            long l = destSnap.getKey();
            return l;
        }
    }

    protected DebuggerEmulationService.EmulationResult doRun(CacheKey key, TaskMonitor monitor, Scheduler scheduler) throws CancelledException {
        try (BusyEmu be = this.doEmulateFromCached(key, monitor);){
            TraceThread eventThread = key.time.getEventThread(key.trace);
            be.ce.emulator().setSoftwareInterruptMode(PcodeMachine.SwiMode.IGNORE_STEP);
            Scheduler.RunResult result = scheduler.run(key.trace, eventThread, be.ce.emulator(), monitor);
            key = result.schedule().hasSteps() ? new CacheKey(key.platform, key.time.dropPSteps().advanced(result.schedule())) : new CacheKey(key.platform, key.time.advanced(result.schedule()));
            Msg.info((Object)((Object)this), (Object)("Stopped emulation at " + String.valueOf(key.time)));
            TraceSnapshot destSnap = this.writeToScratch(key, be.ce);
            this.cacheEmulator(key, be.ce);
            DebuggerEmulationService.RecordEmulationResult recordEmulationResult = new DebuggerEmulationService.RecordEmulationResult(key.time, destSnap.getKey(), result.error());
            return recordEmulationResult;
        }
    }

    protected void createRegisterSpaces(Trace trace, TraceSchedule time, TaskMonitor monitor) {
        if (trace.getObjectManager().getRootObject() == null) {
            return;
        }
        monitor.setMessage("Creating register spaces");
        try (Transaction tx = trace.openTransaction("Prepare emulation");){
            for (TraceThread thread : time.getThreads(trace)) {
                trace.getMemoryManager().getMemoryRegisterSpace(thread, 0, true);
            }
        }
        trace.clearUndo();
    }

    protected void requireOpen(Trace trace) {
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Cannot emulate a trace unless it's opened in the tool.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trace launchProgram(Program program, Address address) throws IOException {
        Trace trace = null;
        try {
            trace = ProgramEmulationUtils.launchEmulationTrace(program, address, (Object)this);
            trace.flushEvents();
            TraceMappingWaiter waiter = new TraceMappingWaiter(this, trace);
            this.staticMappings.addChangeListener((DebuggerStaticMappingChangeListener)waiter);
            this.traceManager.openTrace(trace);
            this.traceManager.activateTrace(trace);
            waiter.softWait();
        }
        finally {
            if (trace != null) {
                trace.release((Object)this);
            }
        }
        return trace;
    }

    public long emulate(TracePlatform platform, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        this.requireOpen(platform.getTrace());
        if (time.isSnapOnly()) {
            return time.getSnap();
        }
        return this.doEmulate(new CacheKey(platform, time), monitor);
    }

    public DebuggerEmulationService.EmulationResult run(TracePlatform platform, TraceSchedule from, TaskMonitor monitor, Scheduler scheduler) throws CancelledException {
        Trace trace = platform.getTrace();
        this.requireOpen(trace);
        return this.doRun(new CacheKey(platform, from), monitor, scheduler);
    }

    public PcodeMachine<?> getCachedEmulator(Trace trace, TraceSchedule time) {
        DebuggerEmulationService.CachedEmulator ce = (DebuggerEmulationService.CachedEmulator)this.cache.get(new CacheKey(trace.getPlatformManager().getHostPlatform(), time));
        return ce == null || !ce.isValid() ? null : ce.emulator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DebuggerEmulationService.CachedEmulator> getBusyEmulators() {
        Map<DebuggerEmulationService.CachedEmulator, Integer> map = this.busy;
        synchronized (map) {
            return List.copyOf(this.busy.keySet());
        }
    }

    public void addStateListener(DebuggerEmulationService.EmulatorStateListener listener) {
        this.stateListeners.add((Object)listener);
    }

    public void removeStateListener(DebuggerEmulationService.EmulatorStateListener listener) {
        this.stateListeners.remove((Object)listener);
    }

    @AutoServiceConsumed
    private void setTraceManager(DebuggerTraceManagerService traceManager) {
        this.cache.clear();
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerTargetService targetService) {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            NavigableMap<CacheKey, DebuggerEmulationService.CachedEmulator> navigableMap = this.cache;
            synchronized (navigableMap) {
                List toRemove = this.eldest.stream().filter(k -> k.trace == evt.getTrace()).collect(Collectors.toList());
                this.cache.keySet().removeAll(toRemove);
                this.eldest.removeAll(toRemove);
                assert (this.cache.size() == this.eldest.size());
            }
        }
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        for (ToggleDockingAction toggle : this.actionsChooseEmulatorFactory.values()) {
            toggle.setSelected(toggle.getMenuBarData().getMenuItemName().equals(this.defaultEmulator));
        }
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public static interface EmulateProgramAction {
        public static final String NAME = "Emulate Program in new Trace";
        public static final String DESCRIPTION = "Emulate the current program in a new trace starting at the cursor";
        public static final Icon ICON = DebuggerResources.ICON_EMULATE;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "emulate_program";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP)).menuPath(new String[]{"Debugger", NAME})).menuIcon(ICON)).menuGroup(GROUP)).popupMenuPath(new String[]{NAME})).popupMenuIcon(ICON)).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface EmulateAddThreadAction {
        public static final String NAME = "Add Emulated Thread to Trace";
        public static final String DESCRIPTION = "Add an emulated thread to the current trace starting here";
        public static final Icon ICON = DebuggerResources.ICON_THREAD;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "add_emulated_thread";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuIcon(ICON)).menuGroup(GROUP)).popupMenuPath(new String[]{NAME})).popupMenuIcon(ICON)).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface InvalidateEmulatorCacheAction {
        public static final String NAME = "Invalidate Emulator Cache";
        public static final String DESCRIPTION = "Prevent the emulation service from using cached snapshots from the current trace";
        public static final String GROUP = "Dbg8. Maintenance";
        public static final String HELP_ANCHOR = "invalidate_cache";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Configure Emulator", NAME})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ConfigureEmulatorAction {
        public static final String NAME = "Configure Emulator";
        public static final String DESCRIPTION = "Choose and configure the current emulator";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "configure_emulator";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected static class CacheKey
    implements Comparable<CacheKey> {
        protected final Trace trace;
        protected final TracePlatform platform;
        protected final TraceSchedule time;
        private final int hashCode;

        public CacheKey(TracePlatform platform, TraceSchedule time) {
            this.platform = Objects.requireNonNull(platform);
            this.trace = platform.getTrace();
            this.time = Objects.requireNonNull(time);
            this.hashCode = Objects.hash(this.trace, time);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            if (this.trace != that.trace) {
                return false;
            }
            return Objects.equals(this.time, that.time);
        }

        @Override
        public int compareTo(CacheKey that) {
            return this.compareKey((CacheKey)that).compareTo;
        }

        public CompareResult compareKey(CacheKey that) {
            CompareResult result = CompareResult.unrelated((int)Integer.compare(System.identityHashCode(this.trace), System.identityHashCode(that.trace)));
            if (result != CompareResult.EQUALS) {
                return result;
            }
            result = this.time.compareSchedule(that.time);
            if (result != CompareResult.EQUALS) {
                return result;
            }
            return CompareResult.EQUALS;
        }
    }

    protected class EmulateTask
    extends AbstractEmulateTask<Long> {
        protected final CacheKey key;

        public EmulateTask(CacheKey key) {
            super(DebuggerEmulationServicePlugin.this, "Emulate " + String.valueOf(key.time) + " in " + String.valueOf(key.trace), true);
            this.key = key;
        }

        @Override
        protected Long compute(TaskMonitor monitor) throws CancelledException {
            return DebuggerEmulationServicePlugin.this.doEmulate(this.key, monitor);
        }
    }

    protected class RunEmulatorTask
    extends AbstractEmulateTask<DebuggerEmulationService.EmulationResult> {
        private final CacheKey from;
        private final Scheduler scheduler;

        public RunEmulatorTask(CacheKey from, Scheduler scheduler) {
            super(DebuggerEmulationServicePlugin.this, "Emulating...", false);
            this.from = from;
            this.scheduler = scheduler;
        }

        @Override
        protected DebuggerEmulationService.EmulationResult compute(TaskMonitor monitor) throws CancelledException {
            DebuggerEmulationService.EmulationResult result = DebuggerEmulationServicePlugin.this.doRun(this.from, monitor, this.scheduler);
            if (result.error() instanceof InjectionErrorPcodeExecutionException) {
                Msg.showError((Object)((Object)this), null, (String)"Breakpoint Emulation Error", (Object)"Compilation error in user-provided breakpoint Sleigh code.");
            }
            return result;
        }
    }

    class BusyEmu
    implements AutoCloseable {
        private final DebuggerEmulationService.CachedEmulator ce;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BusyEmu(DebuggerEmulationService.CachedEmulator ce) {
            this.ce = ce;
            boolean fire = false;
            Map<DebuggerEmulationService.CachedEmulator, Integer> map = DebuggerEmulationServicePlugin.this.busy;
            synchronized (map) {
                Integer count = DebuggerEmulationServicePlugin.this.busy.get(ce);
                if (count == null) {
                    DebuggerEmulationServicePlugin.this.busy.put(ce, 1);
                    fire = true;
                } else {
                    DebuggerEmulationServicePlugin.this.busy.put(ce, count + 1);
                }
            }
            if (fire) {
                ((DebuggerEmulationService.EmulatorStateListener)DebuggerEmulationServicePlugin.this.stateListeners.invoke()).running(ce);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            boolean fire = false;
            Map<DebuggerEmulationService.CachedEmulator, Integer> map = DebuggerEmulationServicePlugin.this.busy;
            synchronized (map) {
                int count = DebuggerEmulationServicePlugin.this.busy.get(this.ce);
                if (count == 1) {
                    DebuggerEmulationServicePlugin.this.busy.remove(this.ce);
                    fire = true;
                } else {
                    DebuggerEmulationServicePlugin.this.busy.put(this.ce, count - 1);
                }
            }
            if (fire) {
                ((DebuggerEmulationService.EmulatorStateListener)DebuggerEmulationServicePlugin.this.stateListeners.invoke()).stopped(this.ce);
            }
        }

        public BusyEmu dup() {
            return new BusyEmu(this.ce);
        }
    }

    class TraceMappingWaiter
    extends CompletableFuture<Void>
    implements DebuggerStaticMappingChangeListener {
        private final Trace trace;

        public TraceMappingWaiter(DebuggerEmulationServicePlugin this$0, Trace trace) {
            this.trace = trace;
        }

        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            if (affectedTraces.contains(this.trace)) {
                this.complete(null);
            }
        }

        public void softWait() {
            try {
                this.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Msg.warn((Object)this, (Object)"Mappings not reported by service after 1 second");
            }
        }
    }

    protected abstract class AbstractEmulateTask<T>
    extends Task {
        protected final CompletableFuture<T> future = new CompletableFuture();

        public AbstractEmulateTask(DebuggerEmulationServicePlugin this$0, String title, boolean hasProgress) {
            super(title, true, hasProgress, false, false);
        }

        protected abstract T compute(TaskMonitor var1) throws CancelledException;

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                this.future.complete(this.compute(monitor));
            }
            catch (CancelledException e) {
                this.future.completeExceptionally(e);
                throw e;
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }
}

