/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.EmptyBorderToggleButton;
import docking.ReusableDialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.actions.KeyBindingUtils;
import docking.actions.SharedDockingActionPlaceholder;
import docking.actions.ToolActions;
import docking.menu.DockingToolBarUtils;
import docking.widgets.DropDownSelectionChoiceListener;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.EmptyBorderButton;
import docking.widgets.combobox.GComboBox;
import docking.widgets.filechooser.DirectoryList;
import docking.widgets.filechooser.DirectoryListModel;
import docking.widgets.filechooser.DirectoryTable;
import docking.widgets.filechooser.DirectoryTableModel;
import docking.widgets.filechooser.FileChooserActionManager;
import docking.widgets.filechooser.FileChooserToggleButton;
import docking.widgets.filechooser.FileComparator;
import docking.widgets.filechooser.FileDropDownSelectionDataModel;
import docking.widgets.filechooser.GFileChooserOptionsDialog;
import docking.widgets.filechooser.GhidraFile;
import docking.widgets.filechooser.GhidraFileChooserDirectoryModelIf;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.filechooser.LocalFileChooserModel;
import docking.widgets.filechooser.RecentGhidraFile;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.textfield.GFormattedTextField;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import ghidra.util.worker.Worker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;
import util.CollectionUtils;
import util.HistoryList;

public class GhidraFileChooser
extends ReusableDialogComponentProvider
implements FileFilter {
    private static final int BIG_DATA_THRESHOLD = 200;
    private static final String ACTION_NAME_BACK = "Last Folder Visited";
    private static final String ACTION_NAME_FORWARD = "Previous Folder Visited";
    private static final String ACTION_NAME_UP = "Up One Level";
    static final String UP_BUTTON_NAME = "UP_BUTTON";
    private static final Color FOREROUND_COLOR = new GColor("color.fg.filechooser");
    private static final Color BACKGROUND_COLOR = new GColor("color.bg.filechooser");
    private static final Color SHORTCUT_BACKGROUND_COLOR = new GColor("color.bg.filechooser.shortcut");
    static final String PREFERENCES_PREFIX = "G_FILE_CHOOSER";
    private static final String WIDTH_PREFERENCE_PREFIX = "G_FILE_CHOOSER.WIDTH.";
    private static final String HEIGHT_PREFERENCE_PREFIX = "G_FILE_CHOOSER.HEIGHT.";
    private static final String VIEW_STYLE_PREFIX = "G_FILE_CHOOSER.VIEW_STYLE.";
    private static final String DETAILS_VIEW_STYLE = "DetailsView";
    private static final String SIMPLE_VIEW_STYLE = "SimpleView";
    private static final String CARD_LIST = "LIST";
    private static final String CARD_TABLE = "TABLE";
    private static final String CARD_WAIT = "WAIT";
    static final String TITLE = "File Chooser";
    static final String DOT = ".";
    static final String DOTDOT = "..";
    static final String NEW_FOLDER = "New Folder";
    static final Pattern INVALID_FILENAME_PATTERN = Pattern.compile("[/\\\\*?]");
    private static final int PAD = 5;
    private static final Icon ICON_BACK = new GIcon("icon.left");
    private static final Icon ICON_FORWARD = new GIcon("icon.right");
    private static final Icon ICON_UP = new GIcon("icon.up");
    private static final Icon ICON_DETAILS = new GIcon("icon.table");
    private static final Icon ICON_OPTIONS = new GIcon("icon.properties");
    private static final Icon ICON_NEW_FOLDER = new GIcon("icon.folder.new");
    private static final Icon ICON_MY_COMPUTER = new GIcon("icon.filechooser.places.my.computer");
    private static final Icon ICON_DESKTOP = new GIcon("icon.filechooser.places.desktop");
    private static final Icon ICON_HOME = new GIcon("icon.filechooser.places.home");
    private static final Icon ICON_DOWNLOADS = new GIcon("icon.filechooser.places.downloads");
    private static final Icon ICON_RECENT = new GIcon("icon.filechooser.places.recent");
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    static final File MY_COMPUTER = new File("\u6b64\u7535\u8111");
    static final File RECENT = new File("\u6700\u8fd1");
    private static final int MAX_RECENT = 10;
    private GhidraFileChooserModel fileChooserModel;
    private GhidraFileChooserMode fileSelectionMode = GhidraFileChooserMode.FILES_ONLY;
    private static boolean initialized;
    private static List<RecentGhidraFile> recentList;
    private HistoryList<HistoryEntry> history = new HistoryList(20, (files, previous) -> {
        this.updateHistoryWithSelectedFiles((HistoryEntry)previous);
        this.updateDirAndSelectFile(files.parentDir, files.getSelectedFile(), false, false);
        this.updateNavigationButtons();
    });
    private File initialFile = null;
    private File initialFileToSelect = null;
    private FileList selectedFiles = new FileList(this);
    private FileList validatedFiles = new FileList(this);
    private Component parent;
    private JPanel waitPanel;
    private JButton backButton;
    private JButton forwardButton;
    private JButton upButton;
    private JButton newFolderButton;
    private JButton refreshButton;
    private EmptyBorderToggleButton detailsButton;
    private DockingAction upAction;
    private DockingAction backAction;
    private DockingAction forwardAction;
    private KeyBindingChangeListener keyBindingChangeListener = new KeyBindingChangeListener();
    private JPanel shortcutPanel;
    private UnselectableButtonGroup shortCutButtonGroup;
    private FileChooserToggleButton myComputerButton;
    private FileChooserToggleButton desktopButton;
    private FileChooserToggleButton homeButton;
    private FileChooserToggleButton downloadsButton;
    private FileChooserToggleButton recentButton;
    private GFormattedTextField currentPathTextField;
    private DropDownSelectionTextField<File> filenameTextField;
    private DirectoryTableModel directoryTableModel;
    private DirectoryTable directoryTable;
    private DirectoryListModel directoryListModel;
    private DirectoryList directoryList;
    private GhidraFileChooserDirectoryModelIf directoryModel;
    private JScrollPane directoryScroll;
    private CardLayout card;
    private JPanel cardPanel;
    private DefaultComboBoxModel<GhidraFileFilter> filterModel;
    private JComboBox<GhidraFileFilter> filterCombo;
    private boolean showDetails = false;
    private boolean wasCancelled;
    private boolean multiSelectionEnabled;
    private FileChooserActionManager actionManager;
    private SwingUpdateManager modelUpdater = new SwingUpdateManager(this::updateDirectoryModels);
    private Component lastInputFocus;
    private Worker worker = Worker.createGuiWorker();
    private GFileChooserOptionsDialog optionsDialog = new GFileChooserOptionsDialog();
    private EmptyBorderButton optionsButton;
    private boolean showDotFiles;
    private SelectionListener<File> selectionListener;
    private String lastDirectoryPreferencKey;

    public GhidraFileChooser(Component parent) {
        this(null, parent);
    }

    GhidraFileChooser(GhidraFileChooserModel model, Component parent) {
        super(TITLE, true, true, true, false);
        this.parent = parent;
        this.setTransient(true);
        this.init(model);
        this.loadRecentList();
        this.loadOptions();
    }

    private void init(GhidraFileChooserModel newModel) {
        if (newModel == null) {
            newModel = new LocalFileChooserModel(() -> this);
        }
        this.fileChooserModel = newModel;
        this.history.setAllowDuplicates(true);
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.actionManager = new FileChooserActionManager(this);
        this.setFocusComponent(this.filenameTextField);
        this.setDefaultButton(null);
        this.setPreferredSize(800, 600);
        this.updateDirOnly(newModel.getHomeDirectory(), true);
        this.createActions();
    }

    private void createActions() {
        String owner = this.getClass().getSimpleName();
        this.upAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(ACTION_NAME_UP, owner).sharedKeyBinding()).keyBinding("Alt Up")).onAction(c -> this.goUp())).build();
        this.backAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(ACTION_NAME_BACK, owner).sharedKeyBinding()).keyBinding("Alt Left")).onAction(c -> this.goBack())).build();
        this.forwardAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(ACTION_NAME_FORWARD, owner).sharedKeyBinding()).keyBinding("Alt Right")).onAction(c -> this.goForward())).build();
        this.upAction.addPropertyChangeListener(this.keyBindingChangeListener);
        this.backAction.addPropertyChangeListener(this.keyBindingChangeListener);
        this.forwardAction.addPropertyChangeListener(this.keyBindingChangeListener);
        this.addAction(this.upAction);
        this.addAction(this.backAction);
        this.addAction(this.forwardAction);
        this.updateNavigationButtonToolTips();
    }

    public static void registerSharedActions(Tool tool, ToolActions toolActions) {
        toolActions.registerSharedActionPlaceholder(new GfcActionPlaceholder(ACTION_NAME_BACK, "Alt Left"));
        toolActions.registerSharedActionPlaceholder(new GfcActionPlaceholder(ACTION_NAME_FORWARD, "Alt Right"));
        toolActions.registerSharedActionPlaceholder(new GfcActionPlaceholder(ACTION_NAME_UP, "Alt Up"));
    }

    private JComponent buildWorkPanel() {
        this.buildWaitPanel();
        JPanel currentPathPanel = this.buildHeaderPanel();
        JPanel shortCutPanel = this.buildShortCutPanel();
        JScrollPane directoryTableScroll = this.buildDirectoryTable();
        JScrollPane directoryListScroll = this.buildDirectoryList();
        this.card = new CardLayout();
        this.cardPanel = new JPanel(this.card);
        this.cardPanel.setName("CARD_PANEL");
        this.cardPanel.getAccessibleContext().setAccessibleName("Card");
        this.cardPanel.add((Component)directoryTableScroll, CARD_TABLE);
        this.cardPanel.add((Component)directoryListScroll, CARD_LIST);
        this.cardPanel.add((Component)this.waitPanel, CARD_WAIT);
        this.card.show(this.cardPanel, CARD_LIST);
        this.directoryModel = this.directoryList;
        JPanel filenamePanel = this.buildFileNamePanel();
        JPanel directoryPanel = new JPanel(new BorderLayout(5, 5));
        directoryPanel.add((Component)this.cardPanel, "Center");
        directoryPanel.add((Component)filenamePanel, "South");
        directoryPanel.getAccessibleContext().setAccessibleName("Directory");
        JPanel main = new JPanel(new BorderLayout(5, 5));
        main.add((Component)currentPathPanel, "North");
        main.add((Component)shortCutPanel, "West");
        main.add((Component)directoryPanel, "Center");
        main.getAccessibleContext().setAccessibleName("Ghidra \u6587\u4ef6\u9009\u62e9\u5668");
        return main;
    }

    private JPanel buildShortCutPanel() {
        this.myComputerButton = new FileChooserToggleButton("\u6b64\u7535\u8111", this){

            @Override
            File getFile() {
                return MY_COMPUTER;
            }
        };
        this.myComputerButton.setName("MY_COMPUTER_BUTTON");
        this.myComputerButton.getAccessibleContext().setAccessibleName("\u6b64\u7535\u8111");
        this.myComputerButton.setIcon(ICON_MY_COMPUTER);
        this.myComputerButton.addActionListener(e -> this.updateMyComputer());
        this.myComputerButton.setForeground(FOREROUND_COLOR);
        this.desktopButton = new FileChooserToggleButton("\u684c\u9762", this){

            @Override
            File getFile() {
                return GhidraFileChooser.this.fileChooserModel.getDesktopDirectory();
            }
        };
        this.desktopButton.setName("DESKTOP_BUTTON");
        this.desktopButton.getAccessibleContext().setAccessibleName("\u684c\u9762");
        this.desktopButton.setIcon(ICON_DESKTOP);
        this.desktopButton.addActionListener(e -> this.updateDesktop());
        this.desktopButton.setForeground(FOREROUND_COLOR);
        this.desktopButton.setEnabled(this.fileChooserModel.getDesktopDirectory() != null);
        this.homeButton = new FileChooserToggleButton("\u4e3b\u9875", this){

            @Override
            File getFile() {
                return GhidraFileChooser.this.fileChooserModel.getHomeDirectory();
            }
        };
        this.homeButton.setName("HOME_BUTTON");
        this.homeButton.getAccessibleContext().setAccessibleName("\u4e3b\u9875");
        this.homeButton.setIcon(ICON_HOME);
        this.homeButton.addActionListener(e -> this.updateHome());
        this.homeButton.setForeground(FOREROUND_COLOR);
        this.downloadsButton = new FileChooserToggleButton("\u4e0b\u8f7d", this){

            @Override
            File getFile() {
                return GhidraFileChooser.this.fileChooserModel.getDownloadsDirectory();
            }
        };
        this.downloadsButton.setName("DOWNLOADS_BUTTON");
        this.downloadsButton.setIcon(ICON_DOWNLOADS);
        this.downloadsButton.addActionListener(e -> this.updateDownloads());
        this.downloadsButton.setForeground(FOREROUND_COLOR);
        this.recentButton = new FileChooserToggleButton("\u6700\u8fd1", this){

            @Override
            File getFile() {
                return RECENT;
            }
        };
        this.recentButton.setName("RECENT_BUTTON");
        this.recentButton.getAccessibleContext().setAccessibleName("\u6700\u8fd1");
        this.recentButton.setIcon(ICON_RECENT);
        this.recentButton.addActionListener(e -> this.updateRecent());
        this.recentButton.setForeground(FOREROUND_COLOR);
        this.shortCutButtonGroup = new UnselectableButtonGroup();
        this.shortCutButtonGroup.add(this.myComputerButton);
        this.shortCutButtonGroup.add(this.desktopButton);
        this.shortCutButtonGroup.add(this.homeButton);
        this.shortCutButtonGroup.add(this.downloadsButton);
        this.shortCutButtonGroup.add(this.recentButton);
        this.shortcutPanel = new JPanel(new GridLayout(0, 1));
        this.shortcutPanel.getAccessibleContext().setAccessibleName("\u5feb\u6377\u65b9\u5f0f");
        DockingUtils.setTransparent(this.shortcutPanel);
        this.shortcutPanel.add(this.myComputerButton);
        this.shortcutPanel.add(this.desktopButton);
        this.shortcutPanel.add(this.homeButton);
        this.shortcutPanel.add(this.downloadsButton);
        this.shortcutPanel.add(this.recentButton);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.setBackground(SHORTCUT_BACKGROUND_COLOR);
        panel.add((Component)this.shortcutPanel, "North");
        panel.getAccessibleContext().setAccessibleName("\u5feb\u6377\u65b9\u5f0f");
        return panel;
    }

    private JPanel buildFileNamePanel() {
        GDLabel filenameLabel = new GDLabel("\u6587\u4ef6\u540d\uff1a");
        FileDropDownSelectionDataModel model = new FileDropDownSelectionDataModel(this);
        this.filenameTextField = new DropDownSelectionTextField<File>(model);
        filenameLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.setMatchingWindowHeight(200);
        this.filenameTextField.getAccessibleContext().setAccessibleName("Filename");
        this.filenameTextField.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                GhidraFileChooser.this.enterCallback();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                GhidraFileChooser.this.escapeCallback();
            }
        });
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GhidraFileChooser.this.lastInputFocus = GhidraFileChooser.this.filenameTextField;
            }
        });
        this.selectionListener = new SelectionListener();
        this.filenameTextField.addDropDownSelectionChoiceListener(this.selectionListener);
        this.filenameTextField.setConsumeEnterKeyPress(false);
        this.filenameTextField.setName("filenameTextField");
        GLabel filterLabel = new GLabel("\u7c7b\u578b\uff1a");
        filterLabel.getAccessibleContext().setAccessibleName("\u7b5b\u9009");
        this.filterCombo = new GComboBox<GhidraFileFilter>();
        filterLabel.setLabelFor(this.filterCombo);
        this.filterCombo.setRenderer(GListCellRenderer.createDefaultTextRenderer(fileFilter -> fileFilter != null ? fileFilter.getDescription() : ""));
        this.filterCombo.getAccessibleContext().setAccessibleName("\u7b5b\u9009");
        this.filterModel = (DefaultComboBoxModel)this.filterCombo.getModel();
        this.addFileFilter(GhidraFileFilter.ALL);
        this.filterCombo.addItemListener(e -> this.rescanCurrentDirectory());
        JPanel filenamePanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        filenamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        filenamePanel.add(filenameLabel);
        filenamePanel.add(this.filenameTextField);
        filenamePanel.add(filterLabel);
        filenamePanel.add(this.filterCombo);
        filenamePanel.getAccessibleContext().setAccessibleName("Filename");
        return filenamePanel;
    }

    private JPanel buildHeaderPanel() {
        JButton[] buttons;
        JButton[] navButtons;
        JPanel headerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        for (JButton element : navButtons = this.buildNavigationButtons()) {
            headerPanel.add((Component)element, gbc);
            ++gbc.gridx;
        }
        gbc.insets = new Insets(5, 5, 5, 5);
        int afterPathLabel = gbc.gridx++;
        ++gbc.gridx;
        gbc.insets = new Insets(5, 0, 5, 5);
        for (JButton element : buttons = this.buildNonNavigationButtons()) {
            headerPanel.add((Component)element, gbc);
            ++gbc.gridx;
        }
        gbc.gridx = afterPathLabel;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.currentPathTextField = this.buildPathTextField();
        this.currentPathTextField.getAccessibleContext().setAccessibleName("Path");
        headerPanel.add((Component)this.currentPathTextField, gbc);
        headerPanel.getAccessibleContext().setAccessibleName("Path Navigation");
        return headerPanel;
    }

    private GFormattedTextField buildPathTextField() {
        DefaultFormatter formatter = new DefaultFormatter();
        formatter.setOverwriteMode(false);
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
        final GFormattedTextField textField = new GFormattedTextField(factory, ""){

            @Override
            public void setText(String t) {
                super.setText(t);
                this.setDefaultValue(t);
            }
        };
        textField.setName("Path");
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GhidraFileChooser.this.lastInputFocus = textField;
            }
        });
        DockingUtils.installUndoRedo(textField);
        KeyStroke escapeKs = KeyBindingUtils.parseKeyStroke("Escape");
        AbstractAction escapeAction = new AbstractAction("\u91cd\u8bbe\u8def\u5f84"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (textField.isChanged()) {
                    textField.reset();
                } else {
                    GhidraFileChooser.this.escapeCallback();
                }
            }
        };
        KeyBindingUtils.clearKeyBinding((JComponent)textField, escapeKs);
        KeyBindingUtils.registerAction((JComponent)textField, escapeKs, escapeAction, 0);
        KeyStroke enterKs = KeyBindingUtils.parseKeyStroke("Enter");
        AbstractAction enterAction = new AbstractAction("\u9009\u62e9\u6587\u4ef6"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!textField.isChanged()) {
                    GhidraFileChooser.this.enterCallback();
                    return;
                }
                if (!textField.isValid()) {
                    return;
                }
                String text = textField.getText();
                File f = new File(text);
                if (f.isFile()) {
                    GhidraFileChooser.this.setSelectedFile(f);
                } else {
                    GhidraFileChooser.this.updateDirOnly(f, true);
                }
            }
        };
        KeyBindingUtils.clearKeyBinding((JComponent)textField, enterKs);
        KeyBindingUtils.registerAction((JComponent)textField, enterKs, enterAction, 0);
        InputVerifier inputVerifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = textField.getText();
                File f = new File(text);
                if (GhidraFileChooser.this.isSpecialDirectory(f)) {
                    return true;
                }
                return f.isFile() || f.isDirectory();
            }
        };
        textField.setInputVerifier(inputVerifier);
        return textField;
    }

    private void buildWaitPanel() {
        this.waitPanel = new JPanel(new BorderLayout());
        this.waitPanel.getAccessibleContext().setAccessibleName("Wait");
        this.waitPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.waitPanel.setBackground(BACKGROUND_COLOR);
        this.waitPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                GhidraFileChooser.this.waitPanel.setCursor(WAIT_CURSOR);
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GhidraFileChooser.this.waitPanel.setCursor(DEFAULT_CURSOR);
            }
        });
        this.waitPanel.addMouseMotionListener(new MouseMotionAdapter(this){});
        this.waitPanel.addKeyListener(new KeyAdapter(this){});
    }

    private JButton[] buildNavigationButtons() {
        this.backButton = new EmptyBorderButton(ICON_BACK);
        this.backButton.setName("BACK_BUTTON");
        this.backButton.setEnabled(false);
        this.backButton.setToolTipText("Go to last folder visited");
        this.backButton.addActionListener(e -> this.goBack());
        this.forwardButton = new EmptyBorderButton(ICON_FORWARD);
        this.forwardButton.setName("FORWARD_BUTTON");
        this.forwardButton.setEnabled(false);
        this.forwardButton.setToolTipText("Go to previous folder visited");
        this.forwardButton.addActionListener(e -> this.goForward());
        this.upButton = new EmptyBorderButton(ICON_UP);
        this.upButton.setName(UP_BUTTON_NAME);
        this.upButton.setEnabled(false);
        this.upButton.setToolTipText("Up one level");
        this.upButton.addActionListener(e -> this.goUp());
        return new JButton[]{this.backButton, this.forwardButton, this.upButton};
    }

    private JButton[] buildNonNavigationButtons() {
        this.newFolderButton = new EmptyBorderButton(ICON_NEW_FOLDER);
        this.newFolderButton.setName("NEW_BUTTON");
        this.newFolderButton.getAccessibleContext().setAccessibleName("\u65b0\u5efa\u6587\u4ef6\u5939");
        this.newFolderButton.setToolTipText("\u65b0\u5efa\u6587\u4ef6\u5939");
        this.newFolderButton.addActionListener(e -> this.createNewFolder());
        this.refreshButton = new EmptyBorderButton(Icons.REFRESH_ICON);
        this.refreshButton.setName("REFRESH_BUTTON");
        this.refreshButton.getAccessibleContext().setAccessibleName("\u5237\u65b0");
        this.refreshButton.setToolTipText("Rescan current directory");
        this.refreshButton.addActionListener(e -> this.rescanCurrentDirectory());
        this.detailsButton = new EmptyBorderToggleButton(ICON_DETAILS);
        this.detailsButton.setName("DETAILS_BUTTON");
        this.detailsButton.getAccessibleContext().setAccessibleName("\u8be6\u7ec6");
        this.detailsButton.setToolTipText("\u663e\u793a\u8be6\u7ec6");
        this.detailsButton.addActionListener(e -> {
            this.cancelEdits();
            this.doSetShowDetails(!this.showDetails);
        });
        this.optionsButton = new EmptyBorderButton(ICON_OPTIONS);
        this.optionsButton.setName("OPTIONS_BUTTON");
        this.optionsButton.getAccessibleContext().setAccessibleName("\u9009\u9879");
        this.optionsButton.setToolTipText("\u6587\u4ef6\u9009\u62e9\u9009\u9879");
        this.optionsButton.addActionListener(e -> {
            DockingWindowManager.showDialog(this.parent, this.optionsDialog);
            this.loadOptions();
        });
        return new JButton[]{this.refreshButton, this.newFolderButton, this.detailsButton, this.optionsButton};
    }

    private void loadOptions() {
        this.showDotFiles = this.optionsDialog.getShowsDotFiles();
        this.rescanCurrentDirectory();
    }

    public void setShowDetails(boolean showDetails) {
        if (this.detailsButton.isSelected() != showDetails) {
            this.detailsButton.toggle();
        }
    }

    private void doSetShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
        this.updateDirectoryPresentationMode();
        this.rescanCurrentDirectory();
    }

    private JScrollPane buildDirectoryList() {
        this.directoryListModel = new DirectoryListModel();
        this.directoryList = new DirectoryList(this, this.directoryListModel);
        this.directoryList.setName(CARD_LIST);
        this.directoryList.getAccessibleContext().setAccessibleName("Directory");
        this.directoryList.setBackground(BACKGROUND_COLOR);
        this.directoryList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GhidraFileChooser.this.lastInputFocus = GhidraFileChooser.this.directoryList;
            }
        });
        this.directoryScroll = new JScrollPane(this.directoryList);
        this.directoryScroll.getViewport().setBackground(BACKGROUND_COLOR);
        this.directoryScroll.setVerticalScrollBarPolicy(21);
        this.directoryScroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension size = GhidraFileChooser.this.directoryScroll.getSize();
                int cellHeight = GhidraFileChooser.this.directoryList.getFixedCellHeight();
                int nRows = size.height / cellHeight;
                GhidraFileChooser.this.directoryList.setVisibleRowCount(nRows - 1);
            }
        });
        this.directoryScroll.getAccessibleContext().setAccessibleName("Directory");
        return this.directoryScroll;
    }

    private void updateDirectoryModels() {
        this.directoryListModel.update();
        this.directoryTableModel.update();
    }

    @Override
    public boolean accept(File file) {
        String name;
        if (!this.showDotFiles && (name = file.getName()).startsWith(DOT)) {
            return false;
        }
        switch (this.fileSelectionMode) {
            case DIRECTORIES_ONLY: {
                if (!file.isFile()) break;
                return false;
            }
        }
        GhidraFileFilter filter = (GhidraFileFilter)this.filterCombo.getSelectedItem();
        if (filter != null) {
            return filter.accept(file, this.fileChooserModel);
        }
        return false;
    }

    @Deprecated
    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = GhidraFileChooserMode.values()[mode];
    }

    public void setFileSelectionMode(GhidraFileChooserMode mode) {
        this.fileSelectionMode = Objects.requireNonNull(mode);
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelectionEnabled = b;
        if (b) {
            this.directoryList.setSelectionMode(2);
            this.directoryTable.setSelectionMode(2);
        } else {
            this.directoryList.setSelectionMode(0);
            this.directoryTable.setSelectionMode(0);
        }
    }

    public boolean hasBigData() {
        return this.directoryListModel.getSize() > 200;
    }

    public void setApproveButtonText(String buttonText) {
        this.setOkButtonText(buttonText);
    }

    public void setApproveButtonToolTipText(String tooltipText) {
        this.setOkToolTip(tooltipText);
    }

    private void updateMyComputer() {
        this.updateMyComputer(false, true);
    }

    private void updateMyComputer(boolean forceUpdate, boolean addToHistory) {
        this.worker.schedule((Job)new UpdateMyComputerJob(this.myComputerButton.getFile(), forceUpdate, addToHistory));
    }

    private void updateDesktop() {
        File desktop = this.desktopButton.getFile();
        this.updateDirOnly(desktop, true);
    }

    private void updateHome() {
        File home = this.homeButton.getFile();
        this.updateDirOnly(home, true);
    }

    private void updateDownloads() {
        File downloads = this.downloadsButton.getFile();
        this.updateDirOnly(downloads, true);
    }

    void removeRecentFiles(List<RecentGhidraFile> toRemove) {
        recentList.removeAll(toRemove);
        this.saveRecentList();
        this.updateRecent();
    }

    private void updateRecent() {
        this.updateRecent(true);
    }

    private void updateRecent(boolean addToHistory) {
        this.worker.schedule((Job)new UpdateRecentJob(this.recentButton.getFile(), addToHistory));
    }

    private File currentDirectory() {
        String path = this.currentPathTextField.getDefaultText();
        if (path.length() == 0) {
            return null;
        }
        if (path.equals(RECENT.getName())) {
            return RECENT;
        }
        if (path.equals(MY_COMPUTER.getName())) {
            return MY_COMPUTER;
        }
        return new GhidraFile(path, this.fileChooserModel.getSeparator());
    }

    private void updateDirAndSelectFile(File directory, File fileToSelect, boolean forceUpdate, boolean addToHistory) {
        if (MY_COMPUTER.equals(directory)) {
            this.updateMyComputer(forceUpdate, addToHistory);
            this.setSelectedFileAndUpdateDisplay(fileToSelect);
            return;
        }
        if (RECENT.equals(directory)) {
            this.updateRecent(addToHistory);
            return;
        }
        if (directory == null) {
            if (this.isDirectory(fileToSelect)) {
                this.updateDirOnly(fileToSelect, forceUpdate, addToHistory);
            }
            return;
        }
        if (fileToSelect == null) {
            this.updateDirOnly(directory, forceUpdate, addToHistory);
            return;
        }
        this.worker.schedule((Job)new UpdateDirectoryContentsJob(directory, fileToSelect, addToHistory));
    }

    private void updateDirOnly(File directory, boolean force) {
        this.updateDirOnly(directory, force, true);
    }

    private void updateDirOnly(File directory, boolean force, boolean addToHistory) {
        if (!this.fileExists(directory)) {
            return;
        }
        if (!this.isDirectory(directory)) {
            throw new AssertException("Expected a directory and did not get one: " + String.valueOf(directory));
        }
        File currentDirectory = this.currentDirectory();
        if (force || !directory.equals(currentDirectory)) {
            this.worker.schedule((Job)new UpdateDirectoryContentsJob(directory, null, addToHistory));
        }
    }

    boolean pendingUpdate() {
        return this.worker.isBusy();
    }

    String getDisplayName(File file) {
        if (file == null) {
            return "";
        }
        if (this.isDisposed()) {
            return "";
        }
        if (MY_COMPUTER.equals(this.getCurrentDirectory())) {
            String str = this.getModel().getDescription(file);
            if (str == null || str.length() == 0) {
                str = file.getAbsolutePath();
            }
            return str;
        }
        if (RECENT.equals(this.getCurrentDirectory())) {
            return file.getAbsolutePath() + "  ";
        }
        return this.getFilename(file) + "  ";
    }

    private boolean isDisposed() {
        return this.fileChooserModel == null;
    }

    private void setDirectoryList(File directory, List<File> files) {
        if (this.currentDirectory().equals(directory)) {
            this.directoryTableModel.setFiles(files);
            this.directoryTable.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            this.directoryListModel.setFiles(files);
            this.directoryList.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
        this.updateShortcutPanel();
    }

    public void setLastDirectoryPreference(String newKey) {
        this.lastDirectoryPreferencKey = newKey;
        if (StringUtils.isBlank((CharSequence)newKey)) {
            return;
        }
        String path = Preferences.getProperty((String)newKey);
        if (path == null) {
            return;
        }
        File dir = new File(path);
        if (this.isDirectory(dir)) {
            this.updateDirOnly(dir, true);
        }
    }

    public File getSelectedFile() {
        this.show();
        if (this.wasCancelled) {
            return null;
        }
        return this.validatedFiles.getFile();
    }

    public List<File> getSelectedFiles() {
        this.show();
        if (this.wasCancelled) {
            return Collections.emptyList();
        }
        List<File> filteredList = this.filterFilesForSelectionMode(this.validatedFiles);
        return filteredList;
    }

    private String getSelectionRequiredMessage() {
        if (this.isFilesAndDirectories()) {
            return "Please make a selection";
        }
        if (this.isFilesOnly()) {
            return "Please select a file";
        }
        return "Please select a directory";
    }

    private List<File> filterFilesForSelectionMode(FileList list) {
        List<File> listCopy = list.getFiles().stream().filter(f -> f != null).collect(Collectors.toList());
        if (this.isFilesAndDirectories()) {
            return listCopy;
        }
        if (this.fileSelectionMode == GhidraFileChooserMode.DIRECTORIES_ONLY) {
            Iterator<File> iterator = listCopy.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (this.isDirectory(file)) continue;
                iterator.remove();
            }
        } else {
            Iterator<File> iterator = listCopy.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (!this.isDirectory(file)) continue;
                iterator.remove();
            }
        }
        return listCopy;
    }

    public File getSelectedFile(boolean show) {
        if (show) {
            return this.getSelectedFile();
        }
        if (this.isShowing()) {
            return this.selectedFiles.getFile();
        }
        return this.validatedFiles.getFile();
    }

    private GhidraFile getUserSelectedFileInDisplay() {
        File selectedFile = this.directoryModel.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        return new GhidraFile(selectedFile.getAbsolutePath(), this.fileChooserModel.getSeparator());
    }

    private boolean isSpecialDirectory(File directory) {
        return directory.equals(MY_COMPUTER) || directory.equals(RECENT);
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.worker.schedule((Job)new ClearSelectedFilesJob());
            return;
        }
        File parentDirectory = file.getParentFile();
        if (!file.exists() && !this.fileExists(parentDirectory)) {
            this.worker.schedule((Job)new ClearSelectedFilesJob());
            return;
        }
        this.selectedFiles.setFile(file);
        this.updateDirAndSelectFile(this.validateParentDirectory(file), file, true, true);
    }

    private void setFilenameFieldText(String filename, boolean selectText) {
        String newFilename = filename;
        if (newFilename == null) {
            newFilename = "";
        }
        this.filenameTextField.setText(newFilename);
        if (selectText) {
            this.filenameTextField.selectAll();
        }
    }

    public void show() {
        this.validatedFiles.setFile(null);
        this.initialFileToSelect = this.initialFile = this.selectedFiles.getFile();
        SystemUtilities.runSwingLater(() -> {
            File selectedFile = this.selectedFiles.getFile();
            if (!this.fileExists(selectedFile)) {
                this.rescanCurrentDirectory();
            } else {
                this.updateDirAndSelectFile(selectedFile.getParentFile(), selectedFile, true, true);
            }
        });
        this.restorePreferences();
        DockingWindowManager.showDialog(this.parent, this);
        this.cancelEdits();
    }

    @Override
    public void close() {
        this.closeCleanup();
        super.close();
    }

    private void closeCleanup() {
        this.clearBackHistory();
        this.cancelEdits();
        this.clearStatusText();
        this.savePreferences();
    }

    private void savePreferences() {
        this.saveSize();
        this.saveViewStyle();
        this.saveLastDirectory();
        Preferences.store();
    }

    private void restorePreferences() {
        this.restoreSize();
        this.restoreViewStyle();
    }

    private void saveSize() {
        String titleKey = this.getTitle();
        Dimension size = this.getDialogSize();
        if (size == null) {
            return;
        }
        Preferences.setProperty((String)(WIDTH_PREFERENCE_PREFIX + titleKey), (String)Integer.toString(size.width));
        Preferences.setProperty((String)(HEIGHT_PREFERENCE_PREFIX + titleKey), (String)Integer.toString(size.height));
    }

    private void saveViewStyle() {
        String titleKey = this.getTitle();
        String detailsString = this.showDetails ? DETAILS_VIEW_STYLE : SIMPLE_VIEW_STYLE;
        Preferences.setProperty((String)(VIEW_STYLE_PREFIX + titleKey), (String)detailsString);
    }

    private void saveLastDirectory() {
        if (this.lastDirectoryPreferencKey == null) {
            return;
        }
        File file = this.validatedFiles.getFile();
        if (file == null) {
            return;
        }
        File dir = file.getParentFile();
        if (dir == null) {
            return;
        }
        Preferences.setProperty((String)this.lastDirectoryPreferencKey, (String)dir.getPath());
    }

    private void restoreSize() {
        String titleKey = this.getTitle();
        String savedWidth = Preferences.getProperty((String)(WIDTH_PREFERENCE_PREFIX + titleKey));
        String savedHeight = Preferences.getProperty((String)(HEIGHT_PREFERENCE_PREFIX + titleKey));
        if (savedWidth == null || savedHeight == null) {
            return;
        }
        try {
            int width = Integer.parseInt(savedWidth);
            int height = Integer.parseInt(savedHeight);
            this.setDefaultSize(width, height);
        }
        catch (NumberFormatException nfe) {
            Msg.debug((Object)this, (Object)("Unexpected error parsing as an Integer the saved size values: " + savedWidth + " and " + savedHeight));
        }
    }

    private void restoreViewStyle() {
        String titleKey = this.getTitle();
        String viewStyle = Preferences.getProperty((String)(VIEW_STYLE_PREFIX + titleKey));
        if (viewStyle != null) {
            this.setShowDetails(viewStyle.equals(DETAILS_VIEW_STYLE));
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory();
    }

    public void setCurrentDirectory(File directory) {
        if (directory == null) {
            directory = new GhidraFile(System.getProperty("user.home"), this.fileChooserModel.getSeparator());
        }
        while (!this.isDirectory(directory) && directory != null) {
            directory = directory.getParentFile();
        }
        this.updateDirOnly(directory, false);
    }

    private void setCurrentDirectoryDisplay(File directory, boolean addToHistory) {
        if (directory == null) {
            return;
        }
        this.cancelEdits();
        Swing.runNow(() -> {
            this.updateHistory(directory, addToHistory);
            if (directory.equals(MY_COMPUTER) || directory.equals(RECENT)) {
                this.currentPathTextField.setText(this.getFilename(directory));
            } else {
                this.currentPathTextField.setText(directory.getAbsolutePath());
            }
            this.currentPathTextField.setToolTipText(this.currentPathTextField.getText());
            this.updateNavigationButtons();
        });
    }

    void rootInfoUpdated() {
        this.modelUpdater.update();
    }

    GhidraFileChooserModel getModel() {
        return this.fileChooserModel;
    }

    GhidraFileChooserDirectoryModelIf getDirectoryModel() {
        return this.directoryModel;
    }

    FileChooserActionManager getActionManager() {
        return this.actionManager;
    }

    void setSelectedFileAndUpdateDisplay(File file) {
        this.worker.schedule((Job)new SetSelectedFileJob(file));
    }

    private void doSetSelectedFileAndUpdateDisplay(File file) {
        Component toFocus = this.getRestoreFocusComponent();
        if (toFocus != null) {
            toFocus.requestFocusInWindow();
        }
        if (file == null) {
            return;
        }
        this.cancelEdits();
        this.selectedFiles.setFile(file);
        this.updateTextFieldForFile(file);
        this.directoryModel.setSelectedFile(file);
    }

    private Component getRestoreFocusComponent() {
        if (this.isTableShowing()) {
            if (this.lastInputFocus == this.directoryList) {
                this.lastInputFocus = this.directoryTable;
            }
        } else if (this.lastInputFocus == this.directoryTable) {
            this.lastInputFocus = this.directoryList;
        }
        return this.lastInputFocus;
    }

    private void updateTextFieldForFile(File file) {
        File parentFile;
        String currentText;
        if (file == null) {
            return;
        }
        boolean selectText = false;
        if (this.initialFileToSelect != null) {
            selectText = file.equals(this.initialFileToSelect);
            this.initialFileToSelect = null;
        }
        if (this.isUserEditing()) {
            return;
        }
        String newText = this.getFilename(file);
        if (newText.equals(currentText = this.filenameTextField.getText())) {
            return;
        }
        if (!file.exists()) {
            this.setFilenameFieldText(newText, selectText);
            return;
        }
        if (!this.isDirectory(file)) {
            if (this.fileSelectionMode.supportsFiles()) {
                this.setFilenameFieldText(newText, selectText);
            }
        } else if (this.fileSelectionMode.supportsDirectories() && ((parentFile = file.getParentFile()) == null || parentFile.equals(this.currentDirectory()))) {
            this.setFilenameFieldText(newText, selectText);
        }
    }

    private boolean isUserEditing() {
        return this.filenameTextField.isMatchingListShowing();
    }

    private void goUp() {
        this.cancelEdits();
        if (this.currentDirectory() == null) {
            return;
        }
        File parentFile = this.currentDirectory().getParentFile();
        if (parentFile == null) {
            return;
        }
        this.updateDirOnly(parentFile, false);
    }

    private void createNewFolder() {
        this.cancelEdits();
        boolean created = false;
        Object newFolderName = NEW_FOLDER;
        if (this.fileChooserModel.createDirectory(this.currentDirectory(), (String)newFolderName)) {
            created = true;
        } else {
            for (int i = 2; i < 100; ++i) {
                newFolderName = "New Folder (" + i + ")";
                if (!this.fileChooserModel.createDirectory(this.currentDirectory(), (String)newFolderName)) continue;
                created = true;
                break;
            }
        }
        if (!created) {
            Msg.showError((Object)this, (Component)this.rootPanel, (String)"Create Folder Failed", (Object)("Unable to create new folder in " + String.valueOf(this.currentDirectory())));
            return;
        }
        GhidraFile folder = new GhidraFile(this.currentDirectory(), (String)newFolderName, this.fileChooserModel.getSeparator());
        this.directoryTableModel.insert(folder);
        this.directoryListModel.insert(folder);
        this.worker.schedule((Job)new SetSelectedFilesAndStartEditJob(folder));
    }

    public void rescanCurrentDirectory() {
        String name;
        this.cancelEdits();
        File currentDir = this.getCurrentDirectory();
        File currentSelectedFile = this.getSelectedFile(false);
        if (currentSelectedFile != null && !(name = this.getFilename(currentSelectedFile)).equals(this.filenameTextField.getText())) {
            currentSelectedFile = null;
        }
        if (currentDir != null && currentDir.equals(currentSelectedFile)) {
            currentSelectedFile = null;
        }
        this.updateDirAndSelectFile(currentDir, currentSelectedFile, true, false);
    }

    void updateShortcutPanel() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null && !SwingUtilities.isDescendingFrom(focusOwner, this.shortcutPanel)) {
            return;
        }
        File currentDirectory = this.currentDirectory();
        this.checkShortCutButton(this.myComputerButton, currentDirectory);
        this.checkShortCutButton(this.homeButton, currentDirectory);
        this.checkShortCutButton(this.recentButton, currentDirectory);
        this.checkShortCutButton(this.desktopButton, currentDirectory);
        this.checkShortCutButton(this.downloadsButton, currentDirectory);
    }

    private void checkShortCutButton(FileChooserToggleButton button, File currentDirectory) {
        boolean dirsMatch = currentDirectory.equals(button.getFile());
        if (button.isSelected() != dirsMatch) {
            this.shortCutButtonGroup.setSelected(button.getModel(), dirsMatch);
        }
    }

    private void setWaitPanelVisible(boolean visible) {
        Swing.runLater(() -> {
            if (visible) {
                this.card.show(this.cardPanel, CARD_WAIT);
            } else {
                this.updateDirectoryPresentationMode();
            }
        });
    }

    private void clearBackHistory() {
        this.history.clear();
    }

    private void updateNavigationButtonToolTips() {
        String tip = DockingToolBarUtils.createToolTipText(this.backButton, this.backAction);
        this.backButton.setToolTipText(tip);
        tip = DockingToolBarUtils.createToolTipText(this.forwardButton, this.forwardAction);
        this.forwardButton.setToolTipText(tip);
        tip = DockingToolBarUtils.createToolTipText(this.upButton, this.upAction);
        this.upButton.setToolTipText(tip);
    }

    private void updateNavigationButtons() {
        this.backButton.setEnabled(this.history.hasPrevious());
        this.forwardButton.setEnabled(this.history.hasNext());
        File dir = this.currentDirectory();
        boolean enable = dir != null && dir.getParentFile() != null;
        this.upButton.setEnabled(enable);
    }

    private void updateHistoryWithSelectedFiles(HistoryEntry historyEntry) {
        File currentDir = this.currentDirectory();
        File selectedFile = this.selectedFiles.getFile();
        historyEntry.setSelectedFile(currentDir, selectedFile);
    }

    private void updateHistory(File dir, boolean addToHistory) {
        if (!this.directoryExistsOrIsLogicalDirectory(dir)) {
            return;
        }
        HistoryEntry historyEntry = (HistoryEntry)this.history.getCurrentHistoryItem();
        if (historyEntry != null) {
            this.updateHistoryWithSelectedFiles(historyEntry);
            if (historyEntry.isSameDir(dir)) {
                return;
            }
        }
        if (addToHistory) {
            this.history.add((Object)new HistoryEntry(this, dir, null));
            this.updateNavigationButtons();
        }
    }

    int getHistorySize() {
        return this.history.size();
    }

    private boolean directoryExistsOrIsLogicalDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        return directory.exists() || directory.equals(MY_COMPUTER) || directory.equals(RECENT);
    }

    private boolean fileExists(File directory) {
        return directory != null && directory.exists();
    }

    private boolean isDirectory(File directory) {
        return this.fileChooserModel.isDirectory(directory) || MY_COMPUTER.equals(directory);
    }

    private void goBack() {
        this.history.goBack();
        this.updateNavigationButtons();
    }

    private void goForward() {
        this.history.goForward();
        this.updateNavigationButtons();
    }

    private void updateDirectoryPresentationMode() {
        if (this.isTableShowing()) {
            this.directoryModel = this.directoryTable;
            this.card.show(this.cardPanel, CARD_TABLE);
            int[] rows = this.directoryTable.getSelectedRows();
            this.directoryTableModel.fireTableDataChanged();
            this.directoryTable.clearSelection();
            for (int element : rows) {
                this.directoryTable.addRowSelectionInterval(element, element);
            }
        } else {
            this.directoryModel = this.directoryList;
            this.card.show(this.cardPanel, CARD_LIST);
        }
    }

    private void clearUserSelection() {
        this.directoryTable.clearSelection();
        this.directoryList.clearSelection();
        this.filenameTextField.setText("");
    }

    private void cancelEdits() {
        this.directoryTable.editingCanceled(null);
        this.directoryList.cancelListEdit();
    }

    private JScrollPane buildDirectoryTable() {
        this.directoryTableModel = new DirectoryTableModel(this);
        this.directoryTable = new DirectoryTable(this, this.directoryTableModel);
        this.directoryTable.setName(CARD_TABLE);
        this.directoryTable.getAccessibleContext().setAccessibleName("Directory");
        this.directoryTable.setBackground(BACKGROUND_COLOR);
        this.directoryTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GhidraFileChooser.this.lastInputFocus = GhidraFileChooser.this.directoryTable;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.directoryTable);
        scrollPane.getViewport().setBackground(BACKGROUND_COLOR);
        scrollPane.getAccessibleContext().setAccessibleName("Directory");
        return scrollPane;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.closeCleanup();
        this.modelUpdater.dispose();
        this.actionManager.dispose();
        this.optionsDialog.dispose();
        this.worker.dispose();
        this.fileChooserModel = null;
    }

    public void addFileFilter(GhidraFileFilter f) {
        boolean exists = false;
        int nFilters = this.filterModel.getSize();
        for (int i = 0; i < nFilters; ++i) {
            GhidraFileFilter filter = this.filterModel.getElementAt(i);
            if (!filter.getDescription().equals(f.getDescription())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.filterCombo.addItem(f);
            this.filterCombo.setSelectedItem(f);
        }
    }

    public void setSelectedFileFilter(GhidraFileFilter filter) {
        this.filterCombo.setSelectedItem(filter);
    }

    public void setFileFilter(GhidraFileFilter filter) {
        ItemListener[] listeners;
        for (ItemListener listener : listeners = this.filterCombo.getItemListeners()) {
            this.filterCombo.removeItemListener(listener);
        }
        this.filterCombo.removeAllItems();
        this.addFileFilter(GhidraFileFilter.ALL);
        if (filter != GhidraFileFilter.ALL) {
            this.addFileFilter(filter);
        }
        for (ItemListener listener : listeners) {
            this.filterCombo.addItemListener(listener);
        }
        this.filterCombo.setSelectedItem(filter);
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    @Override
    protected void cancelCallback() {
        if (!this.isShowing()) {
            return;
        }
        this.setSelectedFile(this.initialFile);
        this.wasCancelled = true;
        super.cancelCallback();
    }

    private void enterCallback() {
        this.okCallback();
    }

    @Override
    protected void okCallback() {
        if (this.isMultiSelectionEnabled()) {
            this.okCallbackForMultipleSelectionMode();
        } else {
            this.okCallbackForSingleSelectionMode();
        }
    }

    private void okCallbackForSingleSelectionMode() {
        if (DOTDOT.equals(this.filenameTextField.getText())) {
            this.updateDirOnly(this.currentDirectory().getParentFile(), false);
            this.clearUserSelection();
            return;
        }
        if (DOT.equals(this.filenameTextField.getText())) {
            this.clearUserSelection();
            return;
        }
        File selectedFile = this.directoryModel.getSelectedFile();
        if (this.isFilesOnly() && this.isDirectory(selectedFile)) {
            this.setCurrentDirectory(selectedFile);
            return;
        }
        File newSelectedFile = this.getUnvalidatedUserSelectedFile();
        if (newSelectedFile == null && (newSelectedFile = this.getUnvalidatedDirectory()) == null) {
            return;
        }
        if ((newSelectedFile = this.fileChooserModel.isAbsolute(newSelectedFile) ? this.validateAbsoluteFile(newSelectedFile) : this.validateRelativeFile(newSelectedFile)) == null) {
            return;
        }
        if (this.isFilesOnly() && this.isDirectory(newSelectedFile)) {
            this.setCurrentDirectory(newSelectedFile);
            return;
        }
        this.doChooseFile(newSelectedFile);
    }

    private boolean isFilesOnly() {
        return this.fileSelectionMode == GhidraFileChooserMode.FILES_ONLY;
    }

    private boolean isDirectoriesOnly() {
        return this.fileSelectionMode == GhidraFileChooserMode.DIRECTORIES_ONLY;
    }

    private boolean isFilesAndDirectories() {
        return this.fileSelectionMode == GhidraFileChooserMode.FILES_AND_DIRECTORIES;
    }

    private void okCallbackForMultipleSelectionMode() {
        if (this.selectedFiles.size() <= 1) {
            this.okCallbackForSingleSelectionMode();
            return;
        }
        if (this.selectedFiles.getFile() == null) {
            this.setStatusText(this.getSelectionRequiredMessage());
            return;
        }
        List<File> filteredList = this.filterFilesForSelectionMode(this.selectedFiles);
        if (filteredList.isEmpty()) {
            this.setStatusText(this.getSelectionRequiredMessage());
            return;
        }
        this.doChooseFiles(this.selectedFiles.getFiles());
    }

    private void doChooseFile(File validFile) {
        this.validatedFiles.setFile(validFile);
        this.wasCancelled = false;
        this.close();
        this.updateRecentList();
        this.clearUserSelection();
    }

    private void doChooseFiles(List<File> files) {
        this.validatedFiles.setFiles(files);
        this.wasCancelled = false;
        this.close();
        this.updateRecentList();
        this.clearUserSelection();
    }

    void userChoseFile(File file) {
        this.doChooseFile(file);
    }

    void userSelectedFiles(List<File> files) {
        this.selectedFiles.setFiles(files);
        if (this.isMultiSelectionEnabled() && this.selectedFiles.size() > 1) {
            this.filenameTextField.setText("");
        } else {
            this.updateTextFieldForFile(this.selectedFiles.getFile());
        }
    }

    private File getUnvalidatedDirectory() {
        if (!this.isDirectoriesOnly()) {
            this.setStatusText("Please select a file");
            return null;
        }
        return this.currentDirectory();
    }

    private File getUnvalidatedUserSelectedFile() {
        String filenameFieldText = this.filenameTextField.getText();
        if (filenameFieldText != null && filenameFieldText.trim().length() != 0) {
            GhidraFile testFile = new GhidraFile(this.filenameTextField.getText(), this.fileChooserModel.getSeparator());
            File currentDirectory = this.currentDirectory();
            if (this.isSpecialDirectory(currentDirectory)) {
                this.setStatusText("Cannot create a file in " + String.valueOf(currentDirectory));
                return null;
            }
            FileSystemView fsv = FileSystemView.getFileSystemView();
            if (fsv.isComputerNode(testFile)) {
                this.setStatusText("Please specify the name of a valid share.");
                return null;
            }
            return testFile;
        }
        GhidraFile userSelectedFile = this.getUserSelectedFileInDisplay();
        if (userSelectedFile == null) {
            this.setStatusText("Please select a file.");
            return null;
        }
        return userSelectedFile;
    }

    private File validateAbsoluteFile(File file) {
        File currentDirectory = this.currentDirectory();
        File parentFile = file.getParentFile();
        if (this.isDirectory(file)) {
            if (this.isSpecialCurrentDirectorySelection(file)) {
                return file;
            }
            String currentText = this.filenameTextField.getText();
            if (currentText != null && !currentText.isEmpty()) {
                this.setCurrentDirectory(file);
                this.clearUserSelection();
                return null;
            }
        } else if (parentFile != null && !parentFile.equals(currentDirectory)) {
            this.updateDirOnly(parentFile, false);
            this.clearUserSelection();
        }
        return file;
    }

    private boolean isSpecialCurrentDirectorySelection(File file) {
        if (!this.isDirectoriesOnly()) {
            return false;
        }
        File currentDirectory = this.currentDirectory();
        String text = this.filenameTextField.getText();
        boolean noUserText = text == null || text.isEmpty();
        return file.equals(currentDirectory) && noUserText;
    }

    private File validateRelativeFile(File file) {
        GhidraFile testFileFullPath;
        File currentDirectory = this.currentDirectory();
        File testFile = new GhidraFile(currentDirectory, file.getName(), this.fileChooserModel.getSeparator());
        if (!testFile.exists() && (testFileFullPath = new GhidraFile(currentDirectory, file.getPath(), this.fileChooserModel.getSeparator())).exists()) {
            testFile = testFileFullPath;
        }
        if (!testFile.exists() && testFile.getName().equals(currentDirectory.getName())) {
            testFile = currentDirectory;
        }
        if (this.isFilesOnly() && this.isDirectory(testFile)) {
            this.updateDirAndSelectFile(testFile, null, false, true);
            this.clearUserSelection();
            return null;
        }
        return testFile;
    }

    private File validateParentDirectory(File file) {
        File parentDirectory = file.getParentFile();
        if (this.isRootDirectory(file)) {
            parentDirectory = MY_COMPUTER;
        }
        return parentDirectory;
    }

    private boolean isRootDirectory(File file) {
        return this.isDirectory(file) && file.getParentFile() == null;
    }

    private String getFilename(File file) {
        if (this.isRootDirectory(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    private void loadRecentList() {
        if (!initialized) {
            List propNames = Preferences.getPropertyNames();
            Collections.sort(propNames);
            for (String element : propNames) {
                RecentGhidraFile file;
                String value;
                if (!element.startsWith("RECENT_") || (value = Preferences.getProperty((String)element, null, (boolean)true)) == null || !(file = new RecentGhidraFile(value, this.fileChooserModel.getSeparator())).exists() || recentList.contains(file)) continue;
                recentList.add(file);
            }
            initialized = true;
        }
    }

    private void updateRecentList() {
        File currentDirectory = this.currentDirectory();
        if (!currentDirectory.equals(RECENT) && !recentList.contains(currentDirectory)) {
            String path = currentDirectory.getAbsolutePath();
            recentList.add(0, new RecentGhidraFile(path, this.fileChooserModel.getSeparator()));
        }
        while (recentList.size() > 10) {
            recentList.remove(recentList.size() - 1);
        }
        this.saveRecentList();
    }

    private void saveRecentList() {
        for (int i = 0; i < recentList.size(); ++i) {
            File f = recentList.get(i);
            Preferences.setProperty((String)("RECENT_" + i), (String)f.getAbsolutePath());
        }
        Preferences.store();
    }

    private boolean isTableShowing() {
        return this.showDetails;
    }

    String getInvalidFilenameMessage(String filename) {
        switch (filename) {
            case ".": 
            case "..": {
                return "Reserved name '" + filename + "'";
            }
        }
        Matcher m = INVALID_FILENAME_PATTERN.matcher(filename);
        if (m.find()) {
            return "Invalid characters: " + m.group();
        }
        return null;
    }

    static {
        recentList = new ArrayList<RecentGhidraFile>();
    }

    private class FileList {
        private List<File> files = new ArrayList<File>();

        public FileList(GhidraFileChooser ghidraFileChooser) {
            this.files.add(null);
        }

        public synchronized int size() {
            return this.files.size();
        }

        public synchronized List<File> getFiles() {
            return new ArrayList<File>(this.files);
        }

        public synchronized void setFiles(List<File> newFiles) {
            this.files.clear();
            if (newFiles == null || newFiles.isEmpty()) {
                this.files.add(null);
            } else {
                this.files.addAll(newFiles);
            }
        }

        public synchronized void setFile(File file) {
            this.files.clear();
            this.files.add(file);
        }

        public synchronized File getFile() {
            return this.files.get(0);
        }

        public String toString() {
            return this.files.toString();
        }
    }

    private class KeyBindingChangeListener
    implements PropertyChangeListener {
        private KeyBindingChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("KeyBindings")) {
                GhidraFileChooser.this.updateNavigationButtonToolTips();
            }
        }
    }

    private static class GfcActionPlaceholder
    implements SharedDockingActionPlaceholder {
        private String name;
        private String keyBinding;

        GfcActionPlaceholder(String name, String keyBinding) {
            this.name = name;
            this.keyBinding = keyBinding;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public KeyStroke getKeyBinding() {
            return KeyBindingUtils.parseKeyStroke(this.keyBinding);
        }

        @Override
        public String getOwner() {
            return GhidraFileChooser.class.getSimpleName();
        }
    }

    private class UnselectableButtonGroup
    extends ButtonGroup {
        private ButtonModel overriddenSelection = null;

        private UnselectableButtonGroup() {
        }

        @Override
        public void add(AbstractButton b) {
            if (b == null) {
                return;
            }
            this.buttons.addElement(b);
            if (b.isSelected()) {
                if (this.overriddenSelection == null) {
                    this.overriddenSelection = b.getModel();
                } else {
                    b.setSelected(false);
                }
            }
            b.getModel().setGroup(this);
        }

        @Override
        public void remove(AbstractButton b) {
            if (b == null) {
                return;
            }
            this.buttons.removeElement(b);
            if (b.getModel() == this.overriddenSelection) {
                this.overriddenSelection = null;
            }
            b.getModel().setGroup(null);
        }

        @Override
        public ButtonModel getSelection() {
            return this.overriddenSelection;
        }

        @Override
        public void setSelected(ButtonModel m, boolean b) {
            if (!b && this.overriddenSelection != null) {
                this.overriddenSelection = null;
                m.setSelected(false);
            } else if (b && m != null && m != this.overriddenSelection) {
                ButtonModel oldSelection = this.overriddenSelection;
                this.overriddenSelection = m;
                if (oldSelection != null) {
                    oldSelection.setSelected(false);
                }
                m.setSelected(true);
            }
        }

        @Override
        public boolean isSelected(ButtonModel m) {
            return m == this.overriddenSelection;
        }
    }

    private class SelectionListener<T>
    implements DropDownSelectionChoiceListener<File> {
        private SelectionListener() {
        }

        @Override
        public void selectionChanged(File file) {
            GhidraFileChooser.this.worker.schedule((Job)new SetSelectedFileAndAcceptSelection(file));
        }
    }

    private class UpdateMyComputerJob
    extends FileChooserJob {
        private final File myComputerFile;
        private final boolean forceUpdate;
        private List<File> roots;

        public UpdateMyComputerJob(File myComputerFile, boolean forceUpdate, boolean addToHistory) {
            this.myComputerFile = myComputerFile;
            this.forceUpdate = forceUpdate;
            GhidraFileChooser.this.setCurrentDirectoryDisplay(myComputerFile, addToHistory);
            GhidraFileChooser.this.setWaitPanelVisible(true);
        }

        @Override
        public void run() {
            this.roots = new ArrayList<File>(GhidraFileChooser.this.fileChooserModel.getRoots(this.forceUpdate));
            Collections.sort(this.roots);
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.setDirectoryList(this.myComputerFile, this.roots);
            GhidraFileChooser.this.setWaitPanelVisible(false);
            GhidraFileChooser.this.setSelectedFileAndUpdateDisplay(null);
        }
    }

    private class UpdateRecentJob
    extends FileChooserJob {
        private final boolean addToHistory;
        private final File recentFile;

        UpdateRecentJob(File recentFile, boolean addToHistory) {
            this.recentFile = recentFile;
            this.addToHistory = addToHistory;
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.setCurrentDirectoryDisplay(this.recentFile, this.addToHistory);
            List list = CollectionUtils.asList(recentList, File.class);
            GhidraFileChooser.this.setDirectoryList(this.recentFile, list);
            GhidraFileChooser.this.setSelectedFileAndUpdateDisplay(null);
        }
    }

    private class UpdateDirectoryContentsJob
    extends FileChooserJob {
        private File directory;
        private File file;
        private List<File> loadedFiles;

        private UpdateDirectoryContentsJob(File directory, File selectedFile, boolean addToHistory) {
            this.directory = directory;
            this.file = selectedFile;
            GhidraFileChooser.this.setCurrentDirectoryDisplay(directory, addToHistory);
            GhidraFileChooser.this.setWaitPanelVisible(true);
        }

        @Override
        public void run() {
            this.loadedFiles = new ArrayList<File>(GhidraFileChooser.this.fileChooserModel.getListing(this.directory, (FileFilter)GhidraFileChooser.this));
            Collections.sort(this.loadedFiles, new FileComparator(GhidraFileChooser.this.fileChooserModel));
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.setDirectoryList(this.directory, this.loadedFiles);
            GhidraFileChooser.this.setWaitPanelVisible(false);
            GhidraFileChooser.this.setSelectedFileAndUpdateDisplay(this.file);
        }
    }

    private class ClearSelectedFilesJob
    extends FileChooserJob {
        private ClearSelectedFilesJob() {
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.clearUserSelection();
            GhidraFileChooser.this.selectedFiles.setFile(null);
            GhidraFileChooser.this.validatedFiles.setFile(null);
        }
    }

    private class SetSelectedFileJob
    extends FileChooserJob {
        private final File fileToSelect;

        SetSelectedFileJob(File file) {
            this.fileToSelect = file;
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.doSetSelectedFileAndUpdateDisplay(this.fileToSelect);
        }
    }

    private class SetSelectedFilesAndStartEditJob
    extends FileChooserJob {
        private final File fileToSelect;

        SetSelectedFilesAndStartEditJob(File file) {
            this.fileToSelect = file;
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.doSetSelectedFileAndUpdateDisplay(this.fileToSelect);
            GhidraFileChooser.this.directoryModel.edit();
        }
    }

    private class HistoryEntry {
        private File parentDir;
        private File selectedFile;

        HistoryEntry(GhidraFileChooser ghidraFileChooser, File parentDir, File selectedFile) {
            this.parentDir = parentDir;
            this.selectedFile = selectedFile;
        }

        boolean isSameDir(File dir) {
            return dir.equals(this.parentDir);
        }

        void setSelectedFile(File dir, File selectedFile) {
            if (!this.parentDir.equals(dir)) {
                return;
            }
            if (selectedFile == null) {
                return;
            }
            File selectedParent = selectedFile.getParentFile();
            if (this.parentDir.equals(selectedParent)) {
                this.selectedFile = selectedFile;
            }
        }

        File getSelectedFile() {
            return this.selectedFile;
        }

        public String toString() {
            Object selectedFilesText = "";
            if (this.selectedFile != null) {
                selectedFilesText = " *" + String.valueOf(this.selectedFile);
            }
            return this.parentDir.getName() + (String)selectedFilesText;
        }
    }

    private class SetSelectedFileAndAcceptSelection
    extends FileChooserJob {
        private final File fileToSelect;

        SetSelectedFileAndAcceptSelection(File file) {
            this.fileToSelect = file;
        }

        @Override
        public void runSwing() {
            GhidraFileChooser.this.doSetSelectedFileAndUpdateDisplay(this.fileToSelect);
        }
    }

    private abstract class FileChooserJob
    extends Job {
        private FileChooserJob() {
        }

        public void run(TaskMonitor monitor) {
            if (monitor.isCancelled() || GhidraFileChooser.this.worker.isDisposed()) {
                return;
            }
            this.run();
            Swing.runLater(() -> {
                if (!monitor.isCancelled() && !GhidraFileChooser.this.worker.isDisposed()) {
                    this.runSwing();
                }
            });
        }

        public void run() {
        }

        public void runSwing() {
        }
    }
}

