/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.registers.SarifRegisterValueWriter;
import sarif.managers.SarifMgr;

public class RegisterValuesSarifMgr
extends SarifMgr {
    public static String KEY = "REGISTER_VALUES";
    public static String SUBKEY = "Registers";
    private ProgramContext context;
    private Set<String> undefinedRegisterNames;

    RegisterValuesSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.context = program.getProgramContext();
        this.undefinedRegisterNames = new HashSet<String>();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        this.processRegisterValues(result);
        return true;
    }

    private List<Register> getUniqueRegisters() {
        ArrayList<Register> regs = new ArrayList<Register>(this.context.getRegisters());
        Collections.sort(regs, new Comparator<Register>(this){

            @Override
            public int compare(Register r1, Register r2) {
                int size2;
                int size1 = r1.getMinimumByteSize();
                if (size1 != (size2 = r2.getMinimumByteSize())) {
                    return size1 - size2;
                }
                return r1.getOffset() - r2.getOffset();
            }
        });
        return regs;
    }

    private void processRegisterValues(Map<String, Object> result) {
        try {
            AddressSet set = this.getLocations(result, null);
            Address addr = set.getMinAddress();
            int len = (int)set.getMaxAddress().subtract(addr) + 1;
            String regName = (String)result.get("name");
            String valueStr = (String)result.get("value");
            if (valueStr.startsWith("0x") || valueStr.startsWith("0X")) {
                valueStr = valueStr.substring(2);
            }
            BigInteger value = new BigInteger(valueStr, 16);
            Register reg = this.context.getRegister(regName);
            if (reg == null) {
                if (this.undefinedRegisterNames.add(regName)) {
                    this.log.appendMsg("REGISTER [" + regName + "] is not defined by " + String.valueOf(this.program.getLanguageID()) + ", register values will be ignored");
                }
                return;
            }
            this.context.setValue(reg, addr, addr.addNoWrap((long)(len - 1)), value);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        List<Register> regs = this.getUniqueRegisters();
        if (set == null) {
            set = this.program.getMemory();
        }
        ArrayList<AddressRange> request = new ArrayList<AddressRange>();
        AddressRangeIterator rangeIter = set.getAddressRanges();
        while (rangeIter.hasNext()) {
            monitor.checkCancelled();
            request.add((AddressRange)rangeIter.next());
        }
        RegisterValuesSarifMgr.writeAsSARIF(this.context, regs, request, results);
    }

    public static void writeAsSARIF(ProgramContext context, List<Register> registers, List<AddressRange> request, JsonArray results) throws IOException {
        SarifRegisterValueWriter writer = new SarifRegisterValueWriter(context, registers, request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

