/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import docking.widgets.OptionDialog;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.model.DomainFile;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;
import java.awt.Component;

public class VersionExceptionHandler {
    public static boolean isUpgradeOK(Component parent, DomainFile domainFile, String actionName, VersionException ve) {
        String contentType = domainFile.getContentType();
        if (ve.getVersionIndicator() != 1 || !ve.isUpgradable()) {
            VersionExceptionHandler.showVersionError(parent, domainFile.getName(), contentType, actionName, false, ve);
            return false;
        }
        boolean linkUsed = domainFile.isLink();
        if (linkUsed) {
            DomainFile file = LinkHandler.followInternalLinkage(domainFile, s -> {}, null);
            if (file.isLink() && file.getLinkInfo().isExternalLink()) {
                VersionExceptionHandler.showVersionError(null, domainFile.getName(), domainFile.getContentType(), actionName, true, ve);
                return false;
            }
            domainFile = file;
        }
        if (domainFile.isReadOnly() || !domainFile.isInWritableProject()) {
            VersionExceptionHandler.showVersionError(parent, domainFile.getName(), contentType, actionName, true, ve);
            return false;
        }
        String filename = domainFile.getName();
        if (domainFile.isVersioned() && !domainFile.isCheckedOutExclusive()) {
            VersionExceptionHandler.showNeedExclusiveCheckoutDialog(parent, filename, contentType, actionName);
            return false;
        }
        int userChoice = VersionExceptionHandler.showUpgradeDialog(parent, ve, filename, contentType, actionName);
        if (userChoice != 1) {
            return false;
        }
        return !domainFile.isCheckedOut() || (userChoice = VersionExceptionHandler.showWarningDialog(parent, filename, contentType, actionName)) == 1;
    }

    private static void showNeedExclusiveCheckoutDialog(Component parent, String filename, String contentType, String actionName) {
        Msg.showError(VersionExceptionHandler.class, (Component)parent, (String)(actionName + " \u5931\u8d25\uff01"), (Object)("\u65e0\u6cd5 " + actionName + " " + contentType + ": " + filename + "\n \nAn upgrade of the " + contentType + " data is required, however, you must have an exclusive checkout\nto upgrade a shared file!\n \nNOTE: If you are unable to obtain an exclusive checkout, you may be able to " + actionName + "\nthe file with an older version of Ghidra."));
    }

    private static int showUpgradeDialog(Component parent, VersionException ve, String filename, String contentType, String actionName) {
        String detailMessage = ve.getDetailMessage() == null ? "" : "\n" + ve.getDetailMessage();
        String title = "\u5347\u7ea7 " + contentType + " \u6570\u636e\uff1f" + filename;
        String message = "\u6b64 " + contentType + " \u6587\u4ef6\u66fe " + actionName + " \u4e8e\u65e7\u7248\u672c\u3002" + detailMessage + "\n \n\u60a8\u8981\u5347\u7ea7\u5b83\u5417\uff1f";
        return OptionDialog.showOptionDialog((Component)parent, (String)title, (String)message, (String)"\u5347\u7ea7", (int)3);
    }

    private static int showWarningDialog(Component parent, String filename, String contentType, String actionName) {
        String title = "\u5347\u7ea7\u5171\u4eab " + contentType + " \u6570\u636e\uff1f" + filename;
        String message = "\u6b64 " + contentType + " \u540c\u5176\u4ed6\u7528\u6237\u5171\u4eab\u3002\u5982\u679c\u60a8\u5347\u7ea7\u6b64\u6587\u4ef6\uff0c\n\u5176\u4ed6\u7528\u6237\u5728\u672a\u5347\u7ea7\u5230\u517c\u5bb9\u7248\u672c\u7684Ghidra\u4e4b\u524d\u5c06\u65e0\u6cd5\u8bfb\u53d6\u65b0\u7248\u672c\u3002\u60a8\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f";
        return OptionDialog.showOptionDialog((Component)parent, (String)title, (String)message, (String)"\u5347\u7ea7", (int)2);
    }

    public static void showVersionError(Component parent, String filename, String contentType, String actionName, boolean readOnly, VersionException ve) {
        int versionIndicator = ve.getVersionIndicator();
        String versionType = versionIndicator == 2 ? " newer" : (versionIndicator == 1 ? "n older" : "n unknown");
        String upgradeMsg = "";
        if (ve.isUpgradable()) {
            upgradeMsg = " (data upgrade is possible)";
        }
        Msg.showError(VersionExceptionHandler.class, (Component)parent, (String)(actionName + " Failed!"), (Object)("Unable to " + actionName + " " + (readOnly ? " read-only " : "") + contentType + ": " + filename + "\n \nFile was created with a" + versionType + " version of Ghidra" + upgradeMsg));
    }
}

