/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginToolAccessUtils;
import ghidra.framework.project.tool.ToolManagerImpl;
import ghidra.util.Swing;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jdom.Content;
import org.jdom.Element;

class WorkspaceImpl
implements Workspace {
    private String name;
    private ToolManagerImpl toolManager;
    private Set<PluginTool> runningTools = new CopyOnWriteArraySet<PluginTool>();
    private boolean isActive;

    WorkspaceImpl(String name, ToolManagerImpl toolManager) {
        this.name = name;
        this.toolManager = toolManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PluginTool[] getTools() {
        PluginTool[] tools = new PluginTool[this.runningTools.size()];
        this.runningTools.toArray(tools);
        return tools;
    }

    @Override
    public PluginTool createTool() {
        PluginTool emptyTool = this.toolManager.createEmptyTool();
        this.runningTools.add(emptyTool);
        emptyTool.setVisible(true);
        this.toolManager.setWorkspaceChanged(this);
        this.toolManager.fireToolAddedEvent(this, emptyTool);
        return emptyTool;
    }

    @Override
    public PluginTool runTool(ToolTemplate template) {
        return this.launchSwing("\u542f\u52a8\u5de5\u5177\u4e2d", () -> {
            PluginTool tool = this.toolManager.getTool(this, template);
            if (tool != null) {
                tool.setVisible(true);
                this.runningTools.add(tool);
                this.toolManager.setWorkspaceChanged(this);
                this.toolManager.fireToolAddedEvent(this, tool);
            }
            return tool;
        });
    }

    private <T> T launchSwing(String title, final Supplier<T> supplier) {
        final AtomicReference ref = new AtomicReference();
        Task t = new Task(this, title, false, false, true){

            public void run(TaskMonitor monitor) {
                ref.set(Swing.runNow((Supplier)supplier));
            }
        };
        int delay = 0;
        new TaskLauncher(t, null, delay);
        return (T)ref.get();
    }

    @Override
    public void setName(String newName) throws DuplicateNameException {
        this.toolManager.setWorkspaceName(this, newName);
        this.toolManager.setWorkspaceChanged(this);
        this.name = newName;
    }

    @Override
    public void setActive() {
        this.toolManager.setActiveWorkspace(this);
        this.setVisible(true);
    }

    public String toString() {
        return this.name;
    }

    public Element saveToXml() {
        Element root = new Element("WORKSPACE");
        root.setAttribute("NAME", this.name);
        root.setAttribute("ACTIVE", "" + this.isActive);
        for (PluginTool tool : this.runningTools) {
            Element elem = new Element("RUNNING_TOOL");
            elem.setAttribute("TOOL_NAME", tool.getToolName());
            elem.addContent((Content)tool.saveWindowingDataToXml());
            elem.addContent((Content)tool.saveDataStateToXml(true));
            root.addContent((Content)elem);
        }
        return root;
    }

    public void restoreFromXml(Element root) {
        String activeStr;
        String tmp = root.getAttributeValue("NAME");
        if (tmp != null) {
            this.name = tmp;
        }
        this.isActive = (activeStr = root.getAttributeValue("ACTIVE")) != null && activeStr.equalsIgnoreCase("true");
        String defaultTool = System.getProperty("ghidra.defaulttool");
        if (defaultTool != null && !defaultTool.equals("")) {
            PluginTool tool = this.toolManager.getTool(defaultTool);
            tool.setVisible(this.isActive);
            this.runningTools.add(tool);
            this.toolManager.fireToolAddedEvent(this, tool);
            return;
        }
        for (Element element : root.getChildren("RUNNING_TOOL")) {
            PluginTool tool;
            String toolName = element.getAttributeValue("TOOL_NAME");
            if (toolName == null || (tool = this.toolManager.getTool(toolName)) == null) continue;
            tool.setVisible(this.isActive);
            boolean hadChanges = tool.hasConfigChanged();
            tool.restoreWindowingDataFromXml(element);
            Element toolDataElem = element.getChild("DATA_STATE");
            tool.restoreDataStateFromXml(toolDataElem);
            if (hadChanges) {
                tool.setConfigChanged(true);
            }
            this.runningTools.add(tool);
            this.toolManager.fireToolAddedEvent(this, tool);
        }
    }

    void setVisible(boolean state) {
        PluginTool[] tools;
        this.isActive = state;
        for (PluginTool tool : tools = this.getTools()) {
            tool.setVisible(state);
        }
    }

    void closeRunningTool(PluginTool tool) {
        this.runningTools.remove((Object)tool);
        this.toolManager.setWorkspaceChanged(this);
        this.toolManager.toolRemoved(this, tool);
    }

    void dispose() {
        for (PluginTool tool : this.runningTools) {
            PluginToolAccessUtils.dispose(tool);
        }
        this.runningTools.clear();
    }
}

