/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import db.buffers.DataBuffer;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.util.AnimationUtils;
import docking.util.image.ToolIconURL;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import generic.theme.Gui;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.framework.LoggingInitialization;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AcceptUrlContentTask;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.main.ApplicationLevelPluginsConfiguration;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.ProjectDataPanel;
import ghidra.framework.main.datatree.ChangedFilesDialog;
import ghidra.framework.main.datatree.CheckInTask;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.framework.main.logviewer.ui.FileViewer;
import ghidra.framework.main.logviewer.ui.FileWatcher;
import ghidra.framework.model.DefaultLaunchMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginsConfiguration;
import ghidra.framework.plugintool.ProjectPluginEvent;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.GGlassPane;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FrontEndTool
extends PluginTool
implements OptionsChangeListener {
    public static final String DEFAULT_TOOL_LAUNCH_MODE = "Default Tool Launch Mode";
    public static final String AUTOMATICALLY_SAVE_TOOLS = "Automatically Save Tools";
    private static final String USE_ALERT_ANIMATION_OPTION_NAME = "Use Notification Animation";
    private static final String SHOW_TOOLTIPS_OPTION_NAME = "Show Tooltips";
    private static final String BLINKING_CURSORS_OPTION_NAME = "Allow Blinking Cursors";
    private static final String ENABLE_COMPRESSED_DATABUFFER_OUTPUT = "Use DataBuffer Output Compression";
    private static final String RESTORE_PREVIOUS_PROJECT_NAME = "Restore Previous Project";
    private boolean shouldRestorePreviousProject;
    private static final int MIN_HEIGHT = 600;
    private static final String GHIDRA_SHOW_WHATS_NEW = "GhidraShowWhatsNew";
    private static final String GHIDRA_MAIN_PANEL_DIVIDER_LOC = "GhidraMainPanelDividerLocation";
    private static final String FRONT_END_TOOL_XML_NAME = "FRONTEND";
    private static final String VERSION_ATTRIBUTE_NAME = "VERSION";
    private static final String FRONT_END_FILE_NAME = "FrontEndTool.xml";
    private static final String CONFIGURE_GROUP = "Configure";
    private static final File TOOL_FILE = new File(Application.getUserSettingsDirectory(), "FrontEndTool.xml");
    private WeakSet<ProjectListener> listeners;
    private FrontEndPlugin plugin;
    private DefaultLaunchMode defaultLaunchMode = DefaultLaunchMode.DEFAULT;
    private ComponentProvider compProvider;
    private LogWindow logWindow;
    private WindowListener windowListener;
    private DockingAction configureToolAction;

    public FrontEndTool(ProjectManager pm) {
        super(null, pm, null, null, false, false, false);
        this.setToolName("\u9879\u76ee\u7a97\u53e3");
        this.listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
        this.installFrontEndPlugins();
        this.createActions();
        this.loadToolConfigurationFromDisk();
        this.ensureSize();
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                FrontEndTool.this.setDividerLocation();
                FrontEndTool.this.getToolFrame().removeWindowListener(FrontEndTool.this.windowListener);
            }
        };
        JFrame toolFrame = this.getToolFrame();
        toolFrame.addWindowListener(this.windowListener);
        AppInfo.setFrontEndTool(this);
        this.initFrontEndOptions();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.logWindow != null) {
            this.logWindow.dispose();
        }
        this.shutdown();
    }

    protected void shutdown() {
        System.exit(0);
    }

    @Override
    public boolean accept(URL url) {
        if (!GhidraURL.isLocalProjectURL(url) && !GhidraURL.isServerRepositoryURL(url)) {
            return false;
        }
        Swing.runLater(() -> this.execute(new AcceptUrlContentTask(url, true, this.plugin)));
        return true;
    }

    private void ensureSize() {
        JFrame frame = this.getToolFrame();
        Dimension size = frame.getSize();
        if (size.height < 600) {
            size.height = 600;
            Point center = WindowUtilities.centerOnScreen((Dimension)size);
            frame.setBounds(center.x, center.y, size.width, size.height);
        }
    }

    @Override
    protected PluginsConfiguration createPluginsConfigurations() {
        return new ApplicationLevelPluginsConfiguration();
    }

    public void selectFiles(Set<DomainFile> files) {
        this.plugin.selectFiles(files);
    }

    private void loadToolConfigurationFromDisk() {
        Element root = this.getToolFileXml();
        if (root == null) {
            this.installDefaultApplicationLevelPlugins();
            return;
        }
        GhidraToolTemplate template = new GhidraToolTemplate((Element)root.getChildren().get(0), TOOL_FILE.getAbsolutePath());
        this.refresh(template);
    }

    private Element getToolFileXml() {
        Element element;
        if (!TOOL_FILE.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(TOOL_FILE);
        try {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            element = sax.build((InputStream)is).getRootElement();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JDOMException e) {
                Msg.showError((Object)((Object)this), null, (String)"\u9519\u8bef", (Object)"\u8bfb\u53d6\u524d\u7aef\u914d\u7f6e\u65f6\u51fa\u9519", (Throwable)e);
                return null;
            }
        }
        ((InputStream)is).close();
        return element;
    }

    @Override
    protected boolean doSaveTool() {
        this.saveToolConfigurationToDisk();
        return true;
    }

    void saveToolConfigurationToDisk() {
        ToolTemplate template = this.saveToolToToolTemplate();
        Element root = new Element(FRONT_END_TOOL_XML_NAME);
        String version = Application.getApplicationVersion();
        root.setAttribute(VERSION_ATTRIBUTE_NAME, version);
        root.addContent((Content)template.saveToXml());
        try (FileOutputStream os = new FileOutputStream(TOOL_FILE);){
            Document doc = new Document(root);
            GenericXMLOutputter xmlOut = new GenericXMLOutputter();
            xmlOut.output(doc, (OutputStream)os);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"\u9519\u8bef", (Object)"\u4fdd\u5b58\u524d\u7aef\u914d\u7f6e\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    private void installFrontEndPlugins() {
        this.installFrontEndPlugin();
        if (this.isPreUtilityGhidraVersion()) {
            this.installUtilityPlugins();
        }
    }

    private boolean isPreUtilityGhidraVersion() {
        Element root = this.getToolFileXml();
        if (root == null) {
            return true;
        }
        String version = root.getAttributeValue(VERSION_ATTRIBUTE_NAME);
        return StringUtils.isBlank((CharSequence)version);
    }

    private void installDefaultApplicationLevelPlugins() {
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class pluginClass : ClassSearcher.getClasses(Plugin.class, c -> ApplicationLevelPlugin.class.isAssignableFrom((Class<?>)c))) {
            PluginDescription pd = PluginDescription.getPluginDescription(pluginClass);
            String category = pd.getCategory();
            boolean isBadCategory = category.equals("Examples");
            if (pd.getStatus() != PluginStatus.RELEASED || isBadCategory) continue;
            classNames.add(pluginClass.getName());
        }
        try {
            this.addPlugins(classNames);
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), (Component)this.getToolFrame(), (String)"\u63d2\u4ef6\u9519\u8bef", (Object)"\u6062\u590d\u524d\u7aef\u63d2\u4ef6\u65f6\u51fa\u9519", (Throwable)((Object)e));
        }
    }

    private void installFrontEndPlugin() {
        this.plugin = new FrontEndPlugin(this);
        this.plugin.setProjectManager(this.getProjectManager());
        try {
            this.addPlugin(this.plugin);
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), (Component)this.getToolFrame(), (String)"\u65e0\u6cd5\u521b\u5efa\u9879\u76ee\u7a97\u53e3", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.compProvider = this.plugin.getFrontEndProvider();
        this.showComponentHeader(this.compProvider, false);
    }

    public DefaultLaunchMode getDefaultLaunchMode() {
        return this.defaultLaunchMode;
    }

    private void initFrontEndOptions() {
        boolean autoSave;
        ToolOptions options = this.getOptions("Tool");
        HelpLocation help = new HelpLocation("Tool", "Front_End_Tool_Options");
        options.registerOption(DEFAULT_TOOL_LAUNCH_MODE, (Object)DefaultLaunchMode.DEFAULT, help, "\u8868\u793a\u5728\u9ed8\u8ba4\u542f\u52a8\u65f6\u5e94\u4f7f\u7528\u65b0\u5de5\u5177\u8fd8\u662f\u5df2\u8fd0\u884c\u7684\u5de5\u5177");
        options.registerOption(AUTOMATICALLY_SAVE_TOOLS, (Object)true, help, "\u542f\u7528\u540e\u5de5\u5177\u5173\u95ed\u65f6\u5c06\u88ab\u4fdd\u5b58\u3002");
        options.registerOption(USE_ALERT_ANIMATION_OPTION_NAME, (Object)true, help, "\u8868\u793a\u7528\u6237\u901a\u77e5\u5e94\u8bbe\u7f6e\u4e3a\u52a8\u753b\u6548\u679c\u3002\u8fd9\u4f7f\u5f97\u901a\u77e5\u66f4\u5bb9\u6613\u88ab\u8bc6\u522b\u3002");
        options.registerOption(SHOW_TOOLTIPS_OPTION_NAME, (Object)true, help, "\u63a7\u5236\u5de5\u5177\u63d0\u793a\u5f39\u51fa\u7a97\u53e3\u7684\u663e\u793a\u3002");
        options.registerOption(ENABLE_COMPRESSED_DATABUFFER_OUTPUT, (Object)false, help, "\u542f\u7528\u540e\uff0c\u53d1\u9001\u5230 Ghidra \u670d\u52a1\u5668\u7684\u6570\u636e\u7f13\u51b2\u533a\u5c06\u88ab\u538b\u7f29\uff08\u6709\u5173\u53e6\u4e00\u65b9\u5411\u7684\u914d\u7f6e\uff0c\u8bf7\u53c2\u9605\u670d\u52a1\u5668\u914d\u7f6e\uff09\u3002");
        options.registerOption(BLINKING_CURSORS_OPTION_NAME, (Object)true, help, "\u6b64\u9009\u9879\u63a7\u5236\u6587\u672c\u5149\u6807\u5728\u805a\u7126\u65f6\u662f\u5426\u95ea\u70c1\u3002");
        options.registerOption(RESTORE_PREVIOUS_PROJECT_NAME, (Object)true, help, "\u5728 Ghidra \u542f\u52a8\u65f6\u6062\u590d\u4e0a\u4e00\u4e2a\u9879\u76ee\u3002");
        this.defaultLaunchMode = (DefaultLaunchMode)options.getEnum(DEFAULT_TOOL_LAUNCH_MODE, (Enum)this.defaultLaunchMode);
        GhidraTool.autoSave = autoSave = options.getBoolean(AUTOMATICALLY_SAVE_TOOLS, true);
        boolean animationEnabled = options.getBoolean(USE_ALERT_ANIMATION_OPTION_NAME, true);
        AnimationUtils.setAnimationEnabled((boolean)animationEnabled);
        boolean showToolTips = options.getBoolean(SHOW_TOOLTIPS_OPTION_NAME, true);
        DockingUtils.setGlobalTooltipEnabledOption((boolean)showToolTips);
        boolean compressDataBuffers = options.getBoolean(ENABLE_COMPRESSED_DATABUFFER_OUTPUT, false);
        DataBuffer.enableCompressedSerializationOutput((boolean)compressDataBuffers);
        this.shouldRestorePreviousProject = options.getBoolean(RESTORE_PREVIOUS_PROJECT_NAME, true);
        boolean blink = options.getBoolean(BLINKING_CURSORS_OPTION_NAME, true);
        Gui.setBlinkingCursors((boolean)blink);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (DEFAULT_TOOL_LAUNCH_MODE.equals(optionName)) {
            this.defaultLaunchMode = (DefaultLaunchMode)((Object)newValue);
        }
        if (AUTOMATICALLY_SAVE_TOOLS.equals(optionName)) {
            GhidraTool.autoSave = (Boolean)newValue;
        } else if (USE_ALERT_ANIMATION_OPTION_NAME.equals(optionName)) {
            AnimationUtils.setAnimationEnabled((boolean)((Boolean)newValue));
        } else if (SHOW_TOOLTIPS_OPTION_NAME.equals(optionName)) {
            DockingUtils.setGlobalTooltipEnabledOption((boolean)((Boolean)newValue));
        } else if (ENABLE_COMPRESSED_DATABUFFER_OUTPUT.equals(optionName)) {
            DataBuffer.enableCompressedSerializationOutput((boolean)((Boolean)newValue));
        } else if (RESTORE_PREVIOUS_PROJECT_NAME.equals(optionName)) {
            this.shouldRestorePreviousProject = (Boolean)newValue;
        } else if (BLINKING_CURSORS_OPTION_NAME.equals(optionName)) {
            Gui.setBlinkingCursors((boolean)((Boolean)newValue));
        }
    }

    @Override
    protected boolean canClose() {
        return super.canClose() && this.plugin.closeActiveProject();
    }

    public void setActiveProject(Project project) {
        if (this.isDisposed) {
            return;
        }
        this.configureToolAction.setEnabled(true);
        this.setProject(project);
        this.plugin.setActiveProject(project);
        this.firePluginEvent(new ProjectPluginEvent(((Object)((Object)this)).getClass().getSimpleName(), project));
    }

    public boolean shouldRestorePreviousProject() {
        return this.shouldRestorePreviousProject;
    }

    public void addProjectListener(ProjectListener l) {
        this.listeners.add((Object)l);
    }

    public void removeProjectListener(ProjectListener l) {
        this.listeners.remove((Object)l);
    }

    boolean checkRepositoryConnected(PluginTool tool) {
        RepositoryAdapter repository = tool.getProject().getRepository();
        if (repository == null) {
            return true;
        }
        if (repository.verifyConnection()) {
            return true;
        }
        if (OptionDialog.showYesNoDialog((Component)tool.getToolFrame(), (String)"\u4e0e\u670d\u52a1\u5668\u7684\u8fde\u63a5\u5df2\u4e22\u5931\u3002", (String)"\u4e0e Ghidra \u670d\u52a1\u5668\u7684\u8fde\u63a5\u5df2\u4e22\u5931\u3002\n\u60a8\u8981\u91cd\u65b0\u8fde\u63a5\u5417\uff1f") == 1) {
            try {
                repository.connect();
                return true;
            }
            catch (NotConnectedException e) {
                return false;
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"\u4ed3\u5e93\u8fde\u63a5", (Component)tool.getToolFrame());
                return false;
            }
        }
        return false;
    }

    public void checkIn(PluginTool tool, DomainFile domainFile) {
        this.checkIn(tool, List.of(domainFile), tool.getToolFrame());
    }

    public void checkIn(PluginTool tool, List<DomainFile> fileList, Component parent) {
        if (!this.checkRepositoryConnected(tool)) {
            return;
        }
        ArrayList<DomainFile> changedList = new ArrayList<DomainFile>();
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (DomainFile df : fileList) {
            if (df == null || !df.canCheckin() || !this.canCloseDomainFile(df)) continue;
            list.add(df);
            if (!df.isChanged()) continue;
            changedList.add(df);
        }
        if (changedList.size() > 0) {
            ChangedFilesDialog dialog = new ChangedFilesDialog(tool, changedList);
            dialog.setCancelToolTipText("\u53d6\u6d88\u68c0\u67e5");
            if (!dialog.showDialog()) {
                Msg.info((Object)((Object)this), (Object)"\u68c0\u67e5\u5df2\u53d6\u6d88");
                return;
            }
            for (int i = 0; i < changedList.size(); ++i) {
                DomainFile df = changedList.get(i);
                if (!df.isChanged()) continue;
                list.remove(df);
            }
        }
        if (list.size() > 0) {
            tool.execute(new CheckInTask(tool, list, parent));
        } else {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"\u68c0\u67e5\u5931\u8d25", (Object)"\u65e0\u6cd5\u68c0\u67e5\u6587\u4ef6");
        }
    }

    public void merge(PluginTool tool, DomainFile domainFile, TaskListener taskListener) {
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        list.add(domainFile);
        this.merge(tool, list, taskListener);
    }

    public void merge(PluginTool tool, List<DomainFile> fileList, TaskListener taskListener) {
        if (!this.checkRepositoryConnected(tool)) {
            return;
        }
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        ArrayList<DomainFile> changedList = new ArrayList<DomainFile>();
        for (DomainFile df : fileList) {
            if (df == null || !df.canMerge() || !this.canCloseDomainFile(df)) continue;
            list.add(df);
            if (!df.isChanged()) continue;
            changedList.add(df);
        }
        if (changedList.size() > 0) {
            ChangedFilesDialog dialog = new ChangedFilesDialog(tool, changedList);
            dialog.setCancelToolTipText("\u53d6\u6d88\u5408\u5e76");
            if (!dialog.showDialog()) {
                Msg.info((Object)((Object)this), (Object)"\u5408\u5e76\u5df2\u53d6\u6d88");
                return;
            }
            for (int i = 0; i < changedList.size(); ++i) {
                DomainFile df = changedList.get(i);
                if (!df.isChanged()) continue;
                list.remove(df);
            }
        }
        if (list.size() > 0) {
            this.execute(new MergeTask(tool, list, taskListener));
        } else {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"\u66f4\u65b0\u5931\u8d25", (Object)"\u65e0\u6cd5\u66f4\u65b0\u6587\u4ef6");
        }
    }

    public void setVisible(boolean visibility) {
        if (visibility) {
            super.setVisible(visibility);
            this.plugin.rebuildRecentMenus();
            this.checkWhatsNewPreference();
        } else {
            super.setVisible(visibility);
            AppInfo.setFrontEndTool(null);
            this.dispose();
        }
    }

    public void setBusy(boolean busy) {
        JFrame rootFrame = this.winMgr.getRootFrame();
        Component glassPane = rootFrame.getGlassPane();
        if (!(glassPane instanceof GGlassPane)) {
            Msg.debug((Object)((Object)this), (Object)"\u53d1\u73b0\u6839\u6846\u67b6\u672a\u6ce8\u518c GhidraGlassPane\uff01");
            return;
        }
        GGlassPane dockingGlassPane = (GGlassPane)glassPane;
        dockingGlassPane.setBusy(busy);
    }

    private void addManageExtensionsAction() {
        DockingAction installExtensionsAction = new DockingAction("\u6269\u5c55", "\u9879\u76ee\u7a97\u53e3"){

            public void actionPerformed(ActionContext context) {
                FrontEndTool.this.showExtensions();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FrontEndTool.this.isConfigurable();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", "\u5b89\u88c5\u6269\u5c55"}, null, CONFIGURE_GROUP);
        menuData.setMenuSubGroup("Configure2");
        installExtensionsAction.setMenuBarData(menuData);
        installExtensionsAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "\u6269\u5c55"));
        installExtensionsAction.setEnabled(true);
        this.addAction((DockingActionIf)installExtensionsAction);
    }

    private void addManagePluginsAction() {
        this.configureToolAction = new DockingAction("\u914d\u7f6e\u5de5\u5177", "\u9879\u76ee\u7a97\u53e3"){

            public void actionPerformed(ActionContext context) {
                FrontEndTool.this.showConfig(false, false);
                FrontEndTool.this.manageDialog.setHelpLocation(new HelpLocation("FrontEndPlugin", "\u914d\u7f6e"));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FrontEndTool.this.isConfigurable();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&\u6587\u4ef6", "\u914d\u7f6e"}, null, CONFIGURE_GROUP);
        menuData.setMenuSubGroup("Configure1");
        this.configureToolAction.setMenuBarData(menuData);
        this.configureToolAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "\u914d\u7f6e"));
        this.configureToolAction.setEnabled(true);
        this.addAction((DockingActionIf)this.configureToolAction);
    }

    @Override
    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        FrontEndToolTemplate toolTemplate = new FrontEndToolTemplate(this.getIconURL(), this.saveToXml(includeConfigState), this.getSupportedDataTypes());
        return toolTemplate;
    }

    Iterable<ProjectListener> getListeners() {
        return this.listeners;
    }

    ComponentProvider getProvider() {
        return this.compProvider;
    }

    SaveState getSaveableDisplayData() {
        SaveState saveState = new SaveState();
        this.plugin.writeDataState(saveState);
        return saveState;
    }

    void setSaveableDisplayData(SaveState saveState) {
        this.plugin.readDataState(saveState);
    }

    private void refresh(ToolTemplate tc) {
        this.listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
        Element root = tc.saveToXml();
        Element elem = root.getChild("TOOL");
        this.restoreOptionsFromXml(elem);
        try {
            this.restorePluginsFromXml(elem);
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), (Component)this.getToolFrame(), (String)"\u6062\u590d\u524d\u7aef\u63d2\u4ef6\u65f6\u51fa\u9519", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.winMgr.restoreFromXML(tc.getToolElement());
        this.setConfigChanged(false);
    }

    private void createActions() {
        this.addExitAction();
        this.addManagePluginsAction();
        this.addManageExtensionsAction();
        this.addOptionsAction();
        this.addHelpActions();
        DockingAction action = new DockingAction("\u663e\u793a\u65e5\u5fd7", "Tool"){

            public void actionPerformed(ActionContext context) {
                FrontEndTool.this.showGhidraUserLogFile();
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&\u5e2e\u52a9", "\u663e\u793a\u65e5\u5fd7"}, null, "BBB"));
        action.setEnabled(true);
        this.addAction((DockingActionIf)action);
    }

    private void setDividerLocation() {
        String dividerLocStr = Preferences.getProperty((String)GHIDRA_MAIN_PANEL_DIVIDER_LOC);
        if (dividerLocStr != null) {
            int dividerLoc = this.parse(dividerLocStr, -1);
            ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
            pdp.setDividerLocation(dividerLoc);
            pdp.invalidate();
            this.getToolFrame().validate();
        }
    }

    private int parse(String value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private void checkWhatsNewPreference() {
        if (SystemUtilities.isInDevelopmentMode() || SystemUtilities.isInTestingMode()) {
            return;
        }
        HelpService help = Help.getHelpService();
        String showWhatsNewStribng = Preferences.getProperty((String)GHIDRA_SHOW_WHATS_NEW, (String)"true");
        boolean showWhatsNew = Boolean.parseBoolean(showWhatsNewStribng);
        if (!showWhatsNew) {
            return;
        }
        Preferences.setProperty((String)GHIDRA_SHOW_WHATS_NEW, (String)"false");
        Preferences.store();
        ResourceFile installDir = Application.getInstallationDirectory();
        ResourceFile whatsNewFile = new ResourceFile(installDir, "docs/WhatsNew.html");
        try {
            URL url = whatsNewFile.toURL();
            help.showHelp(url);
        }
        catch (MalformedURLException e) {
            Msg.debug((Object)((Object)this), (Object)"\u65e0\u6cd5\u663e\u793a\u201c\u65b0\u529f\u80fd\u201d\u5e2e\u52a9\u9875\u9762", (Throwable)e);
        }
    }

    @Override
    public boolean canCloseDomainFile(DomainFile df) {
        PluginTool[] tools;
        Project project = this.getProject();
        ToolManager toolManager = project.getToolManager();
        for (PluginTool tool : tools = toolManager.getRunningTools()) {
            DomainFile[] files;
            for (DomainFile domainFile : files = tool.getDomainFiles()) {
                if (df != domainFile) continue;
                return tool.canCloseDomainFile(df);
            }
        }
        return true;
    }

    void showGhidraUserLogFile() {
        File logFile = LoggingInitialization.getApplicationLogFile();
        if (logFile == null) {
            return;
        }
        if (this.logWindow == null) {
            this.logWindow = new LogWindow(logFile);
            JFrame toolFrame = this.getToolFrame();
            Point center = WindowUtilities.centerOnComponent((Component)toolFrame, (Component)this.logWindow);
            this.logWindow.setLocation(center);
            this.logWindow.setVisible(true);
            return;
        }
        this.logWindow.setVisible(true);
        this.logWindow.toFront();
    }

    private class LogWindow
    extends JFrame {
        private static final Dimension DEFAULT_SIZE = new Dimension(600, 400);
        private final File logFile;
        private FileWatcher watcher;

        LogWindow(File logFile) {
            this.setTitle("Ghidra \u7528\u6237\u65e5\u5fd7");
            JFrame toolFrame = FrontEndTool.this.getToolFrame();
            this.setIconImage(toolFrame.getIconImage());
            this.logFile = logFile;
            JPanel panel = this.buildWorkPanel();
            this.getContentPane().add(panel);
            HelpService help = Help.getHelpService();
            help.registerHelp((Object)panel, new HelpLocation("FrontEndPlugin", "StatusWindow"));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (LogWindow.this.watcher != null) {
                        LogWindow.this.watcher.stop();
                    }
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    if (LogWindow.this.watcher != null) {
                        LogWindow.this.watcher.start();
                    }
                }
            });
            this.pack();
        }

        private JPanel buildWorkPanel() {
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    return DEFAULT_SIZE;
                }
            };
            try {
                FVEventListener eventListener = new FVEventListener();
                ChunkModel model = new ChunkModel();
                ChunkReader reader = new ChunkReader(this.logFile, model);
                FileViewer viewer = new FileViewer(reader, model, eventListener);
                panel.add(viewer);
                panel.setVisible(true);
                this.watcher = new FileWatcher(this.logFile, eventListener);
                this.watcher.start();
                FVEvent loadEvt = new FVEvent(FVEvent.EventType.SCROLL_END, null);
                eventListener.send(loadEvt);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"\u8bfb\u53d6\u65e5\u5fd7\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            return panel;
        }
    }

    private class MergeTask
    extends Task {
        private List<DomainFile> list;
        private PluginTool tool;
        private TaskListener taskListener;
        private boolean wasCanceled;

        MergeTask(PluginTool tool, List<DomainFile> list, TaskListener taskListener) {
            super("Merge", true, true, true);
            this.tool = tool;
            this.list = list;
            this.taskListener = taskListener;
        }

        public void run(TaskMonitor monitor) {
            String currentName = null;
            try {
                for (int i = 0; i < this.list.size() && !monitor.isCancelled(); ++i) {
                    DomainFile df = this.list.get(i);
                    currentName = df.getName();
                    monitor.setMessage("\u6b63\u5728\u542f\u52a8\u5408\u5e76\uff1a" + currentName);
                    df.merge(true, monitor);
                }
            }
            catch (VersionException e) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"\u5408\u5e76\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Object)("\u7248\u672c\u6587\u4ef6\u662f\u4f7f\u7528\u8f83\u65b0\u7248\u672c\u7684 Ghidra \u521b\u5efa\u7684\uff1a" + currentName));
            }
            catch (CancelledException e) {
                this.wasCanceled = true;
                Msg.info((Object)((Object)this), (Object)"\u5408\u5e76\u8fdb\u7a0b\u88ab\u53d6\u6d88");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)FrontEndTool.this.getProject().getRepository(), (Exception)e, (String)"\u5408\u5e76\u8fdb\u7a0b", (Component)this.tool.getToolFrame());
            }
            this.notifyTaskListener();
        }

        private void notifyTaskListener() {
            if (this.taskListener == null) {
                return;
            }
            Swing.runNow(() -> {
                if (this.wasCanceled) {
                    this.taskListener.taskCancelled((Task)this);
                } else {
                    this.taskListener.taskCompleted((Task)this);
                }
            });
        }
    }

    private static class FrontEndToolTemplate
    extends GhidraToolTemplate {
        FrontEndToolTemplate(ToolIconURL iconURL, Element element, Class<?>[] supportedDataTypes) {
            super(iconURL, element, supportedDataTypes);
        }
    }
}

