/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.wizard.WizardDialog;
import docking.wizard.WizardModel;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.SaveDataDialog;
import ghidra.framework.main.ViewInfo;
import ghidra.framework.main.wizard.project.ProjectWizardModel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginToolAccessUtils;
import ghidra.framework.store.LockException;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.Swing;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

class FileActionManager {
    private static final int CLOSE_ACCELERATOR = 87;
    private static final int SAVE_ACCELERATOR = 83;
    private static final String LAST_SELECTED_PROJECT_DIRECTORY = "LastSelectedProjectDirectory";
    private static final String DISPLAY_DATA = "DISPLAY_DATA";
    private FrontEndTool tool;
    private FrontEndPlugin plugin;
    private DockingAction closeProjectAction;
    private DockingAction saveAction;
    private List<ViewInfo> reopenList;
    private boolean firingProjectOpened;

    FileActionManager(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = (FrontEndTool)plugin.getTool();
        this.reopenList = new ArrayList<ViewInfo>();
        this.createActions();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u65b0\u5efa\u9879\u76ee", this.plugin.getName()).menuPath(new String[]{"&\u6587\u4ef6", "\u65b0\u5efa\u9879\u76ee..."})).menuGroup("AProject")).keyBinding("ctrl N")).onAction(c -> this.newProject())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u6253\u5f00\u9879\u76ee", this.plugin.getName()).menuPath(new String[]{"&\u6587\u4ef6", "\u6253\u5f00\u9879\u76ee..."})).menuGroup("AProject")).keyBinding("ctrl O")).onAction(c -> this.openProject())).buildAndInstall((Tool)this.tool);
        this.saveAction = new DockingAction("\u4fdd\u5b58\u9879\u76ee", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.saveProject();
                FileActionManager.this.tool.saveToolConfigurationToDisk();
            }
        };
        this.saveAction.setEnabled(false);
        this.saveAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(83, 2)));
        this.saveAction.setMenuBarData(new MenuData(new String[]{"&\u6587\u4ef6", "\u4fdd\u5b58\u9879\u76ee"}, "BProject"));
        this.tool.addAction((DockingActionIf)this.saveAction);
        this.closeProjectAction = new DockingAction("\u5173\u95ed\u9879\u76ee", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.closeProject(false);
            }
        };
        this.closeProjectAction.setEnabled(false);
        this.closeProjectAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(87, 2)));
        this.closeProjectAction.setMenuBarData(new MenuData(new String[]{"&\u6587\u4ef6", "\u5173\u95ed\u9879\u76ee"}, "BProject"));
        this.tool.addAction((DockingActionIf)this.closeProjectAction);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5220\u9664\u9879\u76ee", this.plugin.getName()).menuPath(new String[]{"&\u6587\u4ef6", "\u5220\u9664\u9879\u76ee..."})).menuGroup("CProject")).onAction(c -> this.deleteProject())).buildAndInstall((Tool)this.tool);
    }

    void buildRecentProjectsMenu() {
        ProjectLocator[] recentProjects;
        for (ViewInfo info : this.reopenList) {
            this.tool.removeAction((DockingActionIf)info.getAction());
        }
        this.reopenList.clear();
        for (ProjectLocator projectLocator : recentProjects = this.plugin.getRecentProjects()) {
            String filename = projectLocator.toString();
            ReopenProjectAction action = new ReopenProjectAction(projectLocator, filename);
            this.reopenList.add(new ViewInfo(action, projectLocator.getURL()));
            this.tool.addAction((DockingActionIf)action);
        }
    }

    void newProject() {
        RepositoryAdapter repository;
        ProjectWizardModel model = new ProjectWizardModel(this.tool);
        WizardDialog dialog = new WizardDialog((WizardModel)model);
        dialog.show((Component)this.tool.getToolFrame());
        if (model.wasCancelled()) {
            return;
        }
        if (!this.closeProject(false)) {
            return;
        }
        ProjectLocator projectLocator = model.getProjectLocator();
        Project newProject = this.createProject(projectLocator, repository = model.getRepository());
        if (newProject == null && repository != null) {
            repository.disconnect();
            return;
        }
        this.tool.setActiveProject(newProject);
        this.plugin.rebuildRecentMenus();
        if (newProject != null) {
            this.openProjectAndNotify(newProject);
        }
    }

    private Project createProject(ProjectLocator locator, RepositoryAdapter repository) {
        try {
            return this.tool.getProjectManager().createProject(locator, repository, true);
        }
        catch (Exception e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"\u521b\u5efa\u9879\u76ee\u51fa\u9519", (Object)("\u521b\u5efa\u9879\u76ee\u51fa\u9519 '" + locator.getName() + "': " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void openProject() {
        GhidraFileChooser fileChooser;
        ProjectLocator projectLocator;
        ProjectLocator currentProjectLocator = null;
        Project activeProject = this.plugin.getActiveProject();
        if (activeProject != null) {
            currentProjectLocator = activeProject.getProjectLocator();
        }
        if ((projectLocator = this.plugin.chooseProject(fileChooser = this.plugin.createFileChooser(LAST_SELECTED_PROJECT_DIRECTORY), "Open", LAST_SELECTED_PROJECT_DIRECTORY)) != null && !this.doOpenProject(projectLocator) && currentProjectLocator != null) {
            this.doOpenProject(currentProjectLocator);
        }
        fileChooser.dispose();
    }

    final boolean openProject(ProjectLocator projectLocator) {
        OpenTaskRunnable openRunnable = new OpenTaskRunnable(projectLocator);
        TaskLauncher.launchModal((String)"\u6253\u5f00\u9879\u76ee\u4e2d", () -> Swing.runNow((Runnable)openRunnable));
        return openRunnable.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean doOpenProject(ProjectLocator projectLocator) {
        Project project = null;
        try {
            if (!this.closeProject(false)) {
                boolean bl = true;
                return bl;
            }
            ProjectManager pm = this.plugin.getProjectManager();
            project = pm.openProject(projectLocator, true, false);
            this.firingProjectOpened = true;
            this.tool.setActiveProject(project);
            this.openProjectAndNotify(project);
            this.firingProjectOpened = false;
            Msg.info((Object)this, (Object)("\u5df2\u6253\u5f00\u9879\u76ee\uff1a" + projectLocator.getName()));
        }
        catch (NotFoundException nfe) {
            String msg = "\u672a\u627e\u5230\u9879\u76ee\uff1a" + String.valueOf(projectLocator);
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u6253\u5f00\u9879\u76ee\u51fa\u9519", (Object)msg);
            Msg.error((Object)this, (Object)msg);
        }
        catch (NotOwnerException e) {
            Msg.showError((Object)this, null, (String)"\u4e0d\u662f\u9879\u76ee\u6240\u6709\u8005", (Object)("\u4e0d\u80fd\u6253\u5f00\u9879\u76ee " + String.valueOf(projectLocator) + "\n" + e.getMessage() + "\n \n\u6bcf\u4e2a\u7528\u6237\u5fc5\u987b\u521b\u5efa\u81ea\u5df1\u7684\u9879\u76ee\uff0c\u5982\u6709\u9700\u8981\uff0c\u53ef\u4ee5\u901a\u8fc7\u5728\u81ea\u5df1\u6253\u5f00\u7684\u9879\u76ee\u4e2d\u4f7f\u7528\u201c\u67e5\u770b\u5176\u4ed6\u201d\u64cd\u4f5c\u67e5\u770b\n\u5176\u4ed6\u7528\u6237\u7684\u9879\u76ee\u5e76\u590d\u5236\u6587\u4ef6\uff0c\u6216\u8005\u521b\u5efa\u201c\u5171\u4eab\u9879\u76ee\u201d\u4ee5\u5141\u8bb8\u4e00\u7ec4\u7528\u6237\u4f7f\u7528\u57fa\u4e8e\u670d\u52a1\u5668\u7684\u5171\u4eab\u4ed3\u5e93\u3002\n"));
            Msg.error((Object)this, (Object)("\u4e0d\u80fd\u6253\u5f00\u9879\u76ee: " + e.getMessage()));
        }
        catch (LockException e) {
            Msg.showInfo((Object)this, null, (String)"\u6253\u5f00\u9879\u76ee\u5931\u8d25", (Object)e.getMessage());
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"\u6253\u5f00\u9879\u76ee\u5931\u8d25", (Object)("\u6253\u5f00\u9879\u76ee\u51fa\u9519: " + String.valueOf(projectLocator)), (Throwable)e);
        }
        finally {
            this.plugin.rebuildRecentMenus();
        }
        return project != null;
    }

    private DomainObject[] lockDomainObjects(List<DomainFile> files) {
        int lastIndex;
        DomainObject[] domainObjects = new DomainObject[files.size()];
        boolean locked = true;
        for (lastIndex = 0; lastIndex < files.size(); ++lastIndex) {
            try {
                domainObjects[lastIndex] = files.get(lastIndex).getDomainObject(this, false, false, null);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"\u672a\u80fd\u83b7\u53d6\u57df\u5bf9\u8c61\u5b9e\u4f8b", (Throwable)t);
                locked = false;
                break;
            }
            if (domainObjects[lastIndex].lock(null)) continue;
            String title = "\u9000\u51fa Ghidra";
            StringBuffer buf = new StringBuffer();
            DomainObject d = domainObjects[lastIndex];
            buf.append("\u6587\u4ef6 " + files.get(lastIndex).getPathname() + " \u5f53\u524d\u6b63\u5728\u88ab\u4fee\u6539\uff0c\u7531\n");
            buf.append("\u4ee5\u4e0b\u64cd\u4f5c\uff1a\n \n");
            TransactionInfo t = d.getCurrentTransactionInfo();
            ArrayList<String> list = t.getOpenSubTransactions();
            for (String element : list) {
                buf.append("\n     ");
                buf.append(element);
            }
            buf.append("\n \n");
            buf.append("\u60a8\u53ef\u4ee5\u9000\u51fa Ghidra\uff0c\u4f46\u4e0a\u8ff0\u64cd\u4f5c\u5c06\u88ab\u4e2d\u6b62\uff0c\u4e14\u7531\u8fd9\u4e9b\u64cd\u4f5c\u6240\u505a\u7684\u6240\u6709\u66f4\u6539\n");
            buf.append("\uff08\u4ee5\u53ca\u81ea\u8fd9\u4e9b\u64cd\u4f5c\u5f00\u59cb\u4ee5\u6765\u6240\u505a\u7684\u6240\u6709\u66f4\u6539\uff09\u90fd\u5c06\u4e22\u5931\uff01\n");
            buf.append("\u60a8\u4ecd\u7136\u53ef\u4ee5\u9009\u62e9\u4fdd\u5b58\u5728\u8fd9\u4e9b\u64cd\u4f5c\u5f00\u59cb\u4e4b\u524d\u6240\u505a\u7684\u4efb\u4f55\u66f4\u6539\u3002");
            buf.append("\u60a8\u662f\u5426\u8981\u4e2d\u6b62\u64cd\u4f5c\u5e76\u9000\u51fa Ghidra\uff1f");
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)title, (String)buf.toString(), (String)"\u9000\u51fa Ghidra", (int)2);
            if (result == 0) {
                locked = false;
                domainObjects[lastIndex].release(this);
                break;
            }
            d.forceLock(true, null);
        }
        if (!locked) {
            for (int i = 0; i < lastIndex; ++i) {
                domainObjects[i].unlock();
                domainObjects[i].release(this);
            }
            return null;
        }
        return domainObjects;
    }

    boolean closeProject(boolean isExiting) {
        PluginTool[] runningTools;
        Project activeProject = this.plugin.getActiveProject();
        if (activeProject == null) {
            return true;
        }
        for (PluginTool runningTool : runningTools = activeProject.getToolManager().getRunningTools()) {
            if (PluginToolAccessUtils.canClose(runningTool)) continue;
            return false;
        }
        boolean saveSuccessful = this.saveChangedData(activeProject);
        if (!saveSuccessful) {
            return false;
        }
        if (!activeProject.saveSessionTools()) {
            return false;
        }
        this.doSaveProject(activeProject);
        String name = activeProject.getName();
        ProjectLocator projectLocator = activeProject.getProjectLocator();
        activeProject.close();
        this.fireProjectClosed(activeProject);
        if (!isExiting) {
            this.tool.setActiveProject(null);
            Msg.info((Object)this, (Object)("\u5df2\u5173\u95ed\u9879\u76ee\uff1a" + name));
            this.plugin.rebuildRecentMenus();
            this.plugin.getProjectManager().setLastOpenedProject(null);
        } else {
            this.plugin.getProjectManager().setLastOpenedProject(projectLocator);
        }
        if (this.tool.getManagePluginsDialog() != null) {
            this.tool.getManagePluginsDialog().close();
        }
        return true;
    }

    private void doSaveProject(Project project) {
        project.setSaveableData(DISPLAY_DATA, this.tool.getSaveableDisplayData());
        project.save();
    }

    private void openProjectAndNotify(Project project) {
        this.doRestoreProject(project);
        this.fireProjectOpened(project);
    }

    private void doRestoreProject(Project project) {
        SaveState saveState = project.getSaveableData(DISPLAY_DATA);
        if (saveState == null) {
            return;
        }
        this.tool.setSaveableDisplayData(saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveChangedData(Project activeProject) {
        List<DomainFile> data = activeProject.getOpenData();
        if (data.isEmpty()) {
            return true;
        }
        DomainObject[] lockedObjects = this.lockDomainObjects(data);
        if (lockedObjects == null) {
            return false;
        }
        List<DomainFile> changedFiles = this.getChangedFiles(data);
        try {
            if (!this.checkReadOnlyFiles(lockedObjects)) {
                boolean bl = false;
                return bl;
            }
            SaveDataDialog saveDialog = new SaveDataDialog(this.tool);
            if (!saveDialog.showDialog(changedFiles)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            for (DomainObject lockedObject : lockedObjects) {
                lockedObject.unlock();
                lockedObject.release(this);
            }
        }
        return true;
    }

    private List<DomainFile> getChangedFiles(List<DomainFile> data) {
        ArrayList<DomainFile> changedFiles = new ArrayList<DomainFile>();
        for (DomainFile domainFile : data) {
            if (!domainFile.isChanged()) continue;
            changedFiles.add(domainFile);
        }
        return changedFiles;
    }

    void setActiveProject(Project activeProject) {
        this.plugin.rebuildRecentMenus();
        if (!this.firingProjectOpened && activeProject != null) {
            this.openProjectAndNotify(activeProject);
        }
    }

    void saveProject() {
        Project project = this.plugin.getActiveProject();
        if (project == null) {
            return;
        }
        if (!project.saveSessionTools()) {
            return;
        }
        this.doSaveProject(project);
        Msg.info((Object)this, (Object)("\u5df2\u4fdd\u5b58\u9879\u76ee\uff1a" + project.getName()));
    }

    private boolean allowDelete(Project activeProject) {
        if (activeProject != null) {
            Msg.showWarn(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u65e0\u6cd5\u5220\u9664\u6fc0\u6d3b\u9879\u76ee", (Object)"\u60a8\u5fc5\u987b\u5173\u95ed\u540e\u518d\u5220\u9664\u3002");
            return false;
        }
        return true;
    }

    private void deleteProject() {
        GhidraFileChooser fileChooser = this.plugin.createFileChooser(LAST_SELECTED_PROJECT_DIRECTORY);
        ProjectLocator projectLocator = this.plugin.chooseProject(fileChooser, "Delete", LAST_SELECTED_PROJECT_DIRECTORY);
        fileChooser.dispose();
        if (projectLocator == null) {
            return;
        }
        ProjectManager pm = this.plugin.getProjectManager();
        if (!pm.projectExists(projectLocator)) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u9879\u76ee\u4e0d\u5b58\u5728", (Object)("\u9879\u76ee " + projectLocator.getName() + " \u672a\u627e\u5230\u3002"));
            return;
        }
        Project activeProject = this.plugin.getActiveProject();
        StringBuffer confirmMsg = new StringBuffer("\u9879\u76ee\uff1a");
        confirmMsg.append(projectLocator.toString());
        confirmMsg.append(" ?\n");
        boolean isActiveProject = activeProject != null && activeProject.getProjectLocator().equals(projectLocator);
        boolean isOpenProjectView = this.isOpenProjectView(projectLocator);
        if (!this.allowDelete(isActiveProject ? activeProject : null)) {
            return;
        }
        confirmMsg.append(" \n");
        confirmMsg.append("\u8b66\u544a\uff1a\u5220\u9664\u4e0d\u53ef\u64a4\u9500\uff01");
        if (!this.plugin.confirmDelete(confirmMsg.toString())) {
            return;
        }
        String projectName = projectLocator.getName();
        try {
            if (!pm.deleteProject(projectLocator)) {
                Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"\u5220\u9664\u9879\u76ee\u51fa\u9519", (Object)("\u6240\u6709\u9879\u76ee\u6587\u4ef6 " + projectName + " \u5c06\u4e0d\u88ab\u5220\u9664\u3002"));
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("\u5220\u9664\u9879\u76ee\u51fa\u9519\uff1a" + projectName + ", " + e.getMessage()), (Throwable)e);
            return;
        }
        if (isActiveProject) {
            activeProject.close();
            this.fireProjectClosed(activeProject);
            this.tool.setActiveProject(null);
        } else if (isOpenProjectView) {
            this.plugin.getProjectActionManager().closeView(projectLocator.getURL());
        }
        this.plugin.rebuildRecentMenus();
        Msg.info((Object)this, (Object)("\u5df2\u5220\u9664\u9879\u76ee\uff1a" + projectName));
    }

    private boolean isOpenProjectView(ProjectLocator projectLocator) {
        boolean isOpenView = false;
        ProjectLocator[] openViews = this.plugin.getProjectDataPanel().getProjectViews();
        for (int v = 0; !isOpenView && v < openViews.length; ++v) {
            isOpenView = openViews[v].equals(projectLocator);
        }
        return isOpenView;
    }

    final void enableActions(boolean enabled) {
        this.closeProjectAction.setEnabled(enabled);
        this.saveAction.setEnabled(enabled);
    }

    private boolean checkReadOnlyFiles(DomainObject[] objs) {
        ArrayList<DomainObject> list = new ArrayList<DomainObject>(10);
        for (DomainObject domainObject : objs) {
            try {
                if (!domainObject.isChanged() || domainObject.getDomainFile().canSave()) continue;
                list.add(domainObject);
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, null, null, (Throwable)e);
            }
        }
        if (list.size() == 0) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\u4ee5\u4e0b\u6587\u4ef6\u4e3a\u53ea\u8bfb\uff0c\u65e0\u6cd5\u76f4\u63a5\u4fdd\u5b58\u201c\u539f\u6837\u201d\u3002\n\u60a8\u5fc5\u987b\u4e3a\u8fd9\u4e9b\u6587\u4ef6\u624b\u52a8\u6267\u884c\u201c\u53e6\u5b58\u4e3a\u201d\u64cd\u4f5c\uff1a\n \n");
        for (DomainObject obj : list) {
            sb.append(obj.getDomainFile().getPathname());
            sb.append("\n");
        }
        sb.append("\n\u9009\u62e9\u201c\u53d6\u6d88\u201d\u4ee5\u53d6\u6d88\u5173\u95ed\u9879\u76ee\uff0c\u6216\u9009\u62e9\u201c\u653e\u5f03\u66f4\u6539\u201d\u4ee5\u7ee7\u7eed\u3002");
        return OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"\u53ea\u8bfb\u6587\u4ef6", (String)sb.toString(), (String)"\u4e22\u5f03\u66f4\u6539", (int)3) == 1;
    }

    private void fireProjectOpened(Project project) {
        for (ProjectListener listener : this.tool.getListeners()) {
            listener.projectOpened(project);
        }
    }

    private void fireProjectClosed(Project project) {
        for (ProjectListener listener : this.tool.getListeners()) {
            listener.projectClosed(project);
        }
    }

    private class ReopenProjectAction
    extends DockingAction {
        private ProjectLocator projectLocator;

        private ReopenProjectAction(ProjectLocator projectLocator, String filename) {
            super(filename, FileActionManager.this.plugin.getName(), false);
            this.projectLocator = projectLocator;
            this.setMenuBarData(new MenuData(new String[]{"&\u6587\u4ef6", "\u91cd\u65b0\u6253\u5f00", filename}, null, "AProject"));
            FileActionManager.this.tool.setMenuGroup(new String[]{"&\u6587\u4ef6", "\u91cd\u65b0\u6253\u5f00"}, "AProject");
            this.setEnabled(true);
            this.setHelpLocation(new HelpLocation(FileActionManager.this.plugin.getName(), "Reopen_Project"));
        }

        public void actionPerformed(ActionContext context) {
            FileActionManager.this.doOpenProject(this.projectLocator);
        }
    }

    private class OpenTaskRunnable
    implements Runnable {
        private final ProjectLocator newProjectLocator;
        private boolean result = false;

        OpenTaskRunnable(ProjectLocator newProjectLocator) {
            this.newProjectLocator = newProjectLocator;
        }

        @Override
        public void run() {
            this.result = FileActionManager.this.doOpenProject(this.newProjectLocator);
        }

        boolean getResult() {
            return this.result;
        }
    }
}

