/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.gui;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.theme.gui.ThemeEditorDialog;
import docking.theme.gui.ThemeUtils;
import generic.theme.GTheme;
import generic.theme.ThemeManager;
import ghidra.app.plugin.gui.CreateThemeDialog;
import ghidra.app.plugin.gui.ThemeChooserDialog;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Utility", category="Framework", shortDescription="\u7ba1\u7406 Ghidra GUI \u4e3b\u9898", description="\u6dfb\u52a0\u7528\u4e8e\u7ba1\u7406 Ghidra \u4e2d\u4e3b\u9898\u7684\u64cd\u4f5c\u548c\u9009\u9879\u3002\u6b64\u63d2\u4ef6\u4ec5\u5728 Ghidra \u9879\u76ee\u7a97\u53e3\u4e2d\u53ef\u7528\u3002")
public class ThemeManagerPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    private ThemeManager themeManager = ThemeManager.getInstance();

    public ThemeManagerPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        String owner = this.getName();
        String group = "theme";
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5207\u6362\u4e3b\u9898", owner).menuPath(new String[]{"\u7f16\u8f91", "\u4e3b\u9898", "\u5207\u6362..."})).menuGroup(group, "1")).helpLocation(new HelpLocation("Theming", "Switch_Theme"))).onAction(e -> this.switchTheme())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u914d\u7f6e", owner).menuPath(new String[]{"\u7f16\u8f91", "\u4e3b\u9898", "\u914d\u7f6e"})).menuGroup(group, "2")).helpLocation(new HelpLocation("Theming", "Edit_Theme"))).onAction(e -> this.configure())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u65b0\u5efa\u4e3b\u9898", owner).menuPath(new String[]{"\u7f16\u8f91", "\u4e3b\u9898", "\u65b0\u5efa..."})).menuGroup(group, "3")).helpLocation(new HelpLocation("Theming", "New_Theme"))).onAction(e -> this.createNewTheme())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5bfc\u5165\u4e3b\u9898", owner).menuPath(new String[]{"\u7f16\u8f91", "\u4e3b\u9898", "\u5bfc\u5165..."})).menuGroup(group, "4")).helpLocation(new HelpLocation("Theming", "Import_Theme"))).onAction(e -> ThemeUtils.importTheme((ThemeManager)this.themeManager))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5bfc\u51fa\u4e3b\u9898", owner).menuPath(new String[]{"\u7f16\u8f91", "\u4e3b\u9898", "\u5bfc\u51fa..."})).menuGroup(group, "5")).helpLocation(new HelpLocation("Theming", "Export_Theme"))).onAction(e -> ThemeUtils.exportTheme((ThemeManager)this.themeManager))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5220\u9664\u4e3b\u9898", owner).menuPath(new String[]{"\u7f16\u8f91", "\u4e3b\u9898", "\u5220\u9664..."})).menuGroup(group, "6")).helpLocation(new HelpLocation("Theming", "Delete_Theme"))).onAction(e -> ThemeUtils.deleteTheme((ThemeManager)this.themeManager))).buildAndInstall((Tool)this.tool);
    }

    private void switchTheme() {
        ThemeChooserDialog dialog = new ThemeChooserDialog(this.themeManager);
        this.tool.showDialog(dialog);
    }

    private void createNewTheme() {
        if (!ThemeUtils.askToSaveThemeChanges((ThemeManager)this.themeManager)) {
            return;
        }
        CreateThemeDialog dialog = new CreateThemeDialog(this.themeManager);
        GTheme newTheme = dialog.getNewTheme(this.tool, "\u65b0\u4e3b\u9898");
        if (newTheme != null) {
            this.themeManager.addTheme(newTheme);
            this.themeManager.setTheme(newTheme);
            this.configure();
        }
    }

    private void configure() {
        ThemeEditorDialog dialog = ThemeEditorDialog.getRunningInstance();
        if (dialog != null) {
            dialog.toFront();
            return;
        }
        ThemeEditorDialog.editTheme((ThemeManager)this.themeManager);
    }

    @Override
    protected boolean canClose() {
        if (this.themeManager.hasThemeChanges()) {
            return ThemeUtils.askToSaveThemeChanges((ThemeManager)this.themeManager);
        }
        return true;
    }
}

