/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img2;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.ios.img2.Img2;
import ghidra.file.formats.ios.img2.Img2Constants;
import ghidra.file.formats.ios.img2.Img2FileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;

public class Img2FileSystemFactory
implements GFileSystemFactoryByteProvider<Img2FileSystem>,
GFileSystemProbeBytesOnly {
    public int getBytesRequired() {
        return Img2Constants.IMG2_SIGNATURE_BYTES.length;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return Arrays.equals(startBytes, 0, Img2Constants.IMG2_SIGNATURE_BYTES.length, Img2Constants.IMG2_SIGNATURE_BYTES, 0, Img2Constants.IMG2_SIGNATURE_BYTES.length);
    }

    public Img2FileSystem create(FSRLRoot targetFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        Img2 img2 = new Img2(provider);
        if (!img2.isValid()) {
            FSUtilities.uncheckedClose((AutoCloseable)provider, null);
            throw new IOException("Invalid IMG2 file!");
        }
        ByteProviderWrapper payloadProvider = new ByteProviderWrapper(provider, 1024L, (long)img2.getDataLen(), null);
        return new Img2FileSystem(targetFSRL, (ByteProvider)payloadProvider, img2.getImageType(), null, provider);
    }
}

