/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class MultiProgramMemoryByteProvider
implements ByteProvider {
    private Program[] programs;
    private Address[] baseAddresses;

    MultiProgramMemoryByteProvider(Program program1) {
        this.checkPrograms();
        this.programs = new Program[]{program1};
        this.baseAddresses = new Address[]{program1.getAddressFactory().getDefaultAddressSpace().getAddress(0L)};
    }

    MultiProgramMemoryByteProvider(Program program1, Program program2) {
        this.checkPrograms();
        this.programs = new Program[]{program1, program2};
        this.baseAddresses = new Address[]{program1.getAddressFactory().getDefaultAddressSpace().getAddress(0L), program2.getAddressFactory().getDefaultAddressSpace().getAddress(0L)};
    }

    MultiProgramMemoryByteProvider(Program program1, Program program2, Program program3) {
        this.checkPrograms();
        this.programs = new Program[]{program1, program2, program3};
        this.baseAddresses = new Address[]{program1.getAddressFactory().getDefaultAddressSpace().getAddress(0L), program2.getAddressFactory().getDefaultAddressSpace().getAddress(0L), program3.getAddressFactory().getDefaultAddressSpace().getAddress(0L)};
    }

    private void checkPrograms() {
    }

    public File getFile() {
        if (this.programs.length != 0) {
            return new File(this.programs[1].getExecutablePath());
        }
        return null;
    }

    public String getName() {
        if (this.programs.length != 0) {
            return this.programs[1].getName();
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.programs.length != 0) {
            return this.programs[1].getExecutablePath();
        }
        return null;
    }

    public long length() {
        int length = 0;
        for (Program program : this.programs) {
            length = (int)((long)length + program.getMemory().getSize());
        }
        return length;
    }

    public boolean isValidIndex(long index) {
        for (int i = 0; i < this.programs.length; ++i) {
            try {
                Address indexAddress = this.baseAddresses[i].add(index);
                return this.programs[i].getMemory().contains(indexAddress);
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                continue;
            }
        }
        return false;
    }

    public void close() throws IOException {
        this.programs = null;
        this.baseAddresses = null;
    }

    public byte readByte(long index) throws IOException {
        for (int i = 0; i < this.programs.length; ++i) {
            try {
                return this.programs[i].getMemory().getByte(this.baseAddresses[i].add(index));
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IOException("Unable to read byte at index: " + index);
    }

    public byte[] readBytes(long index, long length) throws IOException {
        for (int i = 0; i < this.programs.length; ++i) {
            try {
                byte[] bytes = new byte[(int)length];
                int nRead = this.programs[i].getMemory().getBytes(this.baseAddresses[i].add(index), bytes);
                if ((long)nRead != length) {
                    throw new IOException("Unable to read " + length + " bytes at index " + index);
                }
                return bytes;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IOException("Unable to read " + length + " bytes at index " + index);
    }

    public InputStream getInputStream(long index) throws IOException {
        throw new UnsupportedOperationException();
    }
}

