/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.OverridePrototypeAction;
import ghidra.app.plugin.core.function.editor.FunctionEditorDialog;
import ghidra.app.plugin.core.function.editor.FunctionEditorModel;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.InvalidInputException;
import java.util.List;

public class SpecifyCPrototypeAction
extends AbstractDecompilerAction {
    public SpecifyCPrototypeAction() {
        super("\u7f16\u8f91\u51fd\u6570\u7b7e\u540d");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionEditSignature"));
        this.setPopupMenuData(new MenuData(new String[]{"\u7f16\u8f91\u51fd\u6570\u7b7e\u540d"}, "Decompile"));
    }

    private void verifyDynamicEditorModel(HighFunction hf, FunctionEditorModel model) {
        VariableStorage decompParamStorage;
        VariableStorage modelParamStorage;
        int i;
        List parameters;
        int modelParamCnt;
        int autoParamCnt;
        FunctionPrototype functionPrototype = hf.getFunctionPrototype();
        int decompParamCnt = functionPrototype.getNumParams();
        boolean useCustom = decompParamCnt < (autoParamCnt = (modelParamCnt = (parameters = model.getParameters()).size()) - decompParamCnt) | model.canUseCustomStorage();
        for (i = 0; i < autoParamCnt && !useCustom; ++i) {
            if (i >= decompParamCnt) {
                useCustom = true;
                continue;
            }
            modelParamStorage = ((ParamInfo)parameters.get(i)).getStorage();
            if (modelParamStorage.equals((Object)(decompParamStorage = functionPrototype.getParam(i).getStorage()))) continue;
            useCustom = true;
        }
        if (!useCustom) {
            for (i = 0; i < autoParamCnt; ++i) {
                model.setSelectedParameterRows(new int[]{autoParamCnt + 1});
                model.removeParameters();
            }
            for (i = autoParamCnt; i < decompParamCnt; ++i) {
                modelParamStorage = ((ParamInfo)parameters.get(i)).getStorage();
                if (modelParamStorage.equals((Object)(decompParamStorage = functionPrototype.getParam(i).getStorage()))) continue;
                useCustom = true;
                break;
            }
        }
        if (useCustom) {
            model.setUseCustomizeStorage(true);
            model.setFunctionData(this.buildSignature(hf));
            model.setReturnStorage(functionPrototype.getReturnStorage());
            parameters = model.getParameters();
            for (i = 0; i < decompParamCnt; ++i) {
                model.setParameterStorage((ParamInfo)parameters.get(i), functionPrototype.getParam(i).getStorage());
            }
        }
    }

    private FunctionDefinitionDataType buildSignature(HighFunction hf) {
        Function func = hf.getFunction();
        FunctionDefinitionDataType fsig = new FunctionDefinitionDataType(CategoryPath.ROOT, func.getName(), (DataTypeManager)func.getProgram().getDataTypeManager());
        FunctionPrototype functionPrototype = hf.getFunctionPrototype();
        try {
            fsig.setCallingConvention(functionPrototype.getModelName());
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        int np = hf.getLocalSymbolMap().getNumParams();
        fsig.setReturnType(functionPrototype.getReturnType());
        ParameterDefinitionImpl[] args = new ParameterDefinitionImpl[np];
        for (int i = 0; i < np; ++i) {
            HighSymbol parm = hf.getLocalSymbolMap().getParamSymbol(i);
            args[i] = new ParameterDefinitionImpl(parm.getName(), parm.getDataType(), null);
        }
        fsig.setArguments((ParameterDefinition[])args);
        fsig.setVarArgs(functionPrototype.isVarArg());
        fsig.setNoReturn(functionPrototype.hasNoReturn());
        return fsig;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function decompiledFunction = context.getFunction();
        Function func = this.getFunction(context);
        if (func == null || func instanceof UndefinedFunction) {
            return false;
        }
        return func == decompiledFunction || OverridePrototypeAction.getSymbol(decompiledFunction, context.getTokenAtCursor()) == null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function function = this.getFunction(context);
        PluginTool tool = context.getTool();
        DataTypeManagerService service = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        FunctionEditorModel model = new FunctionEditorModel(service, function);
        HighFunction hf = context.getHighFunction();
        FunctionPrototype functionPrototype = hf.getFunctionPrototype();
        if (function.getEntryPoint().equals((Object)hf.getFunction().getEntryPoint())) {
            if (function.getSignatureSource() == SourceType.DEFAULT) {
                model.setFunctionData(this.buildSignature(hf));
                this.verifyDynamicEditorModel(hf, model);
            } else if (function.getReturnType() == DataType.DEFAULT) {
                model.setFormalReturnType(functionPrototype.getReturnType());
                if (model.canUseCustomStorage()) {
                    model.setReturnStorage(functionPrototype.getReturnStorage());
                }
            }
        }
        model.setModelUnchanged();
        FunctionEditorDialog dialog = new FunctionEditorDialog(model, true);
        tool.showDialog((DialogComponentProvider)dialog, (ComponentProvider)context.getComponentProvider());
    }
}

