/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.search.SearchResults;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchLocation;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Worker;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DecompilerSearchResults
extends SearchResults {
    private ProgramLocation programLocation;
    private DecompilerPanel decompilerPanel;
    private String searchText;
    private List<SearchLocation> searchLocations;
    private Map<Integer, List<DecompilerSearchLocation>> locationsByLine;
    private TreeMap<LinePosition, DecompilerSearchLocation> matchesByPosition = new TreeMap();
    private DecompilerSearchLocation activeLocation;

    DecompilerSearchResults(Worker worker, DecompilerPanel decompilerPanel, String searchText, List<SearchLocation> searchLocations) {
        super(worker);
        this.decompilerPanel = decompilerPanel;
        this.searchText = searchText;
        this.searchLocations = searchLocations;
        this.programLocation = decompilerPanel.getCurrentLocation();
        for (SearchLocation location : searchLocations) {
            int line = location.getLineNumber();
            int col = location.getStartIndexInclusive();
            LinePosition lp = new LinePosition(line, col);
            DecompilerSearchLocation dsl = (DecompilerSearchLocation)location;
            this.matchesByPosition.put(lp, dsl);
        }
    }

    public String getName() {
        DecompilerController controller = this.decompilerPanel.getController();
        Function function = controller.getFunction();
        return function.getName() + "()";
    }

    ProgramLocation getDecompileLocation() {
        return this.programLocation;
    }

    boolean isInvalid(String otherSearchText) {
        if (this.isDifferentFunction()) {
            return true;
        }
        return !this.searchText.equals(otherSearchText);
    }

    public boolean isEmpty() {
        return this.searchLocations.isEmpty();
    }

    public List<SearchLocation> getLocations() {
        return this.searchLocations;
    }

    public Map<Integer, List<DecompilerSearchLocation>> getLocationsByLine() {
        if (this.locationsByLine == null) {
            this.locationsByLine = this.searchLocations.stream().map(l -> (DecompilerSearchLocation)((Object)l)).collect(Collectors.groupingBy(l -> l.getLineNumber()));
        }
        return this.locationsByLine;
    }

    private boolean isDifferentFunction() {
        return !this.decompilerPanel.containsLocation(this.programLocation);
    }

    private boolean isMyFunction() {
        return this.decompilerPanel.containsLocation(this.programLocation);
    }

    public DecompilerSearchLocation getContainingLocation(FieldLocation fieldLocation, boolean searchForward) {
        DecompilerSearchLocation nextLocation = this.getNextLocation(fieldLocation, searchForward);
        if (nextLocation == null) {
            return null;
        }
        if (nextLocation.contains(fieldLocation)) {
            return nextLocation;
        }
        return null;
    }

    public DecompilerSearchLocation getActiveLocation() {
        return this.activeLocation;
    }

    private void installSearchResults() {
        if (this.isDifferentFunction()) {
            return;
        }
        this.decompilerPanel.setSearchResults(this);
    }

    private void clearSearchResults() {
        this.decompilerPanel.clearSearchResults(this);
    }

    public void decompilerUpdated() {
        if (this.isDifferentFunction()) {
            this.deactivate();
        }
    }

    public void deactivate() {
        SearchResults.SwingJob job = new SearchResults.SwingJob((SearchResults)this, this::clearSearchResults);
        this.runJob((SearchResults.FindJob)job);
    }

    public void activate() {
        SearchResults.FindJob job = this.createActivationJob().thenRunSwing(this::installSearchResults);
        this.runJob(job);
    }

    public void setActiveLocation(SearchLocation location) {
        if (this.activeLocation == location) {
            return;
        }
        this.activeLocation = (DecompilerSearchLocation)location;
        if (location == null) {
            return;
        }
        this.activate();
    }

    private SearchResults.ActivationJob createActivationJob() {
        if (this.isMyFunction()) {
            return this.createFinishedActivationJob();
        }
        return (SearchResults.ActivationJob)new ActivateFunctionJob().thenWait(this::isMyFunction, Duration.ofSeconds(5L));
    }

    protected SearchResults.ActivationJob createFinishedActivationJob() {
        return new SearchResults.ActivationJob((SearchResults)this);
    }

    public void dispose() {
        this.setActiveLocation(null);
        this.decompilerPanel.clearSearchResults(this);
        this.searchLocations.clear();
    }

    DecompilerSearchLocation getNextLocation(FieldLocation startLocation, boolean searchForward) {
        int line = startLocation.getIndex().intValue() + 1;
        int col = startLocation.getCol();
        LinePosition lp = new LinePosition(line, col);
        Map.Entry<LinePosition, DecompilerSearchLocation> entry = searchForward ? this.matchesByPosition.ceilingEntry(lp) : this.matchesByPosition.floorEntry(lp);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private record LinePosition(int line, int col) implements Comparable<LinePosition>
    {
        @Override
        public int compareTo(LinePosition other) {
            int result = this.line - other.line;
            if (result != 0) {
                return result;
            }
            return this.col - other.col;
        }
    }

    private class ActivateFunctionJob
    extends SearchResults.ActivationJob {
        private ActivateFunctionJob() {
            super((SearchResults)DecompilerSearchResults.this);
        }

        protected void doRun(TaskMonitor monitor) throws CancelledException {
            if (DecompilerSearchResults.this.isMyFunction()) {
                return;
            }
            DecompilerController controller = DecompilerSearchResults.this.decompilerPanel.getController();
            Program program = DecompilerSearchResults.this.programLocation.getProgram();
            controller.refreshDisplay(program, DecompilerSearchResults.this.programLocation, null);
        }
    }
}

