/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.GFilterTable;
import docking.widgets.table.RowObjectTableModel;
import generic.jar.ResourceFile;
import ghidra.app.analyzers.FunctionStartAnalyzer;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.Analyzer;
import ghidra.bitpatterns.gui.ClipboardPatternFactory;
import ghidra.bitpatterns.gui.ExportPatternFileActionListener;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.ImportPatternFileActionListener;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.gui.PatternInfoTableModel;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternEvalRowObject;
import ghidra.bitpatterns.info.PatternEvaluationStats;
import ghidra.bitpatterns.info.PatternMatchType;
import ghidra.bitpatterns.info.PatternType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.util.Msg;
import ghidra.util.bytesearch.AlignRule;
import ghidra.util.bytesearch.BulkPatternSearcher;
import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PatternFactory;
import ghidra.util.bytesearch.PatternPairSet;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClipboardPanel
extends JPanel {
    private static final int BITS_PER_BYTE = 8;
    private JPanel buttonPanel;
    private PatternInfoTableModel patternInfoTable;
    private FunctionBitPatternsExplorerPlugin plugin;
    private GFilterTable<PatternInfoRowObject> filterTable;
    private Map<Integer, Integer> indexToSize;
    private HashMap<DittedBitSequence, ContextRegisterFilter> sequenceToCRegFilter;
    private boolean onlyPrePatterns;

    public ClipboardPanel(FunctionBitPatternsExplorerPlugin plugin) {
        BoxLayout mainLayout = new BoxLayout(this, 1);
        this.setLayout(mainLayout);
        this.plugin = plugin;
        this.patternInfoTable = new PatternInfoTableModel(plugin);
        this.filterTable = new GFilterTable((RowObjectTableModel)this.patternInfoTable);
        this.buildButtonPanel();
        this.add((Component)this.filterTable);
        this.add(this.buttonPanel);
        this.indexToSize = new HashMap<Integer, Integer>();
        this.sequenceToCRegFilter = new HashMap();
    }

    private void buildButtonPanel() {
        this.buttonPanel = new JPanel(new FlowLayout());
        JButton deletedButton = new JButton("Remove Selected Patterns");
        deletedButton.addActionListener(e -> {
            List selected = this.filterTable.getSelectedRowObjects();
            this.plugin.removePatterns(selected);
            this.updateClipboard();
        });
        this.buttonPanel.add(deletedButton);
        JButton sendToAnalyzerButton = new JButton("Create Functions from Selection");
        sendToAnalyzerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Program currentProgram = ClipboardPanel.this.plugin.getCurrentProgram();
                if (currentProgram == null) {
                    Msg.showWarn((Object)this, (Component)ClipboardPanel.this.getParent(), (String)"Open Program", (Object)"Please open a program");
                    return;
                }
                List selected = ClipboardPanel.this.patternInfoTable.getLastSelectedObjects();
                ArrayList<Pattern> patternList = ClipboardPanel.this.getPatternList(selected);
                if (patternList.isEmpty()) {
                    return;
                }
                if (ClipboardPanel.this.onlyPrePatterns) {
                    Msg.showWarn((Object)this, (Component)ClipboardPanel.this.getParent(), (String)"No Post Pattern", (Object)"Selected patterns must contain at least one post pattern");
                    return;
                }
                FunctionStartAnalyzer funcStartAnalyzer = new FunctionStartAnalyzer();
                for (Pattern pattern : patternList) {
                    MatchAction[] actions = ClipboardPanel.this.getMatchActions(funcStartAnalyzer, pattern);
                    pattern.setMatchActions(actions);
                }
                BulkPatternSearcher searcher = new BulkPatternSearcher(patternList);
                funcStartAnalyzer.setExplicitState((BulkPatternSearcher<Pattern>)searcher);
                AutoAnalysisManager autoManager = AutoAnalysisManager.getAnalysisManager((Program)currentProgram);
                autoManager.scheduleOneTimeAnalysis((Analyzer)funcStartAnalyzer, currentProgram.getMemory().getExecuteSet());
            }
        });
        this.buttonPanel.add(sendToAnalyzerButton);
        JButton exportButton = new JButton("Export Selected to Pattern File");
        exportButton.addActionListener(new ExportPatternFileActionListener(this, this.getParent()));
        this.buttonPanel.add(exportButton);
        JButton importButton = new JButton("Import Patterns From File");
        importButton.addActionListener(new ImportPatternFileActionListener(this.plugin, this));
        this.buttonPanel.add(importButton);
    }

    protected static PatternPairSet parsePatternPairSet(ResourceFile xmlFile) throws FileNotFoundException, IOException, SAXException {
        NonThreadedXmlPullParserImpl parser;
        PatternPairSet pairSet = null;
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw new SAXException("Error: " + String.valueOf(exception));
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw new SAXException("Fatal error: " + String.valueOf(exception));
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw new SAXException("Warning: " + String.valueOf(exception));
            }
        };
        try (InputStream inputStream = xmlFile.getInputStream();){
            parser = new NonThreadedXmlPullParserImpl(inputStream, xmlFile.getName(), handler, false);
        }
        parser.start(new String[]{"patternlist"});
        XmlElement el = parser.peek();
        while (el.isStart()) {
            if (el.getName().equals("patternpairs")) {
                pairSet = new PatternPairSet();
                pairSet.restoreXml((XmlPullParser)parser, (PatternFactory)new ClipboardPatternFactory());
            }
            el = parser.peek();
        }
        parser.end();
        return pairSet;
    }

    private MatchAction[] getMatchActions(FunctionStartAnalyzer funcStartAnalyzer, Pattern pattern) {
        ContextRegisterFilter cRegFilter = this.sequenceToCRegFilter.get(pattern);
        if (cRegFilter == null) {
            MatchAction[] actions = new MatchAction[1];
            actions[0] = funcStartAnalyzer.new FunctionStartAnalyzer.FunctionStartAction();
            return actions;
        }
        Map<String, BigInteger> regsToValues = cRegFilter.getValueMap();
        MatchAction[] actions = new MatchAction[1 + regsToValues.size()];
        actions[0] = funcStartAnalyzer.new FunctionStartAnalyzer.FunctionStartAction();
        int matchIndex = 1;
        for (String register : regsToValues.keySet()) {
            BigInteger value = regsToValues.get(register);
            FunctionStartAnalyzer functionStartAnalyzer = funcStartAnalyzer;
            Objects.requireNonNull(functionStartAnalyzer);
            actions[matchIndex] = functionStartAnalyzer.new FunctionStartAnalyzer.ContextAction(register, value);
            ++matchIndex;
        }
        return actions;
    }

    public PatternEvaluationStats evaluatePatterns(List<PatternInfoRowObject> rows) {
        ArrayList<Pattern> patternList = this.getPatternList(rows);
        if (this.onlyPrePatterns) {
            Msg.showWarn((Object)this, (Component)this, (String)"Only Pre-Patterns", (Object)"Only Pre-Patterns in selection: no true/false positive information will be calculated.");
        }
        BulkPatternSearcher searcher = new BulkPatternSearcher(patternList);
        this.indexToSize.clear();
        for (Pattern pattern : patternList) {
            this.indexToSize.put(pattern.getIndex(), pattern.getSize());
        }
        Program currentProgram = this.plugin.getCurrentProgram();
        MemoryBlock[] blocks = currentProgram.getMemory().getBlocks();
        PatternEvaluationStats matchStats = new PatternEvaluationStats();
        for (MemoryBlock block : blocks) {
            if (!block.isInitialized() || !block.isExecute()) continue;
            this.searchBlock((BulkPatternSearcher<Pattern>)searcher, block, matchStats, currentProgram, TaskMonitor.DUMMY);
        }
        return matchStats;
    }

    private void searchBlock(BulkPatternSearcher<Pattern> searcher, MemoryBlock block, PatternEvaluationStats matchStats, Program program, TaskMonitor monitor) {
        ArrayList mymatches = new ArrayList();
        try {
            searcher.search(block.getData(), mymatches, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (monitor.isCancelled()) {
            return;
        }
        for (int i = 0; i < mymatches.size(); ++i) {
            Match match = (Match)mymatches.get(i);
            if (this.onlyPrePatterns) {
                this.evaluatePrePatternMatch((Match<Pattern>)match, program, block, matchStats);
                continue;
            }
            this.evaluateMatch((Match<Pattern>)match, program, block, matchStats);
        }
    }

    private void evaluatePrePatternMatch(Match<Pattern> match, Program program, MemoryBlock block, PatternEvaluationStats matchStats) {
        Address blockStart = block.getStart();
        Pattern pattern = (Pattern)match.getPattern();
        Address matchStart = blockStart.add(match.getStart());
        Address funcStart = matchStart.add((long)this.indexToSize.get(pattern.getIndex()).intValue());
        Address patternEnd = funcStart.add(-1L);
        int totalBits = pattern.getNumFixedBits();
        int postBits = 0;
        PatternEvalRowObject rowObject = new PatternEvalRowObject(PatternMatchType.PRE_PATTERN_HIT, (AddressSetView)new AddressSet(matchStart, patternEnd), pattern.getHexString(), funcStart, postBits, totalBits);
        matchStats.addRowObject(rowObject);
    }

    private void evaluateMatch(Match<Pattern> match, Program program, MemoryBlock block, PatternEvaluationStats matchStats) {
        Address blockStart = block.getStart();
        int alignment = program.getLanguage().getInstructionAlignment();
        Address matchStart = blockStart.add(match.getStart());
        if (matchStart.getOffset() % (long)alignment != 0L) {
            return;
        }
        long streamoffset = blockStart.getOffset();
        Pattern pattern = (Pattern)match.getPattern();
        if (!pattern.checkPostRules(streamoffset)) {
            return;
        }
        Address matchEnd = matchStart.add((long)(this.indexToSize.get(pattern.getIndex()) - 1));
        Address funcStart = blockStart.add(match.getStart() + (long)pattern.getMarkOffset());
        ContextRegisterFilter cRegFilter = this.sequenceToCRegFilter.get(pattern);
        int totalBits = pattern.getNumFixedBits();
        int postBits = this.getNumPostBits(pattern);
        int index = (totalBits - postBits) / 8 - 1;
        PatternMatchType type = this.getMatchType(program, funcStart, cRegFilter);
        PatternEvalRowObject rowObject = new PatternEvalRowObject(type, (AddressSetView)new AddressSet(matchStart, matchEnd), this.addSeparator(pattern.getHexString(), index), funcStart, postBits, totalBits);
        matchStats.addRowObject(rowObject);
    }

    private int getNumPostBits(Pattern pattern) {
        int marked = pattern.getMarkOffset();
        if (marked == 0) {
            return pattern.getNumFixedBits();
        }
        return pattern.getNumFixedBits() - pattern.getNumInitialFixedBits(marked);
    }

    private PatternMatchType getMatchType(Program program, Address funcStart, ContextRegisterFilter cRegFilter) {
        boolean passes;
        if (cRegFilter != null && !(passes = this.passesFilter(program, funcStart, cRegFilter))) {
            return PatternMatchType.CONTEXT_CONFLICT;
        }
        CodeUnit cu = program.getListing().getCodeUnitContaining(funcStart);
        if (cu instanceof Data && ((Data)cu).isDefined()) {
            return PatternMatchType.FP_DATA;
        }
        if (program.getFunctionManager().getFunctionAt(funcStart) != null) {
            return PatternMatchType.TRUE_POSITIVE;
        }
        if (program.getListing().getInstructionContaining(funcStart) == null) {
            return PatternMatchType.POSSIBLE_START_UNDEFINED;
        }
        Instruction instruction = program.getListing().getInstructionAt(funcStart);
        if (instruction == null) {
            return PatternMatchType.FP_MISALIGNED;
        }
        BasicBlockModel bModel = new BasicBlockModel(program);
        boolean initialBlock = bModel.isBlockStart(instruction);
        if (initialBlock) {
            try {
                CodeBlock cBlock = bModel.getCodeBlockAt(funcStart, TaskMonitor.DUMMY);
                CodeBlockReferenceIterator refIter = bModel.getSources(cBlock, TaskMonitor.DUMMY);
                if (refIter != null) {
                    while (refIter.hasNext()) {
                        CodeBlockReference cbRef = refIter.next();
                        if (cbRef.getFlowType().equals((Object)RefType.UNCONDITIONAL_JUMP)) continue;
                        initialBlock = false;
                    }
                }
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
        if (initialBlock) {
            return PatternMatchType.POSSIBLE_START_CODE;
        }
        return PatternMatchType.FP_WRONG_FLOW;
    }

    private String addSeparator(String match, int index) {
        String[] parts = match.trim().split(" ");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            sb.append(" ");
            if (i != index) continue;
            sb.append("*");
            sb.append(" ");
        }
        return sb.toString();
    }

    private boolean passesFilter(Program program, Address funcStart, ContextRegisterFilter cRegFilter) {
        Map<String, BigInteger> valueMap = cRegFilter.getValueMap();
        for (String register : valueMap.keySet()) {
            BigInteger value = valueMap.get(register);
            if (value == null) continue;
            Register reg = program.getRegister(register);
            RegisterValue regValue = program.getProgramContext().getNonDefaultValue(reg, funcStart);
            if (regValue == null) {
                return true;
            }
            BigInteger existingValue = regValue.getUnsignedValue();
            if (value.equals(existingValue)) continue;
            return false;
        }
        return true;
    }

    public void updateClipboard() {
        this.remove((Component)this.filterTable);
        this.filterTable.dispose();
        this.patternInfoTable = new PatternInfoTableModel(this.plugin);
        this.filterTable = new GFilterTable((RowObjectTableModel)this.patternInfoTable);
        this.add((Component)this.filterTable, 0);
        this.updateUI();
    }

    private ArrayList<Pattern> getPatternList(List<PatternInfoRowObject> rows) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        ArrayList<PatternInfoRowObject> prePatterns = new ArrayList<PatternInfoRowObject>();
        ArrayList<PatternInfoRowObject> postPatterns = new ArrayList<PatternInfoRowObject>();
        this.sequenceToCRegFilter.clear();
        for (PatternInfoRowObject row : rows) {
            if (row.getPatternType().equals((Object)PatternType.FIRST)) {
                postPatterns.add(row);
                continue;
            }
            prePatterns.add(row);
        }
        if (postPatterns.size() == 0) {
            for (PatternInfoRowObject row : rows) {
                patternList.add(new Pattern(row.getDittedBitSequence(), 0, new PostRule[0], new MatchAction[0]));
            }
            this.onlyPrePatterns = true;
            return patternList;
        }
        this.onlyPrePatterns = false;
        if (prePatterns.size() == 0) {
            for (PatternInfoRowObject row : rows) {
                patternList.add(new Pattern(row.getDittedBitSequence(), 0, this.getAlignRule(null, row), new MatchAction[0]));
                this.sequenceToCRegFilter.put(row.getDittedBitSequence(), row.getContextRegisterFilter());
            }
            return patternList;
        }
        for (PatternInfoRowObject prePattern : prePatterns) {
            for (PatternInfoRowObject postPattern : postPatterns) {
                DittedBitSequence pair = new DittedBitSequence(prePattern.getDittedBitSequence());
                pair = pair.concatenate(postPattern.getDittedBitSequence());
                PostRule[] postRules = this.getAlignRule(prePattern, postPattern);
                patternList.add(new Pattern(pair, prePattern.getDittedBitSequence().getSize(), postRules, new MatchAction[0]));
                this.sequenceToCRegFilter.put(pair, postPattern.getContextRegisterFilter());
            }
        }
        return patternList;
    }

    private PostRule[] getAlignRule(PatternInfoRowObject prePattern, PatternInfoRowObject postPattern) {
        Integer alignment;
        int mark = 0;
        if (prePattern != null) {
            mark = prePattern.getDittedBitSequence().getSize();
        }
        if ((alignment = postPattern.getAlignment()) != null && alignment > 0) {
            AlignRule alignRule = new AlignRule(mark, alignment - 1);
            return new PostRule[]{alignRule};
        }
        return new PostRule[0];
    }

    public List<PatternInfoRowObject> getLastSelectedObjects() {
        return this.patternInfoTable.getLastSelectedObjects();
    }

    public void dispose() {
        this.filterTable.dispose();
    }
}

