#!/bin/bash

# this script is ran automatically; there should be no need to run this manually (however you could)
#  used in .github/workflows/build.yml to generate docs/hashcat-help.md and docs/hashcat-example-hashes.md on every commit to master

set -euo pipefail

echo "If you're running this manually: make sure you have a fresh build; otherwise the wrong docs will be generated!"
echo " make clean && make -s"

echo "Start generate_docs.sh"

# Run --help and save to ../../docs/hashcat-help.md
echo 'These docs are automatically generated by Github Actions see .github/workflows/build.yml \' > ../../docs/hashcat-help.md
echo 'All manual changes will be overwritten!' >> ../../docs/hashcat-help.md
echo '```' >> ../../docs/hashcat-help.md
./../../hashcat --help >> ../../docs/hashcat-help.md
echo '```' >> ../../docs/hashcat-help.md

# Run --example-hashes and save to ../../docs/hashcat-example-hashes.md
echo 'These docs are automatically generated by Github Actions see .github/workflows/build.yml \' > ../../docs/hashcat-example-hashes.md
echo 'All manual changes will be overwritten!' >> ../../docs/hashcat-example-hashes.md
echo '| Hash-mode | Hash-name | Kernels | Test | Example |' >> ../../docs/hashcat-example-hashes.md
echo '|:-----------|:-----------|:-----------|:-----------|:---------------|' >> ../../docs/hashcat-example-hashes.md
./../../hashcat --example-hashes --machine-readable --quiet | python3 ./hashcat-example-hashes_machine-readable2md.py >> ../../docs/hashcat-example-hashes.md

echo "Done generate_docs.sh"
