// Copyright 2022 CFC4N <cfc4n.cs@gmail.com>. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package hkdf

import (
	"crypto"
	_ "crypto/sha256"
	_ "crypto/sha512"
	"testing"
)

func TestHkdf(t *testing.T) {
	t.Log("TestHkdf")
	//TODO
	var length int
	var transcript crypto.Hash
	var cipherId uint32 = 50336513
	// test with different cipherID
	switch uint16(cipherId & 0x0000FFFF) {
	case TlsAes128GcmSha256, TlsChacha20Poly1305Sha256:
		length = 32
		transcript = crypto.SHA256
	case TlsAes256GcmSha384:
		length = 48
		transcript = crypto.SHA384
	default:
		t.Log("Unknown cipher")
	}

	// HandshakeSecret
	handshakeSecret := []byte{0x33, 0xad, 0x0a, 0x1c, 0x60, 0x7e, 0xc0, 0x3b, 0x09, 0xe6, 0xcd, 0x98, 0x93, 0x68, 0x0c, 0xe2, 0x10, 0xad, 0xf3, 0x00, 0xaa, 0x1f, 0x26, 0x60, 0xe1, 0xb2, 0x2e, 0x10, 0xf1, 0x70, 0xf9, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	// MasterSecret
	masterSecret := []byte{0x95, 0x8a, 0x8a, 0xfc, 0xa1, 0x12, 0x34, 0xac, 0x64, 0xf5, 0x9b, 0x09, 0xb3, 0xd2, 0xaf, 0xbb, 0xd3, 0xe8, 0x46, 0x4d, 0xce, 0xa5, 0x27, 0x6d, 0x30, 0xd4, 0x26, 0x85, 0x5a, 0x7a, 0xde, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	// HandshakeTrafficHash
	handshakeTrafficHash := []byte{0x89, 0xf6, 0x4d, 0x87, 0xef, 0xf1, 0x30, 0x91, 0xfb, 0xa9, 0x9f, 0x20, 0x20, 0xb5, 0x16, 0xf9, 0x3a, 0x4a, 0xc4, 0x51, 0x6a, 0xd2, 0x6a, 0x94, 0x62, 0x04, 0x27, 0xe4, 0xe9, 0xa1, 0xd5, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	// ServerFinishedHash
	serverFinishedHash := []byte{0x75, 0x28, 0xcb, 0x64, 0x54, 0xfb, 0x4c, 0xab, 0xbc, 0x00, 0x6a, 0x64, 0x01, 0xaa, 0xc6, 0xf3, 0x7f, 0x7d, 0xa0, 0x82, 0x72, 0x66, 0xc0, 0x6c, 0x5b, 0xbd, 0x96, 0x91, 0x02, 0xac, 0xf6, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	// ExporterMasterSecret
	exporterMasterSecret := []byte{0x7d, 0x43, 0x64, 0x4b, 0xfa, 0x10, 0x38, 0x66, 0x18, 0x54, 0xac, 0x12, 0xff, 0x72, 0x6c, 0xcf, 0x26, 0xbe, 0x8d, 0x80, 0x8c, 0xf2, 0x0b, 0x16, 0x05, 0x71, 0xb1, 0xd4, 0xd4, 0xab, 0x5e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}

	clientHandshakeSecret := ExpandLabel(handshakeSecret[:length],
		ClientHandshakeTrafficLabel, handshakeTrafficHash[:length], length, transcript)
	t.Logf("%s: %x", KeyLogLabelClientHandshake, clientHandshakeSecret)

	serverHandshakeSecret := ExpandLabel(handshakeSecret[:length],
		ServerHandshakeTrafficLabel, handshakeTrafficHash[:length], length, transcript)
	t.Logf("%s: %x", KeyLogLabelServerHandshake, serverHandshakeSecret)

	clientTrafficSecret := ExpandLabel(masterSecret[:length],
		ClientApplicationTrafficLabel, serverFinishedHash[:length], length, transcript)
	t.Logf("%s: %x", KeyLogLabelClientTraffic, clientTrafficSecret)

	serverTrafficSecret := ExpandLabel(masterSecret[:length],
		ServerApplicationTrafficLabel, serverFinishedHash[:length], length, transcript)
	t.Logf("%s: %x", KeyLogLabelServerTraffic, serverTrafficSecret)

	t.Logf("%s: %x", KeyLogLabelExporterSecret, exporterMasterSecret[:length])
}
