---
name: receiving-code-review
description: 适用于接收代码评审反馈后、实施建议前的场景，尤其当反馈内容模糊或存在技术争议时——要求秉持技术严谨性开展验证，而非表面附和或盲目执行
---

# 代码评审反馈处理规范
## 概述
代码评审的核心是技术层面的评估分析，而非情绪化的表面回应。

**核心原则**：实施前先验证，存疑时先询问，技术正确性优先于沟通表面的融洽。

## 标准处理流程
```
接收代码评审反馈后，按以下步骤执行：

1. 通读：完整阅读所有反馈，不急于做出任何反应
2. 确认：用自己的话重述需求（若理解有偏差则直接询问）
3. 验证：结合代码库实际情况核查反馈合理性
4. 评估：判断该建议是否适用于**当前**代码库的技术场景
5. 回应：以技术视角确认接收，或基于合理依据提出异议
6. 实施：逐条落实建议，每完成一项即开展测试
```

## 禁止使用的回应方式
**绝对不要**：
- 「你说得完全正确！」（明确违反CLAUDE.md规范）
- 「这个点提得好！」/「反馈太到位了！」（表面化的附和表述）
- 「我现在就去实现」（未完成验证前切勿表态）

**正确的做法**：
- 重述反馈中的技术要求
- 提出针对性的澄清问题
- 若建议存在错误，基于技术依据提出异议
- 直接开展实操（行动远胜于言辞）

## 模糊反馈的处理方式
```
若反馈中存在任何模糊不清的条目：
  立即暂停——切勿开展任何实施工作
  针对模糊条目向反馈方请求澄清

原因：各条目可能存在关联，部分理解必然导致错误的实施结果。
```

**示例**：
```
协作人：「修复1-6项问题」
你仅理解1、2、3、6项，对4、5项存在疑问。

❌ 错误做法：先实现1、2、3、6项，后续再询问4、5项
✅ 正确做法：「我已理解1、2、3、6项内容，需先澄清4、5项问题，再推进后续工作。」
```

## 按反馈来源区分的处理方式
### 来自协作人的反馈
- 具备可信度——理解需求后即可实施
- 若需求范围模糊，仍需主动询问
- 杜绝表面化附和
- 可直接开展行动，或仅做技术层面的确认

### 来自外部评审者的反馈
```
实施建议前，完成以下核查：
  1. 核查：该建议是否适用于**当前**代码库的技术场景？
  2. 核查：是否会破坏现有功能？
  3. 核查：当前实现方案的设计初衷？
  4. 核查：是否能在所有平台/版本上正常运行？
  5. 核查：评审者是否了解功能的完整业务背景？

若建议存在明显问题：
  基于技术依据提出异议

若无法快速验证建议合理性：
  如实说明：「缺少[X]条件，无法验证该建议。我是否需要[开展调研/进一步询问/继续推进]？」

若建议与协作人此前的决策存在冲突：
  立即暂停，先与协作人沟通确认
```

**协作人定规**：「对待外部反馈，保持质疑态度，同时开展细致核查。」

## 针对「专业级」功能的YAGNI原则核查
```
若评审者建议「按标准规范实现」某功能：
  在代码库中检索该功能的实际调用情况

  若未被调用：「该接口暂无调用记录，是否按YAGNI原则移除？」
  若存在调用：再按标准规范实施
```

**协作人定规**：「你与评审者均向我负责。若本项目无需该功能，切勿新增。」
> 注：YAGNI = You Aren't Gonna Need It，即「你不会需要它」，核心为拒绝过度开发。

## 建议实施的优先级排序
```
针对包含多项内容的反馈：
  1. 优先澄清所有模糊不清的条目
  2. 按以下优先级实施：
     - 阻塞性问题（功能崩溃、安全漏洞）
     - 简单修复项（拼写错误、导入问题）
     - 复杂修复项（代码重构、逻辑调整）
  3. 对每项修复单独开展测试
  4. 验证修复后无回归问题
```

## 提出异议的适用场景
出现以下情况，可对评审反馈提出异议：
- 建议会破坏现有功能的正常运行
- 评审者未掌握功能的完整业务背景
- 建议违反YAGNI原则（针对未被使用的功能）
- 建议不符合当前技术栈的技术规范
- 存在历史兼容/版本兼容的硬性要求
- 建议与协作人确定的架构决策相冲突

**提出异议的正确方式**：
- 基于技术依据阐述，避免防御性表述
- 提出具体、针对性的问题
- 引用可用的测试用例/现有代码作为依据
- 若涉及架构层面问题，及时让协作人介入

**若不便公开提出异议，可发送暗号**：「Circle K处出现异常情况」

## 正确反馈的确认方式
当评审反馈确认为正确时：
```
✅ 「已修复。【简要说明修改内容】」
✅ 「发现问题——【具体问题描述】，已在【文件/代码位置】修复。」
✅ 直接修复问题，在代码中体现修改结果

❌ 「你说得完全正确！」
❌ 「这个点提得好！」
❌ 「感谢指出这个问题！」
❌ 「感谢【任何内容】」
❌ 任何形式的感谢表述
```

**不使用感谢的原因**：行动即是最好的回应，只需做好修复即可。代码的修改结果，本身就证明你已接收并落实反馈。

**若下意识想要输入「感谢」**：直接删除，替换为对修复内容的陈述。

## 异议表述有误后的修正方式
若你曾对反馈提出异议，后发现自身判断错误：
```
✅ 「你是对的——我核查了[X]，确实存在[Y]问题，正在实施修复。」
✅ 「经验证，你的建议正确。我最初理解有误，原因是[具体原因]，正在修复。」

❌ 长篇大论的道歉
❌ 为自己此前的异议行为辩解
❌ 过度解释错误原因
```
如实陈述修正结果，随后立即开展修复工作即可。

## 常见错误及修正方案
| 常见错误 | 修正方案 |
|---------|-----|
| 表面化附和反馈 | 重述技术需求，或直接开展实操 |
| 盲目执行建议 | 先结合代码库实际情况开展验证 |
| 批量实施未做单独测试 | 逐条实施，完成一项即测试一项 |
| 默认评审者的建议完全正确 | 核查建议是否会破坏现有功能 |
| 回避提出合理异议 | 牢记技术正确性优先于沟通融洽 |
| 部分理解即开展实施 | 先澄清所有模糊条目，再推进工作 |
| 无法验证仍强行推进 | 说明验证限制，请求行动指示 |

## 实际案例参考
### 表面化附和（错误示例）：
```
评审者：「移除遗留代码」
❌ 「你说得完全正确！我这就去移除……」
```

### 技术验证（正确示例）：
```
评审者：「移除遗留代码」
✅ 「正在核查……项目编译目标为10.15+，但该API要求13+运行环境，遗留代码用于向下兼容。当前实现的Bundle ID存在错误——是修复该问题，还是放弃13以下版本的支持？」
```

### YAGNI原则应用（正确示例）：
```
评审者：「基于数据库实现标准化的指标追踪，包含日期筛选、CSV导出功能」
✅ 「已在代码库中检索——该接口暂无任何调用记录。是否按YAGNI原则移除？还是存在我未发现的调用场景？」
```

### 模糊条目处理（正确示例）：
```
协作人：「修复1-6项问题」
你仅理解1、2、3、6项，对4、5项存在疑问。
✅ 「已理解1、2、3、6项内容，需先澄清4、5项问题，再开展实施。」
```

## GitHub评审线程回复规范
在GitHub上回复行内评审评论时，需在对应评论线程中回复（调用命令：`gh api repos/{owner}/{repo}/pulls/{pr}/comments/{id}/replies`），切勿作为合并请求的顶层评论回复。

## 核心准则
**外部反馈仅为待评估的建议，而非必须执行的指令。**

先验证，再质疑，最后再实施。

拒绝表面化附和，始终保持技术严谨性。