---
name: finishing-a-development-branch
description: 适用于功能开发完成、所有测试均通过，且需要确定代码集成方式的场景 - 提供标准化的合并、创建合并请求或清理选项，指导完成开发收尾工作
---

# 完成开发分支的收尾工作

## 概述
通过展示清晰的操作选项并执行选定的工作流，指导完成开发工作的收尾流程。

**核心原则**：验证测试 → 展示选项 → 执行选定操作 → 环境清理。

**开始时需声明**：「我将使用 finishing-a-development-branch 技能完成此项工作。」

## 执行流程

### 步骤 1：验证测试用例
**展示操作选项前，必须先验证所有测试通过**：

```bash
# 运行项目的完整测试套件
npm test / cargo test / pytest / go test ./...
```

**若测试失败**，执行以下操作：
```
测试执行失败（共 <N> 处失败项）。收尾工作前必须修复问题：

[此处展示具体失败详情]

测试通过前，无法继续执行合并/创建合并请求操作。
```
立即终止流程，不进入步骤 2。

**若测试通过**：继续执行步骤 2。

### 步骤 2：确认基准分支
```bash
# 自动检测常用的基准分支
git merge-base HEAD main 2>/dev/null || git merge-base HEAD master 2>/dev/null
```
若自动检测失败，需询问：「当前分支是从 main 分支创建，是否无误？」

### 步骤 3：展示操作选项
**必须严格展示以下4项固定选项，无其他额外选项**：

```
功能开发已全部完成，你希望执行以下哪项操作？

1. 在本地将当前分支合并至 <基准分支名>
2. 推送分支并创建合并请求（Pull Request）
3. 保留当前分支不变（后续由我自行处理）
4. 舍弃本次开发的所有内容

请选择操作序号：
```

**要求**：无需附加任何解释说明，保持选项简洁即可。

### 步骤 4：执行选定的操作

#### 选项 1：本地合并分支
```bash
# 切换至基准分支
git checkout <base-branch>

# 拉取基准分支最新代码
git pull

# 合并当前功能分支
git merge <feature-branch>

# 对合并后的代码结果，重新验证测试用例
<test command>

# 若测试通过，删除已合并的功能分支
git branch -d <feature-branch>
```
执行完成后 → 进入「清理工作区」环节（步骤 5）

#### 选项 2：推送分支并创建合并请求
```bash
# 推送当前功能分支到远程仓库并关联上游分支
git push -u origin <feature-branch>

# 创建合并请求
gh pr create --title "<标题>" --body "$(cat <<'EOF'
## 功能概述
<用2-3条项目符号说明本次代码变更内容>

## 测试方案
- [ ] <填写测试验证步骤>
EOF
)"
```
执行完成后 → 进入「清理工作区」环节（步骤 5）

#### 选项 3：保留分支不变
反馈内容：「已保留分支 <分支名称>，对应的工作区文件已原样保存在路径 <path>。」

**注意**：此选项下**不执行任何工作区清理操作**。

#### 选项 4：舍弃本次开发内容
**执行前必须先确认**，确认话术如下：
```
该操作将永久删除以下内容，且无法恢复：
- 分支 <分支名称>
- 该分支下的所有提交记录：<commit-list>
- 对应路径 <path> 的工作区文件

请输入「discard」确认执行该操作。
```
等待用户输入精准的确认指令后，方可执行。

确认无误后执行命令：
```bash
git checkout <base-branch>
git branch -D <feature-branch>
```
执行完成后 → 进入「清理工作区」环节（步骤 5）

### 步骤 5：清理工作区
**仅针对「选项1、选项2、选项4」执行本步骤**：

先检查当前分支是否关联独立工作区：
```bash
git worktree list | grep $(git branch --show-current)
```
若检测到关联的工作区，执行清理：
```bash
git worktree remove <worktree-path>
```

**针对「选项3」**：保留所有工作区文件，不执行清理。

---

## 速查参考表

| 操作选项 | 执行合并 | 推送代码 | 保留工作区 | 清理分支 |
|--------|-------|------|---------------|----------------|
| 1. 本地合并分支 | ✔️ | ✖️ | ✖️ | ✔️ |
| 2. 创建合并请求 | ✖️ | ✔️ | ✔️ | ✖️ |
| 3. 保留分支不变 | ✖️ | ✖️ | ✔️ | ✖️ |
| 4. 舍弃开发内容 | ✖️ | ✖️ | ✖️ | ✔️（强制删除） |

---

## 常见错误事项

### 跳过测试验证环节
- **问题危害**：合并存在缺陷的代码、创建包含失败用例的合并请求
- **修正方案**：提供任何操作选项前，必须先完成测试验证

### 提出无边界的模糊问题
- **问题危害**：例如询问「接下来我该做什么？」，会导致指令模糊、无法推进
- **修正方案**：严格展示本文档规定的4项标准化选项，无其他变体

### 自动清理所有场景的工作区
- **问题危害**：在「选项2、选项3」的场景下清理工作区，可能导致后续需要复用文件时无法找回
- **修正方案**：仅在「选项1、选项4」的场景下执行工作区清理

### 执行舍弃操作前未做确认
- **问题危害**：误删已完成的开发内容，且无法恢复
- **修正方案**：必须要求用户输入「discard」指令做精准确认，方可执行删除

---

## 红线规则（严禁违规操作）

### ❌ 绝对禁止
- 测试用例执行失败时，继续推进后续任何操作
- 合并分支后，未对合并结果重新验证测试就结束流程
- 未经确认，直接删除开发分支或工作区内容
- 无明确指令的情况下，执行强制推送（force-push）操作

### ✅ 必须遵守
- 提供操作选项前，完成全量测试验证
- 严格展示且仅展示本文档规定的4项操作选项
- 执行「选项4 舍弃内容」时，必须获取用户的文字确认指令
- 仅对「选项1、选项4」执行工作区清理操作，其余场景均保留

---

## 技能关联关系

### 被以下技能调用
- **subagent-driven-development**（子代理驱动开发）- 步骤7，所有开发任务完成后触发
- **executing-plans**（执行计划）- 步骤5，所有批次任务执行完毕后触发

### 配套协同技能
- **using-git-worktrees**（使用Git工作区）- 专门清理由该技能创建的独立工作区目录