// Auto generated by formatgen on Sep 21 2019
#pragma once
#if !defined(TINYIMAGEFORMAT_ENCODE_H_) && !defined(TINYIMAGEFORMAT_IMAGEFORMAT_H)
#define TINYIMAGEFORMAT_ENCODE_H_ 1

#include "../../../../../Utilities/Math/MathTypes.h"

#include "tinyimageformat_base.h"

#if __cplusplus > 201402L
#define TIF_CONSTEXPR constexpr
#else
#define TIF_CONSTEXPR
#endif
#ifndef  TinyImageFormat_HAVE_BOOL
#include <stdbool.h>	// for bool
#endif

//Float2Half from Rygorous public domain code
inline uint16_t TinyImageFormat_FloatToHalfAsUint(float f_) {
	union {
		uint16_t u;
		struct {
			uint16_t Mantissa : 10;
			uint16_t Exponent : 5;
			uint16_t Sign : 1;
		};
	} o;

	union {
		uint32_t u;
		float f;
		struct {
			uint32_t Mantissa : 23;
			uint32_t Exponent : 8;
			uint32_t Sign : 1;
		};
	} f;

	static uint32_t const f32infty = {255 << 23};
	static uint32_t const f16max = {(127 + 16) << 23};
	static uint32_t const denorm_magicU = {((127 - 15) + (23 - 10) + 1) << 23};
	static uint32_t const sign_mask = 0x80000000u;

	float const denorm_magic = *(float const*)(&denorm_magicU);

	o.u = 0;
	f.f = f_;

	uint32_t const sign = f.u & sign_mask;
	f.u ^= sign;

	// NOTE all the integer compares in this function can be safely
	// compiled into signed compares since all operands are below
	// 0x80000000. Important if you want fast straight SSE2 code
	// (since there's no unsigned PCMPGTD).

	if (f.u >= f16max) { // result is Inf or NaN (all exponent bits set)
		o.u = (f.u > f32infty) ? 0x7e00 : 0x7c00; // NaN->qNaN and Inf->Inf
	} else // (De)normalized number or zero
	{
		if (f.u < (113 << 23)) // resulting FP16 is subnormal or zero
		{
			// use a magic value to align our 10 mantissa bits at the bottom of
			// the float. as long as FP addition is round-to-nearest-even this
			// just works.
			f.f += denorm_magic;

			// and one integer subtract of the bias later, we have our final float!
			o.u = f.u - denorm_magicU;
		} else {
			uint32_t mant_odd = (f.u >> 13) & 1; // resulting mantissa is odd

			// update exponent, rounding bias part 1
			f.u += 0xc8000fff;
			// rounding bias part 2
			f.u += mant_odd;
			// take the bits!
			o.u = f.u >> 13;
		}
	}

	o.u |= sign >> 16;
	return o.u;
}

inline uint16_t TinyImageFormat_FloatToBFloatAsUint(float v) {
	union {
		struct {
			uint16_t x;
			uint16_t u;
		};
		float f;
	} o;

	o.f = v;
	o.x = 0;

	return o.u;
}

inline void TinyImageFormat_FloatRGBToRGB9E5AsUint32(float const* in, uint32_t* out) {
	float const r = in[0];
	float const g = in[1];
	float const b = in[2];
	float const v = r > g ? r > b ? r : b : g > b ? g : b;


	union
	{
		struct
		{
			uint32_t rm : 9;
			uint32_t gm : 9;
			uint32_t bm : 9;
			uint32_t e  : 5;
		};
		uint32_t v;
	} ei;

	if (v < 1.52587890625e-5f) {
		*out = 0;
	} else if (v < 65536) {
		int ex;
		float m = frexpf(v, &ex) * 512.0f / v;

		ei.rm = (uint32_t)(m * r);
		ei.gm = (uint32_t)(m * g);
		ei.bm = (uint32_t)(m * b);
		ei.e = (unsigned int) (ex + 15);
		*out = ei.v;
	} else {
		ei.rm = (r < 65536) ? (uint32_t)(r * (1.0f / 128.0f)) : 0x1FF;
		ei.gm = (g < 65536) ? (uint32_t)(g * (1.0f / 128.0f)) : 0x1FF;
		ei.bm = (b < 65536) ? (uint32_t)(b * (1.0f / 128.0f)) : 0x1FF;
		ei.e = 31;
		*out = ei.v;
	}
}

inline uint16_t TinyImageFormat_FloatToUFloat6AsUint(float Value)
{
		uint32_t IValue = *((uint32_t *)&Value);

		if (IValue & 0x80000000U)
		{
				// Positive only
				return 0;
		}
		else if (IValue > 0x43FEFFFFU)
		{
				// The number is too large to be represented as a 6e4. Saturate.
				return 0x3FFU;
		}
		else
		{
				if (IValue < 0x3C800000U)
				{
						// The number is too small to be represented as a normalized 6e4.
						// Convert it to a denormalized value.
						uint32_t Shift = 121U - (IValue >> 23U);
						if(Shift < 24U) Shift = 24U;

						IValue = (0x800000U | (IValue & 0x7FFFFFU)) >> Shift;
				}
				else
				{
						// Rebias the exponent to represent the value as a normalized 6e4.
						IValue += 0xC4000000U;
				}

				return (uint16_t)(((IValue + 0xFFFFU + ((IValue >> 17U) & 1U)) >> 17U) & 0x3FFU);
		}
}

inline uint16_t TinyImageFormat_FloatToUFloat7AsUint(float Value)
{
		uint32_t IValue = *((uint32_t *)&Value);

		if (IValue & 0x80000000U)
		{
				// Positive only
				return 0;
		}
		else if (IValue > 0x41FF73FFU)
		{
				// The number is too large to be represented as a 7e3. Saturate.
				return 0x3FFU;
		}
		else
		{
				if (IValue < 0x3E800000U)
				{
						// The number is too small to be represented as a normalized 7e3.
						// Convert it to a denormalized value.
						uint32_t Shift = 125U - (IValue >> 23U);
						if(Shift < 24U) Shift = 24U;

						IValue = (0x800000U | (IValue & 0x7FFFFFU)) >> Shift;
				}
				else
				{
						// Rebias the exponent to represent the value as a normalized 7e3.
						IValue += 0xC2000000U;
				}

				return (uint16_t)(((IValue + 0x7FFFU + ((IValue >> 16U) & 1U)) >> 16U) & 0x3FFU);
		}
}

inline uint16_t TinyImageFormat_FloatToUFloat10AsUint(float v) {
	union {
		uint32_t u;
		float f;
		struct {
			uint32_t Mantissa : 23;
			uint32_t Exponent : 8;
			uint32_t Sign : 1;
		};
	} o;
	union {
		struct {
			uint16_t e : 5;
			uint16_t m : 5;
			uint16_t x : 6; // not used
		};
		uint16_t v;
	} ei;

	o.f = v;
	ei.v = 0;

	//  positive only, so clamp to zero
	if(o.Sign) return 0;

	// 5-bit exponent, 5-bit mantissa

	// INF or NAN
	if (o.Exponent == 0xFF) {
		if ( o.Mantissa != 0) {
			return  0x3e0 | (((o.u>>18)|(o.u>>11)|(o.u>>6)|(o.u))&0x3f);
		} else {
			return 0x3e0;
		}
	} else if (o.u > 0x477C0000U) {
		// The number is too large to be represented as a float10, set to max
		return 0x3df;
	}
	else if (o.u < 0x38800000U) {
		// The number is too small to be represented as a normalized float11
		// Convert it to a denormalized value.
		ei.e = 0;
		ei.m = o.Mantissa >> (113U - o.Exponent);
	} else {
		// Rebias the exponent to represent the value as a normalized float11
		ei.e = o.Exponent + 16;
		ei.m = o.Mantissa >> 18;
	}

	return ei.v;
}

inline uint16_t TinyImageFormat_FloatToUFloat11AsUint(float v) {
    union {
        uint32_t u;
        float f;
        struct {
            uint32_t Mantissa : 23;
            uint32_t Exponent : 8;
            uint32_t Sign : 1;
        };
    } o;
	union {
		struct {
			uint16_t e : 5;
			uint16_t m : 6;
			uint16_t x : 5; // not used
		};
		uint16_t v;
	} ei;

	o.f = v;
	ei.v = 0;

	//  positive only, so clamp to zero
	if(o.Sign) return 0;

	// 5-bit exponent, 6-bit mantissa)

	// INF or NAN
	if (o.Exponent == 0xFF) {
		if ( o.Mantissa != 0) {
				return  0x7c0 | (((o.u>>17)|(o.u>>11)|(o.u>>6)|(o.u))&0x3f);
		} else {
				return 0x7c0;
		}
	} else if (o.u > 0x477C0000U) {
		// The number is too large to be represented as a float11, set to max
		return 0x7BF;
	}
	else if (o.u < 0x38800000U) {
		// The number is too small to be represented as a normalized float11
		// Convert it to a denormalized value.
		ei.e = 0;
		ei.m = o.Mantissa >> (113U - o.Exponent);
	} else {
		// Rebias the exponent to represent the value as a normalized float11
		ei.e = o.Exponent + 16;
		ei.m = o.Mantissa >> 17;
	}

	return ei.v;
}

TIF_CONSTEXPR inline bool TinyImageFormat_CanEncodeLogicalPixelsF(TinyImageFormat const fmt) {
	switch(fmt) {
		case TinyImageFormat_R1_UNORM: return true;
		case TinyImageFormat_R2_UNORM: return true;
		case TinyImageFormat_R4_UNORM: return true;
		case TinyImageFormat_R4G4_UNORM: return true;
		case TinyImageFormat_G4R4_UNORM: return true;
		case TinyImageFormat_A8_UNORM: return true;
		case TinyImageFormat_R8_UNORM: return true;
		case TinyImageFormat_R8_SNORM: return true;
		case TinyImageFormat_R8_UINT: return true;
		case TinyImageFormat_R8_SINT: return true;
		case TinyImageFormat_R8_SRGB: return true;
		case TinyImageFormat_B2G3R3_UNORM: return true;
		case TinyImageFormat_R4G4B4A4_UNORM: return true;
		case TinyImageFormat_R4G4B4X4_UNORM: return true;
		case TinyImageFormat_B4G4R4A4_UNORM: return true;
		case TinyImageFormat_B4G4R4X4_UNORM: return true;
		case TinyImageFormat_A4R4G4B4_UNORM: return true;
		case TinyImageFormat_X4R4G4B4_UNORM: return true;
		case TinyImageFormat_A4B4G4R4_UNORM: return true;
		case TinyImageFormat_X4B4G4R4_UNORM: return true;
		case TinyImageFormat_R5G6B5_UNORM: return true;
		case TinyImageFormat_B5G6R5_UNORM: return true;
		case TinyImageFormat_R5G5B5A1_UNORM: return true;
		case TinyImageFormat_B5G5R5A1_UNORM: return true;
		case TinyImageFormat_A1B5G5R5_UNORM: return true;
		case TinyImageFormat_A1R5G5B5_UNORM: return true;
		case TinyImageFormat_R5G5B5X1_UNORM: return true;
		case TinyImageFormat_B5G5R5X1_UNORM: return true;
		case TinyImageFormat_X1R5G5B5_UNORM: return true;
		case TinyImageFormat_X1B5G5R5_UNORM: return true;
		case TinyImageFormat_B2G3R3A8_UNORM: return true;
		case TinyImageFormat_R8G8_UNORM: return true;
		case TinyImageFormat_R8G8_SNORM: return true;
		case TinyImageFormat_G8R8_UNORM: return true;
		case TinyImageFormat_G8R8_SNORM: return true;
		case TinyImageFormat_R8G8_UINT: return true;
		case TinyImageFormat_R8G8_SINT: return true;
		case TinyImageFormat_R8G8_SRGB: return true;
		case TinyImageFormat_R16_UNORM: return true;
		case TinyImageFormat_R16_SNORM: return true;
		case TinyImageFormat_R16_UINT: return true;
		case TinyImageFormat_R16_SINT: return true;
		case TinyImageFormat_R16_SFLOAT: return true;
		case TinyImageFormat_R16_SBFLOAT: return true;
		case TinyImageFormat_R8G8B8_UNORM: return true;
		case TinyImageFormat_R8G8B8_SNORM: return true;
		case TinyImageFormat_R8G8B8_UINT: return true;
		case TinyImageFormat_R8G8B8_SINT: return true;
		case TinyImageFormat_R8G8B8_SRGB: return true;
		case TinyImageFormat_B8G8R8_UNORM: return true;
		case TinyImageFormat_B8G8R8_SNORM: return true;
		case TinyImageFormat_B8G8R8_UINT: return true;
		case TinyImageFormat_B8G8R8_SINT: return true;
		case TinyImageFormat_B8G8R8_SRGB: return true;
		case TinyImageFormat_R8G8B8A8_UNORM: return true;
		case TinyImageFormat_R8G8B8A8_SNORM: return true;
		case TinyImageFormat_R8G8B8A8_UINT: return true;
		case TinyImageFormat_R8G8B8A8_SINT: return true;
		case TinyImageFormat_R8G8B8A8_SRGB: return true;
		case TinyImageFormat_B8G8R8A8_UNORM: return true;
		case TinyImageFormat_B8G8R8A8_SNORM: return true;
		case TinyImageFormat_B8G8R8A8_UINT: return true;
		case TinyImageFormat_B8G8R8A8_SINT: return true;
		case TinyImageFormat_B8G8R8A8_SRGB: return true;
		case TinyImageFormat_R8G8B8X8_UNORM: return true;
		case TinyImageFormat_B8G8R8X8_UNORM: return true;
		case TinyImageFormat_R16G16_UNORM: return true;
		case TinyImageFormat_G16R16_UNORM: return true;
		case TinyImageFormat_R16G16_SNORM: return true;
		case TinyImageFormat_G16R16_SNORM: return true;
		case TinyImageFormat_R16G16_UINT: return true;
		case TinyImageFormat_R16G16_SINT: return true;
		case TinyImageFormat_R16G16_SFLOAT: return true;
		case TinyImageFormat_R16G16_SBFLOAT: return true;
		case TinyImageFormat_R32_UINT: return true;
		case TinyImageFormat_R32_SINT: return true;
		case TinyImageFormat_R32_SFLOAT: return true;
		case TinyImageFormat_A2R10G10B10_UNORM: return true;
		case TinyImageFormat_A2R10G10B10_UINT: return true;
		case TinyImageFormat_A2R10G10B10_SNORM: return true;
		case TinyImageFormat_A2R10G10B10_SINT: return true;
		case TinyImageFormat_A2B10G10R10_UNORM: return true;
		case TinyImageFormat_A2B10G10R10_UINT: return true;
		case TinyImageFormat_A2B10G10R10_SNORM: return true;
		case TinyImageFormat_A2B10G10R10_SINT: return true;
		case TinyImageFormat_R10G10B10A2_UNORM: return true;
		case TinyImageFormat_R10G10B10A2_UINT: return true;
		case TinyImageFormat_R10G10B10A2_SNORM: return true;
		case TinyImageFormat_R10G10B10A2_SINT: return true;
		case TinyImageFormat_B10G10R10A2_UNORM: return true;
		case TinyImageFormat_B10G10R10A2_UINT: return true;
		case TinyImageFormat_B10G10R10A2_SNORM: return true;
		case TinyImageFormat_B10G10R10A2_SINT: return true;
		case TinyImageFormat_B10G11R11_UFLOAT: return true;
		case TinyImageFormat_E5B9G9R9_UFLOAT: return true;
		case TinyImageFormat_R16G16B16_UNORM: return true;
		case TinyImageFormat_R16G16B16_SNORM: return true;
		case TinyImageFormat_R16G16B16_UINT: return true;
		case TinyImageFormat_R16G16B16_SINT: return true;
		case TinyImageFormat_R16G16B16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16_SBFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_UNORM: return true;
		case TinyImageFormat_R16G16B16A16_SNORM: return true;
		case TinyImageFormat_R16G16B16A16_UINT: return true;
		case TinyImageFormat_R16G16B16A16_SINT: return true;
		case TinyImageFormat_R16G16B16A16_SFLOAT: return true;
		case TinyImageFormat_R16G16B16A16_SBFLOAT: return true;
		case TinyImageFormat_R32G32_UINT: return true;
		case TinyImageFormat_R32G32_SINT: return true;
		case TinyImageFormat_R32G32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32_UINT: return true;
		case TinyImageFormat_R32G32B32_SINT: return true;
		case TinyImageFormat_R32G32B32_SFLOAT: return true;
		case TinyImageFormat_R32G32B32A32_UINT: return true;
		case TinyImageFormat_R32G32B32A32_SINT: return true;
		case TinyImageFormat_R32G32B32A32_SFLOAT: return true;
		default: return false;
		}
	}

TIF_CONSTEXPR inline bool TinyImageFormat_EncodeLogicalPixelsF(TinyImageFormat const fmt, float const *in, uint32_t const width, TinyImageFormat_EncodeOutput * out) {
	switch(fmt) {
		case TinyImageFormat_R1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[0] * 1.00f) & 0x1) << 0;
				*op0 |= ((uint8_t)(in[4] * 1.00f) & 0x1) << 1;
				*op0 |= ((uint8_t)(in[8] * 1.00f) & 0x1) << 2;
				*op0 |= ((uint8_t)(in[12] * 1.00f) & 0x1) << 3;
				*op0 |= ((uint8_t)(in[16] * 1.00f) & 0x1) << 4;
				*op0 |= ((uint8_t)(in[20] * 1.00f) & 0x1) << 5;
				*op0 |= ((uint8_t)(in[24] * 1.00f) & 0x1) << 6;
				*op0 |= ((uint8_t)(in[28] * 1.00f) & 0x1) << 7;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=32;
			}
			return true;
		case TinyImageFormat_R2_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[0] * 3.00f) & 0x3) << 0;
				*op0 |= ((uint8_t)(in[4] * 3.00f) & 0x3) << 2;
				*op0 |= ((uint8_t)(in[8] * 3.00f) & 0x3) << 4;
				*op0 |= ((uint8_t)(in[12] * 3.00f) & 0x3) << 6;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=16;
			}
			return true;
		case TinyImageFormat_R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[0] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint8_t)(in[4] * 15.00f) & 0xf) << 4;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=8;
			}
			return true;
		case TinyImageFormat_R4G4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[0] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint8_t)(in[1] * 15.00f) & 0xf) << 4;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_G4R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[1] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint8_t)(in[0] * 15.00f) & 0xf) << 4;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[3] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[0] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((int8_t)(in[0] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint8_t)in[0]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= (((int8_t)in[0]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)linearToSrgbf((float)in[0])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B2G3R3_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[2] * 3.00f) & 0x3) << 0;
				*op0 |= ((uint8_t)(in[1] * 7.00f) & 0x7) << 2;
				*op0 |= ((uint8_t)(in[0] * 7.00f) & 0x7) << 5;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R4G4B4A4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 4;
				*op0 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 8;
				*op0 |= ((uint16_t)(in[3] * 15.00f) & 0xf) << 12;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R4G4B4X4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 4;
				*op0 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B4G4R4A4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 4;
				*op0 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 8;
				*op0 |= ((uint16_t)(in[3] * 15.00f) & 0xf) << 12;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B4G4R4X4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 4;
				*op0 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A4R4G4B4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[3] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 4;
				*op0 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 8;
				*op0 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 12;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_X4R4G4B4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 4;
				*op1 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 8;
				*op1 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 12;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A4B4G4R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[3] * 15.00f) & 0xf) << 0;
				*op0 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 4;
				*op0 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 8;
				*op0 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 12;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_X4B4G4R4_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)(in[2] * 15.00f) & 0xf) << 4;
				*op1 |= ((uint16_t)(in[1] * 15.00f) & 0xf) << 8;
				*op1 |= ((uint16_t)(in[0] * 15.00f) & 0xf) << 12;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R5G6B5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 0;
				*op0 |= ((uint16_t)(in[1] * 63.00f) & 0x3f) << 5;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 11;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B5G6R5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 0;
				*op0 |= ((uint16_t)(in[1] * 63.00f) & 0x3f) << 5;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 11;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R5G5B5A1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 0;
				*op0 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 5;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 10;
				*op0 |= ((uint16_t)(in[3] * 1.00f) & 0x1) << 15;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B5G5R5A1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 0;
				*op0 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 5;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 10;
				*op0 |= ((uint16_t)(in[3] * 1.00f) & 0x1) << 15;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A1B5G5R5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[3] * 1.00f) & 0x1) << 0;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 1;
				*op0 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 6;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 11;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A1R5G5B5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[3] * 1.00f) & 0x1) << 0;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 1;
				*op0 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 6;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 11;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R5G5B5X1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 0;
				*op0 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 5;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 10;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B5G5R5X1_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 0;
				*op0 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 5;
				*op0 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 10;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_X1R5G5B5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 1;
				*op1 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 6;
				*op1 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 11;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_X1B5G5R5_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)(in[2] * 31.00f) & 0x1f) << 1;
				*op1 |= ((uint16_t)(in[1] * 31.00f) & 0x1f) << 6;
				*op1 |= ((uint16_t)(in[0] * 31.00f) & 0x1f) << 11;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B2G3R3A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[2] * 3.00f) & 0x3) << 0;
				*op0 |= ((uint16_t)(in[1] * 7.00f) & 0x7) << 2;
				*op0 |= ((uint16_t)(in[0] * 7.00f) & 0x7) << 5;
				*op0 |= ((uint16_t)(in[3] * 255.00f) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 255.00f) & 0xff) << 0;
				*op0 |= ((uint16_t)(in[1] * 255.00f) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((int16_t)(in[0] * 127.00f) & 0xff) << 0;
				*op0 |= ((int16_t)(in[1] * 127.00f) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_G8R8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[1] * 255.00f) & 0xff) << 0;
				*op0 |= ((uint16_t)(in[0] * 255.00f) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_G8R8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((int16_t)(in[1] * 127.00f) & 0xff) << 0;
				*op0 |= ((int16_t)(in[0] * 127.00f) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint16_t)in[0]) & 0xff) << 0;
				*op0 |= (((uint16_t)in[1]) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= (((int16_t)in[0]) & 0xff) << 0;
				*op0 |= (((int16_t)in[1]) & 0xff) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)linearToSrgbf((float)in[0])) << 0;
				*op0 |= ((uint16_t)linearToSrgbf((float)in[1])) << 8;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 65535.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((int16_t)(in[0] * 32767.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint16_t)in[0]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= (((int16_t)in[0]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)TinyImageFormat_FloatToHalfAsUint((float)in[0])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)TinyImageFormat_FloatToBFloatAsUint((float)in[0])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[0] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint8_t)(in[1] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint8_t)(in[2] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((int8_t)(in[0] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= ((int8_t)(in[1] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= ((int8_t)(in[2] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint8_t)in[0]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint8_t)in[1]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint8_t)in[2]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= (((int8_t)in[0]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= (((int8_t)in[1]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= (((int8_t)in[2]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)linearToSrgbf((float)in[0])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint8_t)linearToSrgbf((float)in[1])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint8_t)linearToSrgbf((float)in[2])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)(in[2] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint8_t)(in[1] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint8_t)(in[0] * 255.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((int8_t)(in[2] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= ((int8_t)(in[1] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= ((int8_t)(in[0] * 127.00f) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint8_t)in[2]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint8_t)in[1]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint8_t)in[0]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= (((int8_t)in[2]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= (((int8_t)in[1]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= (((int8_t)in[0]) & 0xff) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				uint8_t* op0 = (uint8_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint8_t)linearToSrgbf((float)in[2])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op1 = (uint8_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint8_t)linearToSrgbf((float)in[1])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				uint8_t* op2 = (uint8_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint8_t)linearToSrgbf((float)in[0])) << 0;
				out->pixel = (void*)(((uint8_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[0] * 255.00f) & 0xff) << 0;
				*op0 |= ((uint32_t)(in[1] * 255.00f) & 0xff) << 8;
				*op0 |= ((uint32_t)(in[2] * 255.00f) & 0xff) << 16;
				*op0 |= ((uint32_t)(in[3] * 255.00f) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8A8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[0] * 127.00f) & 0xff) << 0;
				*op0 |= ((int32_t)(in[1] * 127.00f) & 0xff) << 8;
				*op0 |= ((int32_t)(in[2] * 127.00f) & 0xff) << 16;
				*op0 |= ((int32_t)(in[3] * 127.00f) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8A8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[0]) & 0xff) << 0;
				*op0 |= (((uint32_t)in[1]) & 0xff) << 8;
				*op0 |= (((uint32_t)in[2]) & 0xff) << 16;
				*op0 |= (((uint32_t)in[3]) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8A8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[0]) & 0xff) << 0;
				*op0 |= (((int32_t)in[1]) & 0xff) << 8;
				*op0 |= (((int32_t)in[2]) & 0xff) << 16;
				*op0 |= (((int32_t)in[3]) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8A8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)linearToSrgbf((float)in[0])) << 0;
				*op0 |= ((uint32_t)linearToSrgbf((float)in[1])) << 8;
				*op0 |= ((uint32_t)linearToSrgbf((float)in[2])) << 16;
				*op0 |= ((uint32_t)(in[3] * 255.00f) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8A8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[2] * 255.00f) & 0xff) << 0;
				*op0 |= ((uint32_t)(in[1] * 255.00f) & 0xff) << 8;
				*op0 |= ((uint32_t)(in[0] * 255.00f) & 0xff) << 16;
				*op0 |= ((uint32_t)(in[3] * 255.00f) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8A8_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[2] * 127.00f) & 0xff) << 0;
				*op0 |= ((int32_t)(in[1] * 127.00f) & 0xff) << 8;
				*op0 |= ((int32_t)(in[0] * 127.00f) & 0xff) << 16;
				*op0 |= ((int32_t)(in[3] * 127.00f) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8A8_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[2]) & 0xff) << 0;
				*op0 |= (((uint32_t)in[1]) & 0xff) << 8;
				*op0 |= (((uint32_t)in[0]) & 0xff) << 16;
				*op0 |= (((uint32_t)in[3]) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8A8_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[2]) & 0xff) << 0;
				*op0 |= (((int32_t)in[1]) & 0xff) << 8;
				*op0 |= (((int32_t)in[0]) & 0xff) << 16;
				*op0 |= (((int32_t)in[3]) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8A8_SRGB:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)linearToSrgbf((float)in[2])) << 0;
				*op0 |= ((uint32_t)linearToSrgbf((float)in[1])) << 8;
				*op0 |= ((uint32_t)linearToSrgbf((float)in[0])) << 16;
				*op0 |= ((uint32_t)(in[3] * 255.00f) & 0xff) << 24;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R8G8B8X8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[0] * 255.00f) & 0xff) << 0;
				*op0 |= ((uint32_t)(in[1] * 255.00f) & 0xff) << 8;
				*op0 |= ((uint32_t)(in[2] * 255.00f) & 0xff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B8G8R8X8_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[2] * 255.00f) & 0xff) << 0;
				*op0 |= ((uint32_t)(in[1] * 255.00f) & 0xff) << 8;
				*op0 |= ((uint32_t)(in[0] * 255.00f) & 0xff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[0] * 65535.00f) & 0xffff) << 0;
				*op0 |= ((uint32_t)(in[1] * 65535.00f) & 0xffff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_G16R16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[1] * 65535.00f) & 0xffff) << 0;
				*op0 |= ((uint32_t)(in[0] * 65535.00f) & 0xffff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[0] * 32767.00f) & 0xffff) << 0;
				*op0 |= ((int32_t)(in[1] * 32767.00f) & 0xffff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_G16R16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[1] * 32767.00f) & 0xffff) << 0;
				*op0 |= ((int32_t)(in[0] * 32767.00f) & 0xffff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[0]) & 0xffff) << 0;
				*op0 |= (((uint32_t)in[1]) & 0xffff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[0]) & 0xffff) << 0;
				*op0 |= (((int32_t)in[1]) & 0xffff) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToHalfAsUint((float)in[0])) << 0;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToHalfAsUint((float)in[1])) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToBFloatAsUint((float)in[0])) << 0;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToBFloatAsUint((float)in[1])) << 16;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[0]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[0]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				float in0 = (float)in[0];
				*op0 |= ((uint32_t)*((uint32_t*)&in0)) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[3] * 3.00f) & 0x3) << 0;
				*op0 |= ((uint32_t)(in[0] * 1023.00f) & 0x3ff) << 2;
				*op0 |= ((uint32_t)(in[1] * 1023.00f) & 0x3ff) << 12;
				*op0 |= ((uint32_t)(in[2] * 1023.00f) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[3]) & 0x3) << 0;
				*op0 |= (((uint32_t)in[0]) & 0x3ff) << 2;
				*op0 |= (((uint32_t)in[1]) & 0x3ff) << 12;
				*op0 |= (((uint32_t)in[2]) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[3] * 1.00f) & 0x3) << 0;
				*op0 |= ((int32_t)(in[0] * 511.00f) & 0x3ff) << 2;
				*op0 |= ((int32_t)(in[1] * 511.00f) & 0x3ff) << 12;
				*op0 |= ((int32_t)(in[2] * 511.00f) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2R10G10B10_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[3]) & 0x3) << 0;
				*op0 |= (((int32_t)in[0]) & 0x3ff) << 2;
				*op0 |= (((int32_t)in[1]) & 0x3ff) << 12;
				*op0 |= (((int32_t)in[2]) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[3] * 3.00f) & 0x3) << 0;
				*op0 |= ((uint32_t)(in[2] * 1023.00f) & 0x3ff) << 2;
				*op0 |= ((uint32_t)(in[1] * 1023.00f) & 0x3ff) << 12;
				*op0 |= ((uint32_t)(in[0] * 1023.00f) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[3]) & 0x3) << 0;
				*op0 |= (((uint32_t)in[2]) & 0x3ff) << 2;
				*op0 |= (((uint32_t)in[1]) & 0x3ff) << 12;
				*op0 |= (((uint32_t)in[0]) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[3] * 1.00f) & 0x3) << 0;
				*op0 |= ((int32_t)(in[2] * 511.00f) & 0x3ff) << 2;
				*op0 |= ((int32_t)(in[1] * 511.00f) & 0x3ff) << 12;
				*op0 |= ((int32_t)(in[0] * 511.00f) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_A2B10G10R10_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[3]) & 0x3) << 0;
				*op0 |= (((int32_t)in[2]) & 0x3ff) << 2;
				*op0 |= (((int32_t)in[1]) & 0x3ff) << 12;
				*op0 |= (((int32_t)in[0]) & 0x3ff) << 22;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[0] * 1023.00f) & 0x3ff) << 0;
				*op0 |= ((uint32_t)(in[1] * 1023.00f) & 0x3ff) << 10;
				*op0 |= ((uint32_t)(in[2] * 1023.00f) & 0x3ff) << 20;
				*op0 |= ((uint32_t)(in[3] * 3.00f) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[0]) & 0x3ff) << 0;
				*op0 |= (((uint32_t)in[1]) & 0x3ff) << 10;
				*op0 |= (((uint32_t)in[2]) & 0x3ff) << 20;
				*op0 |= (((uint32_t)in[3]) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[0] * 511.00f) & 0x3ff) << 0;
				*op0 |= ((int32_t)(in[1] * 511.00f) & 0x3ff) << 10;
				*op0 |= ((int32_t)(in[2] * 511.00f) & 0x3ff) << 20;
				*op0 |= ((int32_t)(in[3] * 1.00f) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R10G10B10A2_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[0]) & 0x3ff) << 0;
				*op0 |= (((int32_t)in[1]) & 0x3ff) << 10;
				*op0 |= (((int32_t)in[2]) & 0x3ff) << 20;
				*op0 |= (((int32_t)in[3]) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)(in[2] * 1023.00f) & 0x3ff) << 0;
				*op0 |= ((uint32_t)(in[1] * 1023.00f) & 0x3ff) << 10;
				*op0 |= ((uint32_t)(in[0] * 1023.00f) & 0x3ff) << 20;
				*op0 |= ((uint32_t)(in[3] * 3.00f) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[2]) & 0x3ff) << 0;
				*op0 |= (((uint32_t)in[1]) & 0x3ff) << 10;
				*op0 |= (((uint32_t)in[0]) & 0x3ff) << 20;
				*op0 |= (((uint32_t)in[3]) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((int32_t)(in[2] * 511.00f) & 0x3ff) << 0;
				*op0 |= ((int32_t)(in[1] * 511.00f) & 0x3ff) << 10;
				*op0 |= ((int32_t)(in[0] * 511.00f) & 0x3ff) << 20;
				*op0 |= ((int32_t)(in[3] * 1.00f) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B10G10R10A2_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[2]) & 0x3ff) << 0;
				*op0 |= (((int32_t)in[1]) & 0x3ff) << 10;
				*op0 |= (((int32_t)in[0]) & 0x3ff) << 20;
				*op0 |= (((int32_t)in[3]) & 0x3) << 30;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_B10G11R11_UFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToUFloat10AsUint((float)in[2])) << 0;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToUFloat11AsUint((float)in[1])) << 10;
				*op0 |= ((uint32_t)TinyImageFormat_FloatToUFloat11AsUint((float)in[0])) << 21;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_E5B9G9R9_UFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				TinyImageFormat_FloatRGBToRGB9E5AsUint32( (float const*)in, (uint32_t*)out->pixel);
				out->pixel = (void const*)(((uint32_t const*)out->pixel) + 1);
				in += 4;
			}
			return true;
		case TinyImageFormat_R16G16B16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)(in[0] * 65535.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)(in[1] * 65535.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op2 = (uint16_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint16_t)(in[2] * 65535.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((int16_t)(in[0] * 32767.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((int16_t)(in[1] * 32767.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op2 = (uint16_t*)out->pixel; *op2 = 0;
				*op2 |= ((int16_t)(in[2] * 32767.00f) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint16_t)in[0]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint16_t)in[1]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op2 = (uint16_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint16_t)in[2]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= (((int16_t)in[0]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= (((int16_t)in[1]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op2 = (uint16_t*)out->pixel; *op2 = 0;
				*op2 |= (((int16_t)in[2]) & 0xffff) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)TinyImageFormat_FloatToHalfAsUint((float)in[0])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)TinyImageFormat_FloatToHalfAsUint((float)in[1])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op2 = (uint16_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint16_t)TinyImageFormat_FloatToHalfAsUint((float)in[2])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint16_t* op0 = (uint16_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint16_t)TinyImageFormat_FloatToBFloatAsUint((float)in[0])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op1 = (uint16_t*)out->pixel; *op1 = 0;
				*op1 |= ((uint16_t)TinyImageFormat_FloatToBFloatAsUint((float)in[1])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				uint16_t* op2 = (uint16_t*)out->pixel; *op2 = 0;
				*op2 |= ((uint16_t)TinyImageFormat_FloatToBFloatAsUint((float)in[2])) << 0;
				out->pixel = (void*)(((uint16_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16A16_UNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint64_t)(in[0] * 65535.00f) & 0xffff) << 0;
				*op0 |= ((uint64_t)(in[1] * 65535.00f) & 0xffff) << 16;
				*op0 |= ((uint64_t)(in[2] * 65535.00f) & 0xffff) << 32;
				*op0 |= ((uint64_t)(in[3] * 65535.00f) & 0xffff) << 48;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SNORM:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= ((int64_t)(in[0] * 32767.00f) & 0xffff) << 0;
				*op0 |= ((int64_t)(in[1] * 32767.00f) & 0xffff) << 16;
				*op0 |= ((int64_t)(in[2] * 32767.00f) & 0xffff) << 32;
				*op0 |= ((int64_t)(in[3] * 32767.00f) & 0xffff) << 48;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16A16_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0xffff) << 0;
				*op0 |= (((uint64_t)in[1]) & 0xffff) << 16;
				*op0 |= (((uint64_t)in[2]) & 0xffff) << 32;
				*op0 |= (((uint64_t)in[3]) & 0xffff) << 48;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0xffff) << 0;
				*op0 |= (((int64_t)in[1]) & 0xffff) << 16;
				*op0 |= (((int64_t)in[2]) & 0xffff) << 32;
				*op0 |= (((int64_t)in[3]) & 0xffff) << 48;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToHalfAsUint((float)in[0])) << 0;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToHalfAsUint((float)in[1])) << 16;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToHalfAsUint((float)in[2])) << 32;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToHalfAsUint((float)in[3])) << 48;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R16G16B16A16_SBFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToBFloatAsUint((float)in[0])) << 0;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToBFloatAsUint((float)in[1])) << 16;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToBFloatAsUint((float)in[2])) << 32;
				*op0 |= ((uint64_t)TinyImageFormat_FloatToBFloatAsUint((float)in[3])) << 48;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0xffffffff) << 0;
				*op0 |= (((uint64_t)in[1]) & 0xffffffff) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0xffffffff) << 0;
				*op0 |= (((int64_t)in[1]) & 0xffffffff) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				float in0 = (float)in[0];
				*op0 |= ((uint64_t)*((uint32_t*)&in0)) << 0;
				float in1 = (float)in[1];
				*op0 |= ((uint64_t)*((uint32_t*)&in1)) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32B32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint32_t)in[0]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				uint32_t* op1 = (uint32_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint32_t)in[1]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				uint32_t* op2 = (uint32_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint32_t)in[2]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32B32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				*op0 |= (((int32_t)in[0]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				uint32_t* op1 = (uint32_t*)out->pixel; *op1 = 0;
				*op1 |= (((int32_t)in[1]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				uint32_t* op2 = (uint32_t*)out->pixel; *op2 = 0;
				*op2 |= (((int32_t)in[2]) & 0xffffffff) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32B32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint32_t* op0 = (uint32_t*)out->pixel; *op0 = 0;
				float in0 = (float)in[0];
				*op0 |= ((uint32_t)*((uint32_t*)&in0)) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				uint32_t* op1 = (uint32_t*)out->pixel; *op1 = 0;
				float in1 = (float)in[1];
				*op1 |= ((uint32_t)*((uint32_t*)&in1)) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				uint32_t* op2 = (uint32_t*)out->pixel; *op2 = 0;
				float in2 = (float)in[2];
				*op2 |= ((uint32_t)*((uint32_t*)&in2)) << 0;
				out->pixel = (void*)(((uint32_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32B32A32_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0xffffffff) << 0;
				*op0 |= (((uint64_t)in[1]) & 0xffffffff) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint64_t)in[2]) & 0xffffffff) << 0;
				*op2 |= (((uint64_t)in[3]) & 0xffffffff) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32B32A32_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0xffffffff) << 0;
				*op0 |= (((int64_t)in[1]) & 0xffffffff) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				*op2 |= (((int64_t)in[2]) & 0xffffffff) << 0;
				*op2 |= (((int64_t)in[3]) & 0xffffffff) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R32G32B32A32_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				float in0 = (float)in[0];
				*op0 |= ((uint64_t)*((uint32_t*)&in0)) << 0;
				float in1 = (float)in[1];
				*op0 |= ((uint64_t)*((uint32_t*)&in1)) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				float in2 = (float)in[2];
				*op2 |= ((uint64_t)*((uint32_t*)&in2)) << 0;
				float in3 = (float)in[3];
				*op2 |= ((uint64_t)*((uint32_t*)&in3)) << 32;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		default: return false;
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_CanEncodeLogicalPixelsD(TinyImageFormat const fmt) {
	switch(fmt) {
		case TinyImageFormat_R64_UINT: return true;
		case TinyImageFormat_R64_SINT: return true;
		case TinyImageFormat_R64_SFLOAT: return true;
		case TinyImageFormat_R64G64_UINT: return true;
		case TinyImageFormat_R64G64_SINT: return true;
		case TinyImageFormat_R64G64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64_UINT: return true;
		case TinyImageFormat_R64G64B64_SINT: return true;
		case TinyImageFormat_R64G64B64_SFLOAT: return true;
		case TinyImageFormat_R64G64B64A64_UINT: return true;
		case TinyImageFormat_R64G64B64A64_SINT: return true;
		case TinyImageFormat_R64G64B64A64_SFLOAT: return true;
		default: return TinyImageFormat_CanEncodeLogicalPixelsF(fmt);
	}
}

TIF_CONSTEXPR inline bool TinyImageFormat_EncodeLogicalPixelsD(TinyImageFormat const fmt, double const *in, uint32_t const width, TinyImageFormat_EncodeOutput * out) {
	switch(fmt) {
		case TinyImageFormat_R64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				double in0 = (double)in[0];
				*op0 |= ((uint64_t)*((uint64_t*)&in0)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint64_t)in[1]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				*op1 |= (((int64_t)in[1]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				double in0 = (double)in[0];
				*op0 |= ((uint64_t)*((uint64_t*)&in0)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				double in1 = (double)in[1];
				*op1 |= ((uint64_t)*((uint64_t*)&in1)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64B64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint64_t)in[1]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint64_t)in[2]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64B64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				*op1 |= (((int64_t)in[1]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				*op2 |= (((int64_t)in[2]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64B64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				double in0 = (double)in[0];
				*op0 |= ((uint64_t)*((uint64_t*)&in0)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				double in1 = (double)in[1];
				*op1 |= ((uint64_t)*((uint64_t*)&in1)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				double in2 = (double)in[2];
				*op2 |= ((uint64_t)*((uint64_t*)&in2)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64B64A64_UINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((uint64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				*op1 |= (((uint64_t)in[1]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				*op2 |= (((uint64_t)in[2]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op3 = (uint64_t*)out->pixel; *op3 = 0;
				*op3 |= (((uint64_t)in[3]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64B64A64_SINT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				*op0 |= (((int64_t)in[0]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				*op1 |= (((int64_t)in[1]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				*op2 |= (((int64_t)in[2]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op3 = (uint64_t*)out->pixel; *op3 = 0;
				*op3 |= (((int64_t)in[3]) & 0x0) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		case TinyImageFormat_R64G64B64A64_SFLOAT:
			for(uint32_t w = 0; w < width; ++w) {
				uint64_t* op0 = (uint64_t*)out->pixel; *op0 = 0;
				double in0 = (double)in[0];
				*op0 |= ((uint64_t)*((uint64_t*)&in0)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op1 = (uint64_t*)out->pixel; *op1 = 0;
				double in1 = (double)in[1];
				*op1 |= ((uint64_t)*((uint64_t*)&in1)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op2 = (uint64_t*)out->pixel; *op2 = 0;
				double in2 = (double)in[2];
				*op2 |= ((uint64_t)*((uint64_t*)&in2)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				uint64_t* op3 = (uint64_t*)out->pixel; *op3 = 0;
				double in3 = (double)in[3];
				*op3 |= ((uint64_t)*((uint64_t*)&in3)) << 0;
				out->pixel = (void*)(((uint64_t*)out->pixel) + 1);
				in+=4;
			}
			return true;
		default:
		{
			bool ret = true;
			for(uint32_t w = 0; w < width && ret; ++w) {
				float inF[4] = {(float)in[0], (float)in[1], (float)in[2], (float)in[3]};
				ret = TinyImageFormat_EncodeLogicalPixelsF(fmt, inF, 1, out);
				in += 4;
			}
			return ret;
		}
	}
}

#undef TIF_CONSTEXPR
#endif // TINYIMAGEFORMAT_ENCODE_H_

