/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.messages;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class MessageUtil {
    private static final String CREATE_NODE_WITH_LABELS_DENIED = "Create node with labels '%s' on database '%s' is not allowed for %s.";
    private static final String WITH_USER = "user '%s' with %s";
    private static final String OVERRIDDEN_MODE = "%s overridden by %s";
    private static final String RESTRICTED_MODE = "%s restricted to %s";
    private static final String ALTER_TO_REMOTE = "Failed to alter the specified database alias '%s': alter a local alias to a remote alias is not supported.";
    private static final String FAILED_TO_READ_REMOTE_ALIAS_KEY = "Failed to read the symmetric key from the configured keystore";

    public static String createNodeWithLabelsDenied(String labels, String database, String user) {
        return String.format(CREATE_NODE_WITH_LABELS_DENIED, labels, database, user);
    }

    public static String authDisabled(String mode) {
        return "AUTH_DISABLED with " + mode;
    }

    public static String withUser(String user, String mode) {
        return String.format(WITH_USER, user, mode);
    }

    public static String overriddenMode(String original, String wrapping) {
        return String.format(OVERRIDDEN_MODE, original, wrapping);
    }

    public static String restrictedMode(String original, String wrapping) {
        return String.format(RESTRICTED_MODE, original, wrapping);
    }

    public static String standardMode(Set<String> roles) {
        TreeSet<String> sortedRoles = new TreeSet<String>(roles);
        return roles.isEmpty() ? "no roles" : "roles " + sortedRoles;
    }

    public static String alterToLocalAlias(String alias) {
        return String.format(ALTER_TO_REMOTE, alias);
    }

    public static String failedToFindEncryptionKeyInKeystore(String keyName) {
        return String.format("%s. The key '%s' was not found in the given keystore file.", FAILED_TO_READ_REMOTE_ALIAS_KEY, keyName);
    }

    public static String failedToReadRemoteAliasEncryptionKey(String ... settings) {
        return String.format("%s. Please verify the keystore configurations: %s.", FAILED_TO_READ_REMOTE_ALIAS_KEY, StringUtils.join((Object[])settings, ", "));
    }

    public static String failedToEncryptPassword() {
        return "Failed to encrypt remote user password.";
    }

    public static String failedToDecryptPassword() {
        return "Failed to decrypt remote user password.";
    }

    public static String invalidScheme(String url, List<String> schemes) {
        return String.format("The provided url '%s' has an invalid scheme. Please use one of the following schemes: %s.", url, StringUtils.join(schemes, ", "));
    }

    public static String insecureScheme(String url, List<String> schemes) {
        return String.format("The provided url '%s' is not a secure scheme. Please use one of the following schemes: %s.", url, StringUtils.join(schemes, ", "));
    }
}

