package org.openapitools.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;
import javax.annotation.Generated;

/**
 * TypeHolderExample
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.20.0-SNAPSHOT")
public class TypeHolderExample {

  private String stringItem;

  private BigDecimal numberItem;

  private Float floatItem;

  private Integer integerItem;

  private Boolean boolItem;

  @Valid
  private List<Integer> arrayItem = new ArrayList<>();

  public TypeHolderExample() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public TypeHolderExample(String stringItem, BigDecimal numberItem, Float floatItem, Integer integerItem, Boolean boolItem, List<Integer> arrayItem) {
    this.stringItem = stringItem;
    this.numberItem = numberItem;
    this.floatItem = floatItem;
    this.integerItem = integerItem;
    this.boolItem = boolItem;
    this.arrayItem = arrayItem;
  }

  public TypeHolderExample stringItem(String stringItem) {
    this.stringItem = stringItem;
    return this;
  }

  /**
   * Get stringItem
   * @return stringItem
   */
  @NotNull 
  @ApiModelProperty(example = "what", required = true, value = "")
  @JsonProperty("string_item")
  public String getStringItem() {
    return stringItem;
  }

  public void setStringItem(String stringItem) {
    this.stringItem = stringItem;
  }

  public TypeHolderExample numberItem(BigDecimal numberItem) {
    this.numberItem = numberItem;
    return this;
  }

  /**
   * Get numberItem
   * @return numberItem
   */
  @NotNull @Valid 
  @ApiModelProperty(example = "1.234", required = true, value = "")
  @JsonProperty("number_item")
  public BigDecimal getNumberItem() {
    return numberItem;
  }

  public void setNumberItem(BigDecimal numberItem) {
    this.numberItem = numberItem;
  }

  public TypeHolderExample floatItem(Float floatItem) {
    this.floatItem = floatItem;
    return this;
  }

  /**
   * Get floatItem
   * @return floatItem
   */
  @NotNull 
  @ApiModelProperty(example = "1.234", required = true, value = "")
  @JsonProperty("float_item")
  public Float getFloatItem() {
    return floatItem;
  }

  public void setFloatItem(Float floatItem) {
    this.floatItem = floatItem;
  }

  public TypeHolderExample integerItem(Integer integerItem) {
    this.integerItem = integerItem;
    return this;
  }

  /**
   * Get integerItem
   * @return integerItem
   */
  @NotNull 
  @ApiModelProperty(example = "-2", required = true, value = "")
  @JsonProperty("integer_item")
  public Integer getIntegerItem() {
    return integerItem;
  }

  public void setIntegerItem(Integer integerItem) {
    this.integerItem = integerItem;
  }

  public TypeHolderExample boolItem(Boolean boolItem) {
    this.boolItem = boolItem;
    return this;
  }

  /**
   * Get boolItem
   * @return boolItem
   */
  @NotNull 
  @ApiModelProperty(example = "true", required = true, value = "")
  @JsonProperty("bool_item")
  public Boolean getBoolItem() {
    return boolItem;
  }

  public void setBoolItem(Boolean boolItem) {
    this.boolItem = boolItem;
  }

  public TypeHolderExample arrayItem(List<Integer> arrayItem) {
    this.arrayItem = arrayItem;
    return this;
  }

  public TypeHolderExample addArrayItemItem(Integer arrayItemItem) {
    if (this.arrayItem == null) {
      this.arrayItem = new ArrayList<>();
    }
    this.arrayItem.add(arrayItemItem);
    return this;
  }

  /**
   * Get arrayItem
   * @return arrayItem
   */
  @NotNull 
  @ApiModelProperty(example = "[0,1,2,3]", required = true, value = "")
  @JsonProperty("array_item")
  public List<Integer> getArrayItem() {
    return arrayItem;
  }

  public void setArrayItem(List<Integer> arrayItem) {
    this.arrayItem = arrayItem;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TypeHolderExample typeHolderExample = (TypeHolderExample) o;
    return Objects.equals(this.stringItem, typeHolderExample.stringItem) &&
        Objects.equals(this.numberItem, typeHolderExample.numberItem) &&
        Objects.equals(this.floatItem, typeHolderExample.floatItem) &&
        Objects.equals(this.integerItem, typeHolderExample.integerItem) &&
        Objects.equals(this.boolItem, typeHolderExample.boolItem) &&
        Objects.equals(this.arrayItem, typeHolderExample.arrayItem);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stringItem, numberItem, floatItem, integerItem, boolItem, arrayItem);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TypeHolderExample {\n");
    sb.append("    stringItem: ").append(toIndentedString(stringItem)).append("\n");
    sb.append("    numberItem: ").append(toIndentedString(numberItem)).append("\n");
    sb.append("    floatItem: ").append(toIndentedString(floatItem)).append("\n");
    sb.append("    integerItem: ").append(toIndentedString(integerItem)).append("\n");
    sb.append("    boolItem: ").append(toIndentedString(boolItem)).append("\n");
    sb.append("    arrayItem: ").append(toIndentedString(arrayItem)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
  public static class Builder {

    private TypeHolderExample instance;

    public Builder() {
      this(new TypeHolderExample());
    }

    protected Builder(TypeHolderExample instance) {
      this.instance = instance;
    }

    protected Builder copyOf(TypeHolderExample value) { 
      this.instance.setStringItem(value.stringItem);
      this.instance.setNumberItem(value.numberItem);
      this.instance.setFloatItem(value.floatItem);
      this.instance.setIntegerItem(value.integerItem);
      this.instance.setBoolItem(value.boolItem);
      this.instance.setArrayItem(value.arrayItem);
      return this;
    }

    public TypeHolderExample.Builder stringItem(String stringItem) {
      this.instance.stringItem(stringItem);
      return this;
    }
    
    public TypeHolderExample.Builder numberItem(BigDecimal numberItem) {
      this.instance.numberItem(numberItem);
      return this;
    }
    
    public TypeHolderExample.Builder floatItem(Float floatItem) {
      this.instance.floatItem(floatItem);
      return this;
    }
    
    public TypeHolderExample.Builder integerItem(Integer integerItem) {
      this.instance.integerItem(integerItem);
      return this;
    }
    
    public TypeHolderExample.Builder boolItem(Boolean boolItem) {
      this.instance.boolItem(boolItem);
      return this;
    }
    
    public TypeHolderExample.Builder arrayItem(List<Integer> arrayItem) {
      this.instance.arrayItem(arrayItem);
      return this;
    }
    
    /**
    * returns a built TypeHolderExample instance.
    *
    * The builder is not reusable (NullPointerException)
    */
    public TypeHolderExample build() {
      try {
        return this.instance;
      } finally {
        // ensure that this.instance is not reused
        this.instance = null;
      }
    }

    @Override
    public String toString() {
      return getClass() + "=(" + instance + ")";
    }
  }

  /**
  * Create a builder with no initialized field (except for the default values).
  */
  public static TypeHolderExample.Builder builder() {
    return new TypeHolderExample.Builder();
  }

  /**
  * Create a builder with a shallow copy of this instance.
  */
  public TypeHolderExample.Builder toBuilder() {
    TypeHolderExample.Builder builder = new TypeHolderExample.Builder();
    return builder.copyOf(this);
  }

}

