/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */

// this model was generated using model.mustache
package sample.cask.model
import java.time.LocalDate
import java.time.OffsetDateTime
import java.util.UUID
import scala.math.BigDecimal
import ujson.Value

import scala.util.control.NonFatal

// see https://com-lihaoyi.github.io/upickle/
import upickle.default.{ReadWriter => RW, macroRW}
import upickle.default.*


        
case class ComplexRequest(
    `type`: ComplexRequest.TypeEnum,
        /* A required string field */
    requiredField: String,
        /* String with length constraints */
    stringField: Option[String] = None ,
        /* Integer with a range from 1 to 100 */
    integerField: Option[Int] = None ,
        /* Number with exclusive minimum and maximum constraints */
    numberField: Option[BigDecimal] = None ,
        /* A boolean field */
    booleanField: Option[Boolean] = None ,
        /* A valid email address */
    emailField: Option[String] = None ,
        /* A valid UUID */
    uuidField: Option[UUID] = None ,
        /* A date field (YYYY-MM-DD) */
    dateField: Option[LocalDate] = None ,
        /* A date-time field (RFC 3339 format) */
    dateTimeField: Option[OffsetDateTime] = None ,
        /* An array of strings with min and max items constraints */
    arrayField: Seq[String] = Nil ,
        /* A string field with enum validation */
    enumField: Option[ComplexRequest.EnumFieldEnum] = None ,
    nestedObject: Option[ComplexRequestNestedObject] = None ,
    arrayOfObjectsField: Seq[ComplexRequestArrayOfObjectsFieldInner] = Nil ,
        /* A string field with regex pattern validation */
    patternField: Option[String] = None ,
        /* A string field that allows null values */
    nullableField: Option[String] = None 

, additionalProperties : ujson.Value =  ujson.Null
) {

def asJsonString: String = asData.asJsonString
def asJson: ujson.Value = asData.asJson

def asData : ComplexRequestData = {
ComplexRequestData(
    `type` = `type` /* 2 */,
    requiredField = requiredField /* 2 */,
    stringField = stringField.getOrElse("") /*  1 */,
    integerField = integerField.getOrElse(0) /*  1 */,
    numberField = numberField.getOrElse(0) /*  1 */,
    booleanField = booleanField.getOrElse(false) /*  1 */,
    emailField = emailField.getOrElse("") /*  1 */,
    uuidField = uuidField.getOrElse(java.util.UUID.randomUUID()) /*  1 */,
    dateField = dateField.getOrElse(null) /*  1 */,
    dateTimeField = dateTimeField.getOrElse(null) /*  1 */,
    arrayField = arrayField /* 2 */,
    enumField = enumField.getOrElse(null) /*  1 */,
    nestedObject = nestedObject.map(_.asData).getOrElse(null) /* 4 */,
    arrayOfObjectsField = arrayOfObjectsField.map(_.asData) /* 6 */,
    patternField = patternField.getOrElse("") /*  1 */,
    nullableField = nullableField.getOrElse("") /*  1 */
, additionalProperties
)
}
}

object ComplexRequest {
given RW[ComplexRequest] = summon[RW[ujson.Value]].bimap[ComplexRequest](_.asJson, json => read[ComplexRequestData](json).asModel)

enum Fields(val fieldName : String) extends Field(fieldName) {
    case `type` extends Fields("`type`")
    case requiredField extends Fields("requiredField")
    case stringField extends Fields("stringField")
    case integerField extends Fields("integerField")
    case numberField extends Fields("numberField")
    case booleanField extends Fields("booleanField")
    case emailField extends Fields("emailField")
    case uuidField extends Fields("uuidField")
    case dateField extends Fields("dateField")
    case dateTimeField extends Fields("dateTimeField")
    case arrayField extends Fields("arrayField")
    case enumField extends Fields("enumField")
    case nestedObject extends Fields("nestedObject")
    case arrayOfObjectsField extends Fields("arrayOfObjectsField")
    case patternField extends Fields("patternField")
    case nullableField extends Fields("nullableField")
}

        // baseName=type
        // nameInCamelCase = `type`
        enum TypeEnum derives ReadWriter {
            case someEnum
        }
        // baseName=enumField
        // nameInCamelCase = enumField
        enum EnumFieldEnum derives ReadWriter {
            case value1
            case value2
            case value3
        }

}


